/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is generated by browser/components/asrouter/bin/import-rollouts.js
 * Run the following from the repository root to regenerate it:
 * ./mach npm run import-rollouts --prefix=browser/components/asrouter
 */

export const NimbusRolloutMessageProvider = {
  getMessages() {
    return [
      {
        // Nimbus slug: recommend-add-ons-staff-pick-relaunch-treatment-a-rollout:treatment-a
        // Version range: 123+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/recommend-add-ons-staff-pick-relaunch-treatment-a-rollout/summary#treatment-a
        id: "ADDONS_STAFF_PICK",
        groups: ["cfr"],
        content: {
          id: "ADDONS_STAFF_PICK",
          screens: [
            {
              id: "ADDONS_STAFF_PICK_A",
              anchors: [
                {
                  selector: "#unified-extensions-button",
                  arrow_width: "26.9",
                  panel_position: {
                    anchor_attachment: "bottomcenter",
                    callout_attachment: "topright",
                  },
                },
              ],
              content: {
                title: {
                  raw: "Give your browsing a boost",
                  marginInline: "0 48px",
                },
                width: "310px",
                padding: 16,
                position: "callout",
                subtitle: {
                  raw: "Make browsing faster, safer, or just plain fun with Firefox add-ons. See what our staff recommends!",
                  paddingInline: "34px 0",
                },
                title_logo: {
                  width: "24px",
                  height: "24px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/173414e1-81f7-4612-b868-e78df0557011.svg",
                  marginInline: "4px 14px",
                },
                dismiss_button: {
                  size: "small",
                  action: {
                    dismiss: true,
                  },
                  marginBlock: "14px 0",
                  marginInline: "0 14px",
                },
                primary_button: {
                  label: {
                    raw: "Explore add-ons",
                  },
                  action: {
                    data: {
                      args: "https://addons.mozilla.org/en-US/firefox/collections/4757633/25c2b44583534b3fa8fea977c419cd/?page=1&collection_sort=-added",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    dismiss: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: false,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "feature_callout",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "!screenImpressions.AW_AMO_INTRODUCE && !willShowDefaultPrompt && !activeNotifications && source == 'newtab' && !isFirstStartup",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 1 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_BACKUP",
              content: {
                logo: {
                  height: "152px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/c92a41e4-82cf-4ad5-8480-04a138bfb3cd.png",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "20px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-heavy-user-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=dont-forget-to-backup&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && (((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 2 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_PEACE",
              content: {
                logo: {
                  height: "133px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/4a56d3ed-98c8-4a33-b853-b2cf7646efd8.png",
                  marginBlock: "22px -10px",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-older-device-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-older-device-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-older-device-primary-button",
                    marginBlock: "0 22px",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=peace-of-mind&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population-esr:treatment (message 3 of 3)
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population-esr/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_NEW_DEVICE",
              content: {
                logo: {
                  height: "149px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a43cd9cc-e8b2-477c-92f2-345557370de1.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-header-2",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-body-2",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-getting-new-device-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=new-device-in-your-future&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && !(os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 1 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_BACKUP",
              content: {
                logo: {
                  height: "152px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/c92a41e4-82cf-4ad5-8480-04a138bfb3cd.png",
                },
                title: {
                  fontSize: "24px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-heavy-user-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "20px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-heavy-user-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=dont-forget-to-backup&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && (((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35)",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 2 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_PEACE",
              content: {
                logo: {
                  height: "133px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/4a56d3ed-98c8-4a33-b853-b2cf7646efd8.png",
                  marginBlock: "22px -10px",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-older-device-header",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id: "device-migration-fxa-spotlight-older-device-body",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-older-device-primary-button",
                    marginBlock: "0 22px",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=peace-of-mind&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000",
      },
      {
        // Nimbus slug: device-migration-q4-spotlights-remaining-population:treatment (message 3 of 3)
        // Version range: 122+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/device-migration-q4-spotlights-remaining-population/summary#treatment
        id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
        groups: ["eco"],
        content: {
          id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT",
          modal: "tab",
          screens: [
            {
              id: "Q4_DEVICE_MIGRATION_BACKUP_SPOTLIGHT_NEW_DEVICE",
              content: {
                logo: {
                  height: "149px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/a43cd9cc-e8b2-477c-92f2-345557370de1.svg",
                },
                title: {
                  fontSize: "24px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-header-2",
                  letterSpacing: 0,
                },
                subtitle: {
                  fontSize: "15px",
                  string_id:
                    "device-migration-fxa-spotlight-getting-new-device-body-2",
                  lineHeight: "1.4",
                  marginBlock: "8px 20px",
                  letterSpacing: 0,
                  paddingInline: "40px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    string_id:
                      "device-migration-fxa-spotlight-getting-new-device-primary-button",
                    paddingBlock: "4px",
                    paddingInline: "16px",
                  },
                  action: {
                    data: {
                      args: "https://support.mozilla.org/1/firefox/%VERSION%/%OS%/%LOCALE%/switching-devices?utm_source=spotlight-default&utm_medium=firefox-desktop&utm_campaign=migration&utm_content=new-device-in-your-future&entrypoint=device-migration-spotlight-experiment-v2",
                      where: "tabshifted",
                    },
                    type: "OPEN_URL",
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && 'browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features'|preferenceValue && !usesFirefoxSync && !hasActiveEnterprisePolicies && userMonthlyActivity[userMonthlyActivity|length - 2][1]|date >= currentDate|date - (28 * 24 * 60 * 60 * 1000) && !(((currentDate|date - profileAgeCreated|date) / 86400000 >= 168) || totalBookmarksCount >= 35) && !(os.isWindows && os.windowsVersion >= 6.1 && os.windowsBuildNumber < 22000)",
      },
    ];
  },
};
