/**
 * @license
 * Copyright 2020 Google Inc.
 * SPDX-License-Identifier: Apache-2.0
 */

const versionsPerRelease = new Map([
  // This is a mapping from Chrome version => Puppeteer version.
  // In Chrome roll patches, use `NEXT` for the Puppeteer version.
  ['126.0.6478.126', 'v22.12.1'],
  ['126.0.6478.63', 'v22.12.0'],
  ['126.0.6478.61', 'v22.11.1'],
  ['126.0.6478.55', 'v22.11.0'],
  ['125.0.6422.141', 'v22.10.1'],
  ['125.0.6422.78', 'v22.10.0'],
  ['125.0.6422.60', 'v22.9.0'],
  ['124.0.6367.207', 'v22.8.2'],
  ['124.0.6367.201', 'v22.8.1'],
  ['124.0.6367.91', 'v22.8.0'],
  ['124.0.6367.78', 'v22.7.1'],
  ['124.0.6367.60', 'v22.7.0'],
  ['123.0.6312.122', 'v22.6.4'],
  ['123.0.6312.105', 'v22.6.3'],
  ['123.0.6312.86', 'v22.6.2'],
  ['123.0.6312.58', 'v22.6.0'],
  ['122.0.6261.128', 'v22.5.0'],
  ['122.0.6261.111', 'v22.4.1'],
  ['122.0.6261.94', 'v22.4.0'],
  ['122.0.6261.69', 'v22.3.0'],
  ['122.0.6261.57', 'v22.2.0'],
  ['121.0.6167.85', 'v21.9.0'],
  ['120.0.6099.109', 'v21.8.0'],
  ['119.0.6045.105', 'v21.5.0'],
  ['118.0.5993.70', 'v21.4.0'],
  ['117.0.5938.149', 'v21.3.7'],
  ['117.0.5938.92', 'v21.3.2'],
  ['117.0.5938.62', 'v21.3.0'],
  ['116.0.5845.96', 'v21.1.0'],
  ['115.0.5790.170', 'v21.0.2'],
  ['115.0.5790.102', 'v21.0.0'],
  ['115.0.5790.98', 'v20.9.0'],
  ['114.0.5735.133', 'v20.7.2'],
  ['114.0.5735.90', 'v20.6.0'],
  ['113.0.5672.63', 'v20.1.0'],
  ['112.0.5615.121', 'v20.0.0'],
  ['112.0.5614.0', 'v19.8.0'],
  ['111.0.5556.0', 'v19.7.0'],
  ['110.0.5479.0', 'v19.6.0'],
  ['109.0.5412.0', 'v19.4.0'],
  ['108.0.5351.0', 'v19.2.0'],
  ['107.0.5296.0', 'v18.1.0'],
  ['106.0.5249.0', 'v17.1.0'],
  ['105.0.5173.0', 'v15.5.0'],
  ['104.0.5109.0', 'v15.1.0'],
  ['103.0.5059.0', 'v14.2.0'],
  ['102.0.5002.0', 'v14.0.0'],
  ['101.0.4950.0', 'v13.6.0'],
  ['100.0.4889.0', 'v13.5.0'],
  ['99.0.4844.16', 'v13.2.0'],
  ['98.0.4758.0', 'v13.1.0'],
  ['97.0.4692.0', 'v12.0.0'],
  ['93.0.4577.0', 'v10.2.0'],
  ['92.0.4512.0', 'v10.0.0'],
  ['91.0.4469.0', 'v9.0.0'],
  ['90.0.4427.0', 'v8.0.0'],
  ['90.0.4403.0', 'v7.0.0'],
  ['89.0.4389.0', 'v6.0.0'],
  ['88.0.4298.0', 'v5.5.0'],
  ['87.0.4272.0', 'v5.4.0'],
  ['86.0.4240.0', 'v5.3.0'],
  ['85.0.4182.0', 'v5.2.1'],
  ['84.0.4147.0', 'v5.1.0'],
  ['83.0.4103.0', 'v3.1.0'],
  ['81.0.4044.0', 'v3.0.0'],
  ['80.0.3987.0', 'v2.1.0'],
  ['79.0.3942.0', 'v2.0.0'],
  ['78.0.3882.0', 'v1.20.0'],
  ['77.0.3803.0', 'v1.19.0'],
  ['76.0.3803.0', 'v1.17.0'],
  ['75.0.3765.0', 'v1.15.0'],
  ['74.0.3723.0', 'v1.13.0'],
  ['73.0.3679.0', 'v1.12.2'],
]);

// Should not be more than 2 major versions behind Chrome Stable (https://chromestatus.com/roadmap).
const lastMaintainedChromeVersion = '123.0.6312.122';

if (!versionsPerRelease.has(lastMaintainedChromeVersion)) {
  throw new Error(
    'lastMaintainedChromeVersion is missing from versionsPerRelease'
  );
}

module.exports = {
  versionsPerRelease,
  lastMaintainedChromeVersion,
};
