/* THIS FILE IS AUTOGENERATED FROM NodeFilter.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_NodeFilterBinding_h
#define mozilla_dom_NodeFilterBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"

class nsINode;

namespace mozilla {
namespace dom {

struct NativePropertyHooks;
class NodeFilter;
struct NodeFilterAtoms;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

namespace NodeFilterBinding {

  typedef mozilla::dom::NodeFilter NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace NodeFilterBinding



class NodeFilter : public CallbackInterface
{
public:
  explicit inline NodeFilter(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline NodeFilter(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline NodeFilter(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  template <typename T>
  inline uint16_t
  AcceptNode(const T& thisVal, nsINode& node, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NodeFilter.acceptNode";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return uint16_t(0);
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return uint16_t(0);
    }
    return AcceptNode(s.GetContext(), thisValJS, node, aRv);
  }

  inline uint16_t
  AcceptNode(nsINode& node, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NodeFilter.acceptNode";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return uint16_t(0);
    }
    return AcceptNode(s.GetContext(), JS::UndefinedHandleValue, node, aRv);
  }

  template <typename T>
  inline uint16_t
  AcceptNode(const T& thisVal, nsINode& node, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return AcceptNode(thisVal, node, rv, aExecutionReason);
  }

  inline uint16_t
  AcceptNode(nsINode& node, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return AcceptNode(node, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NodeFilter& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

private:
  uint16_t AcceptNode(JSContext* cx, JS::Handle<JS::Value> aThisVal, nsINode& node, ErrorResult& aRv);

  static bool
  InitIds(JSContext* cx, NodeFilterAtoms* atomsCache);
};


namespace binding_detail {
class FastNodeFilter : public NodeFilter
{
public:
  explicit inline FastNodeFilter(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : NodeFilter(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NodeFilter::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    NodeFilter::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_NodeFilterBinding_h
