/* THIS FILE IS AUTOGENERATED FROM Navigator.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_NavigatorBinding_h
#define mozilla_dom_NavigatorBinding_h

#include "js/RootingAPI.h"
#include "jsfriendapi.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

class nsIVariant;

namespace mozilla {

class DOMMediaStream;

namespace dom {

class Blob;
class FormData;
class MediaStreamError;
class MozGetUserMediaDevicesSuccessCallback;
class MozIdleObserver;
struct MozIdleObserverAtoms;
struct NativePropertyHooks;
class Navigator;
struct NavigatorAtoms;
class NavigatorUserMediaErrorCallback;
class NavigatorUserMediaSuccessCallback;
class OwningArrayBufferViewOrBlobOrStringOrFormData;
class ProtoAndIfaceCache;

} // namespace dom

} // namespace mozilla

namespace mozilla {
namespace dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningArrayBufferViewOrBlobOrStringOrFormData& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningArrayBufferViewOrBlobOrStringOrFormData& aUnion);


class ArrayBufferViewOrBlobOrStringOrFormData
{
  friend class ArrayBufferViewOrBlobOrStringOrFormDataArgument;
  enum Type
  {
    eUninitialized,
    eArrayBufferView,
    eBlob,
    eString,
    eFormData
  };

  union Value
  {
    UnionMember<RootedTypedArray<ArrayBufferView> > mArrayBufferView;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<binding_detail::FakeString > mString;
    UnionMember<NonNull<mozilla::dom::FormData> > mFormData;

  };

  Type mType;
  Value mValue;

  ArrayBufferViewOrBlobOrStringOrFormData(const ArrayBufferViewOrBlobOrStringOrFormData&) = delete;
  void operator=(const ArrayBufferViewOrBlobOrStringOrFormData&) = delete;
public:
  explicit inline ArrayBufferViewOrBlobOrStringOrFormData()
    : mType(eUninitialized)
  {
  }

  inline ~ArrayBufferViewOrBlobOrStringOrFormData()
  {
    Uninit();
  }

  inline RootedTypedArray<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedTypedArray<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedTypedArray<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline binding_detail::FakeString&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline binding_detail::FakeString&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline NonNull<mozilla::dom::FormData>&
  RawSetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline NonNull<mozilla::dom::FormData>&
  SetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    Uninit();
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline NonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline mozilla::dom::FormData&
  GetAsFormData() const
  {
    MOZ_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
      case eFormData: {
        DestroyFormData();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyFormData()
  {
    MOZ_ASSERT(IsFormData(), "Wrong type!");
    mValue.mFormData.Destroy();
    mType = eUninitialized;
  }
};


class OwningArrayBufferViewOrBlobOrStringOrFormData : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningArrayBufferViewOrBlobOrStringOrFormData& aUnion);
  enum Type
  {
    eUninitialized,
    eArrayBufferView,
    eBlob,
    eString,
    eFormData
  };

  union Value
  {
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<nsString > mString;
    UnionMember<OwningNonNull<mozilla::dom::FormData> > mFormData;

  };

  Type mType;
  Value mValue;

  OwningArrayBufferViewOrBlobOrStringOrFormData(const OwningArrayBufferViewOrBlobOrStringOrFormData&) = delete;
  void operator=(const OwningArrayBufferViewOrBlobOrStringOrFormData&) = delete;
public:
  explicit inline OwningArrayBufferViewOrBlobOrStringOrFormData()
    : mType(eUninitialized)
  {
  }

  inline ~OwningArrayBufferViewOrBlobOrStringOrFormData()
  {
    Uninit();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  bool
  TrySetToArrayBufferView(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  bool
  TrySetToBlob(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  nsString&
  RawSetAsString();

  nsString&
  SetAsString();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  SetStringData(const nsString::char_type* aData, nsString::size_type aLength)
  {
    RawSetAsString().Assign(aData, aLength);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  OwningNonNull<mozilla::dom::FormData>&
  RawSetAsFormData();

  OwningNonNull<mozilla::dom::FormData>&
  SetAsFormData();

  bool
  TrySetToFormData(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline OwningNonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline OwningNonNull<mozilla::dom::FormData> const &
  GetAsFormData() const
  {
    MOZ_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

private:
  void
  DestroyArrayBufferView();

  void
  DestroyBlob();

  void
  DestroyString();

  void
  DestroyFormData();
};


class NavigatorUserMediaSuccessCallback : public CallbackFunction
{
public:
  explicit inline NavigatorUserMediaSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMMediaStream& stream, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, stream, aRv);
  }

  inline void
  Call(DOMMediaStream& stream, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, stream, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, DOMMediaStream& stream, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, stream, rv, aExecutionReason);
  }

  inline void
  Call(DOMMediaStream& stream, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(stream, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NavigatorUserMediaSuccessCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, DOMMediaStream& stream, ErrorResult& aRv);
};


class NavigatorUserMediaErrorCallback : public CallbackFunction
{
public:
  explicit inline NavigatorUserMediaErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, MediaStreamError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, error, aRv);
  }

  inline void
  Call(MediaStreamError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, MediaStreamError& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, error, rv, aExecutionReason);
  }

  inline void
  Call(MediaStreamError& error, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(error, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NavigatorUserMediaErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, MediaStreamError& error, ErrorResult& aRv);
};


class MozGetUserMediaDevicesSuccessCallback : public CallbackFunction
{
public:
  explicit inline MozGetUserMediaDevicesSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MozGetUserMediaDevicesSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MozGetUserMediaDevicesSuccessCallback(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline MozGetUserMediaDevicesSuccessCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisVal, nsIVariant* devices, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "MozGetUserMediaDevicesSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisValJS, devices, aRv);
  }

  inline void
  Call(nsIVariant* devices, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr)
  {
    if (!aExecutionReason) {
      aExecutionReason = "MozGetUserMediaDevicesSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aCompartment);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetContext(), JS::UndefinedHandleValue, devices, aRv);
  }

  template <typename T>
  inline void
  Call(const T& thisVal, nsIVariant* devices, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(thisVal, devices, rv, aExecutionReason);
  }

  inline void
  Call(nsIVariant* devices, const char* aExecutionReason = nullptr)
  {
    IgnoredErrorResult rv;
    return Call(devices, rv, aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const MozGetUserMediaDevicesSuccessCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  void Call(JSContext* cx, JS::Handle<JS::Value> aThisVal, nsIVariant* devices, ErrorResult& aRv);
};


namespace binding_detail {
class FastNavigatorUserMediaSuccessCallback : public NavigatorUserMediaSuccessCallback
{
public:
  explicit inline FastNavigatorUserMediaSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : NavigatorUserMediaSuccessCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NavigatorUserMediaSuccessCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    NavigatorUserMediaSuccessCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastNavigatorUserMediaErrorCallback : public NavigatorUserMediaErrorCallback
{
public:
  explicit inline FastNavigatorUserMediaErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : NavigatorUserMediaErrorCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NavigatorUserMediaErrorCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    NavigatorUserMediaErrorCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace binding_detail {
class FastMozGetUserMediaDevicesSuccessCallback : public MozGetUserMediaDevicesSuccessCallback
{
public:
  explicit inline FastMozGetUserMediaDevicesSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : MozGetUserMediaDevicesSuccessCallback(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    MozGetUserMediaDevicesSuccessCallback::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    MozGetUserMediaDevicesSuccessCallback::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


namespace NavigatorBinding {

  typedef mozilla::dom::Navigator NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::Navigator* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  ClearCachedActiveVRDisplaysValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedUserAgentValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedLanguageValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedLanguagesValue(mozilla::dom::Navigator* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace NavigatorBinding



class MozIdleObserver : public CallbackInterface
{
public:
  explicit inline MozIdleObserver(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal)
  {
  }

  explicit inline MozIdleObserver(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal, const FastCallbackConstructor& )
    : CallbackInterface(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  explicit inline MozIdleObserver(JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackInterface(aCallback, aAsyncStack, aIncumbentGlobal)
  {
  }

  void Onidle(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr);

  void Onactive(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr);

  inline bool
  operator==(const MozIdleObserver& aOther) const
  {
    return CallbackInterface::operator==(aOther);
  }

  uint32_t GetTime(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JSCompartment* aCompartment = nullptr);

private:
  static bool
  InitIds(JSContext* cx, MozIdleObserverAtoms* atomsCache);
};


namespace binding_detail {
class FastMozIdleObserver : public MozIdleObserver
{
public:
  explicit inline FastMozIdleObserver(JSContext* aCx, JS::Handle<JSObject*> aCallback, nsIGlobalObject* aIncumbentGlobal)
    : MozIdleObserver(aCx, aCallback, aIncumbentGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    MozIdleObserver::Trace(aTracer);
  }

  inline void
  HoldJSObjectsIfMoreThanOneOwner()
  {
    MozIdleObserver::HoldJSObjectsIfMoreThanOneOwner();
  }
};
} // namespace binding_detail


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_NavigatorBinding_h
