/* THIS FILE IS AUTOGENERATED FROM IDBRequest.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_IDBRequestBinding_h
#define mozilla_dom_IDBRequestBinding_h

#include "js/RootingAPI.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class IDBCursor;
class IDBIndex;
class IDBObjectStore;
class IDBRequest;
struct IDBRequestAtoms;
struct NativePropertyHooks;
class OwningIDBObjectStoreOrIDBIndexOrIDBCursor;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

enum class IDBRequestReadyState : uint32_t {
  Pending,
  Done,
  EndGuard_
};

namespace IDBRequestReadyStateValues {
extern const EnumEntry strings[3];
} // namespace IDBRequestReadyStateValues

bool
ToJSValue(JSContext* aCx, IDBRequestReadyState aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningIDBObjectStoreOrIDBIndexOrIDBCursor& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndexOrIDBCursor& aUnion);


class IDBObjectStoreOrIDBIndexOrIDBCursor
{
  friend class IDBObjectStoreOrIDBIndexOrIDBCursorArgument;
  enum Type
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex,
    eIDBCursor
  };

  union Value
  {
    UnionMember<NonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<NonNull<mozilla::dom::IDBIndex> > mIDBIndex;
    UnionMember<NonNull<mozilla::dom::IDBCursor> > mIDBCursor;

  };

  Type mType;
  Value mValue;

  IDBObjectStoreOrIDBIndexOrIDBCursor(const IDBObjectStoreOrIDBIndexOrIDBCursor&) = delete;
  void operator=(const IDBObjectStoreOrIDBIndexOrIDBCursor&) = delete;
public:
  explicit inline IDBObjectStoreOrIDBIndexOrIDBCursor()
    : mType(eUninitialized)
  {
  }

  inline ~IDBObjectStoreOrIDBIndexOrIDBCursor()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore()
  {
    if (mType == eIDBObjectStore) {
      return mValue.mIDBObjectStore.Value();
    }
    Uninit();
    mType = eIDBObjectStore;
    return mValue.mIDBObjectStore.SetValue();
  }

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline NonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline mozilla::dom::IDBObjectStore&
  GetAsIDBObjectStore() const
  {
    MOZ_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex()
  {
    if (mType == eIDBIndex) {
      return mValue.mIDBIndex.Value();
    }
    Uninit();
    mType = eIDBIndex;
    return mValue.mIDBIndex.SetValue();
  }

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline NonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline mozilla::dom::IDBIndex&
  GetAsIDBIndex() const
  {
    MOZ_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline NonNull<mozilla::dom::IDBCursor>&
  RawSetAsIDBCursor()
  {
    if (mType == eIDBCursor) {
      return mValue.mIDBCursor.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eIDBCursor;
    return mValue.mIDBCursor.SetValue();
  }

  inline NonNull<mozilla::dom::IDBCursor>&
  SetAsIDBCursor()
  {
    if (mType == eIDBCursor) {
      return mValue.mIDBCursor.Value();
    }
    Uninit();
    mType = eIDBCursor;
    return mValue.mIDBCursor.SetValue();
  }

  inline bool
  IsIDBCursor() const
  {
    return mType == eIDBCursor;
  }

  inline NonNull<mozilla::dom::IDBCursor>&
  GetAsIDBCursor()
  {
    MOZ_ASSERT(IsIDBCursor(), "Wrong type!");
    return mValue.mIDBCursor.Value();
  }

  inline mozilla::dom::IDBCursor&
  GetAsIDBCursor() const
  {
    MOZ_ASSERT(IsIDBCursor(), "Wrong type!");
    return mValue.mIDBCursor.Value();
  }

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eIDBObjectStore: {
        DestroyIDBObjectStore();
        break;
      }
      case eIDBIndex: {
        DestroyIDBIndex();
        break;
      }
      case eIDBCursor: {
        DestroyIDBCursor();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  inline void
  DestroyIDBObjectStore()
  {
    MOZ_ASSERT(IsIDBObjectStore(), "Wrong type!");
    mValue.mIDBObjectStore.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyIDBIndex()
  {
    MOZ_ASSERT(IsIDBIndex(), "Wrong type!");
    mValue.mIDBIndex.Destroy();
    mType = eUninitialized;
  }

  inline void
  DestroyIDBCursor()
  {
    MOZ_ASSERT(IsIDBCursor(), "Wrong type!");
    mValue.mIDBCursor.Destroy();
    mType = eUninitialized;
  }
};


class OwningIDBObjectStoreOrIDBIndexOrIDBCursor : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningIDBObjectStoreOrIDBIndexOrIDBCursor& aUnion);
  enum Type
  {
    eUninitialized,
    eIDBObjectStore,
    eIDBIndex,
    eIDBCursor
  };

  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::IDBObjectStore> > mIDBObjectStore;
    UnionMember<OwningNonNull<mozilla::dom::IDBIndex> > mIDBIndex;
    UnionMember<OwningNonNull<mozilla::dom::IDBCursor> > mIDBCursor;

  };

  Type mType;
  Value mValue;

public:
  explicit inline OwningIDBObjectStoreOrIDBIndexOrIDBCursor()
    : mType(eUninitialized)
  {
  }

  explicit inline OwningIDBObjectStoreOrIDBIndexOrIDBCursor(const OwningIDBObjectStoreOrIDBIndexOrIDBCursor& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningIDBObjectStoreOrIDBIndexOrIDBCursor()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::IDBObjectStore>&
  RawSetAsIDBObjectStore();

  OwningNonNull<mozilla::dom::IDBObjectStore>&
  SetAsIDBObjectStore();

  bool
  TrySetToIDBObjectStore(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsIDBObjectStore() const
  {
    return mType == eIDBObjectStore;
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore>&
  GetAsIDBObjectStore()
  {
    MOZ_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBObjectStore> const &
  GetAsIDBObjectStore() const
  {
    MOZ_ASSERT(IsIDBObjectStore(), "Wrong type!");
    return mValue.mIDBObjectStore.Value();
  }

  OwningNonNull<mozilla::dom::IDBIndex>&
  RawSetAsIDBIndex();

  OwningNonNull<mozilla::dom::IDBIndex>&
  SetAsIDBIndex();

  bool
  TrySetToIDBIndex(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsIDBIndex() const
  {
    return mType == eIDBIndex;
  }

  inline OwningNonNull<mozilla::dom::IDBIndex>&
  GetAsIDBIndex()
  {
    MOZ_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBIndex> const &
  GetAsIDBIndex() const
  {
    MOZ_ASSERT(IsIDBIndex(), "Wrong type!");
    return mValue.mIDBIndex.Value();
  }

  OwningNonNull<mozilla::dom::IDBCursor>&
  RawSetAsIDBCursor();

  OwningNonNull<mozilla::dom::IDBCursor>&
  SetAsIDBCursor();

  bool
  TrySetToIDBCursor(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline bool
  IsIDBCursor() const
  {
    return mType == eIDBCursor;
  }

  inline OwningNonNull<mozilla::dom::IDBCursor>&
  GetAsIDBCursor()
  {
    MOZ_ASSERT(IsIDBCursor(), "Wrong type!");
    return mValue.mIDBCursor.Value();
  }

  inline OwningNonNull<mozilla::dom::IDBCursor> const &
  GetAsIDBCursor() const
  {
    MOZ_ASSERT(IsIDBCursor(), "Wrong type!");
    return mValue.mIDBCursor.Value();
  }

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  void
  operator=(const OwningIDBObjectStoreOrIDBIndexOrIDBCursor& aOther);

private:
  void
  DestroyIDBObjectStore();

  void
  DestroyIDBIndex();

  void
  DestroyIDBCursor();
};


namespace IDBRequestBinding {

  typedef mozilla::dom::IDBRequest NativeType;

  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  bool
  Wrap(JSContext* aCx, mozilla::dom::IDBRequest* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx, bool aDefineOnGlobal = true);

  JSObject*
  GetConstructorObject(JSContext* aCx);

} // namespace IDBRequestBinding



} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_IDBRequestBinding_h
