/*
//@line 38 "/home/cltbld/build/maemo-addonsmgr-nightly/addonsmgr/toolkit/mozapps/extensions/extManager.js"
*/

/**
 * This component serves as integration between the platform and AddonManager.
 * It is responsible for initialisation and shutdown as well as a couple of
 * other things.
 */

 const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;

const PREF_EM_UPDATE_INTERVAL = "extensions.update.interval";

// The old XPInstall error codes
const UNSUPPORTED_TYPE = -244;
const CANT_READ_ARCHIVE = -207;
const USER_CANCELLED = -210;
const DOWNLOAD_ERROR = -228;
const SUCCESS = 0;

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

var gSingleton = null;

function extManager() {
  Components.utils.import("resource://gre/modules/AddonManager.jsm");
}

extManager.prototype = {
  observe: function AMC_observe(subject, topic, data) {
    var os = Cc["@mozilla.org/observer-service;1"].
             getService(Ci.nsIObserverService);

    switch (topic) {
    case "profile-after-change":
      os.addObserver(this, "xpcom-shutdown", false);
      AddonManagerInternal.startup();
      break;
    case "xpcom-shutdown":
      os.removeObserver(this, "xpcom-shutdown");
      AddonManagerInternal.shutdown();
      break;
    }
  },

  /**
   * @see extIManager.idl
   */
  isInstallEnabled: function AMC_isInstallEnabled(type) {
    return AddonManager.isInstallEnabled(type);
  },

  /**
   * @see extIManager.idl
   */
  startInstall: function AMC_startInstall(type, window, referer, uris, hashes,
                                          names, icons, callback) {
    if (uris.length == 0)
      return false;

    let retval = true;
    if (!AddonManager.isInstallAllowed(type, referer)) {
      callback = null;
      retval = false;
    }

    let loadgroup = null;
    try {
      if (window) {
        loadgroup = window.QueryInterface(Ci.nsIInterfaceRequestor)
                          .getInterface(Ci.nsIWebNavigation)
                          .QueryInterface(Ci.nsIDocumentLoader).loadGroup;
      }
    }
    catch (e) {
    }

    let installs = [];
    function buildNextInstall() {
      if (uris.length == 0) {
        AddonManager.startInstallation(type, window, referer, installs);
        return;
      }
      let uri = uris.shift();
      AddonManager.getInstallForURL(uri, function(install) {
        if (install) {
          installs.push(install);
          if (callback) {
            install.addListener({
              onDownloadCancelled: function(install) {
                callback.callback(uri, USER_CANCELLED);
              },

              onDownloadFailed: function(install, error) {
                if (error == AddonManager.DOWNLOADERROR_CORRUPT_FILE)
                  callback.callback(uri, CANT_READ_ARCHIVE);
                else
                  callback.callback(uri, DOWNLOAD_ERROR);
              },

              onInstallFailed: function(install, error) {
              },

              onInstallEnded: function(install, status) {
                callback.callback(uri, SUCCESS);
              }
            });
          }
        }
        else if (callback) {
          callback.callback(uri, UNSUPPORTED_TYPE);
        }
        buildNextInstall();
      }, type, hashes.shift(), names.shift(), icons.shift(), null, loadgroup);
    }
    buildNextInstall();

    return retval;
  },

  notify: function EM_notify(timer) {
    AddonManagerInternal.backgroundUpdateCheck();
  },

  classDescription: "Addons Manager",
  contractID: "@mozilla.org/extensions/manager;2",
  classID: Components.ID("{4399533d-08d1-458c-a87a-235f74451cfa}"),
  _xpcom_categories: [{ category: "profile-after-change" },
                      { category: "update-timer",
                        value: "@mozilla.org/extensions/manager;2," +
                               "getService,addon-background-update-timer," +
                               PREF_EM_UPDATE_INTERVAL + ",86400" }],
  _xpcom_factory: {
    createInstance: function(outer, iid) {
      if (outer != null)
        throw Cr.NS_ERROR_NO_AGGREGATION;
  
      if (!gSingleton)
        gSingleton = new extManager();
      return gSingleton.QueryInterface(iid);
    }
  },
  QueryInterface: XPCOMUtils.generateQI([Ci.extIManager,
                                         Ci.nsITimerCallback,
                                         Ci.nsIObserver])
};

function NSGetModule(compMgr, fileSpec)
  XPCOMUtils.generateModule([extManager]);
