//@line 38 "/home/cltbld/build/maemo-addonsmgr-nightly/addonsmgr/toolkit/mozapps/extensions/content/about.js"

function init() {
  var addon = window.arguments[0];
  var extensionsStrings = document.getElementById("extensionsStrings");

  document.title = extensionsStrings.getFormattedString("aboutWindowTitle", [addon.name]);
  var extensionName = document.getElementById("extensionName");
  extensionName.setAttribute("value", addon.name);

  var extensionVersion = document.getElementById("extensionVersion");
  if (addon.version)
    extensionVersion.setAttribute("value", extensionsStrings.getFormattedString("aboutWindowVersionString", [addon.version]));
  else
    extensionVersion.hidden = true;

  var extensionDescription = document.getElementById("extensionDescription");
  if (addon.description)
    extensionDescription.appendChild(document.createTextNode(addon.description));
  else
    extensionDescription.hidden = true;

  var extensionCreator = document.getElementById("extensionCreator");
  extensionCreator.setAttribute("value", addon.creator);

  var extensionHomepage = document.getElementById("extensionHomepage");
  var homepageURL = addon.homepageURL;
  if (homepageURL) {
    extensionHomepage.setAttribute("homepageURL", homepageURL);
    extensionHomepage.setAttribute("tooltiptext", homepageURL);
  } else {
    extensionHomepage.hidden = true;
  }

  appendContributors("extensionDevelopers", "developersBox", addon.developers);
  appendContributors("extensionTranslators", "translatorsBox", addon.translators);
  appendContributors("extensionContributors", "contributorsBox", addon.contributors);

  var acceptButton = document.documentElement.getButton("accept");
  acceptButton.label = extensionsStrings.getString("aboutWindowCloseButton");
}

function appendContributors(aHeaderId, aNodeId, aContributors) {
  var header = document.getElementById(aHeaderId);
  var node = document.getElementById(aNodeId);

  if (!aContributors || aContributors.length == 0) {
    header.hidden = true;
    return;
  }

  for (let i = 0; i < aContributors.length; i++) {
    var label = document.createElement("label");
    label.setAttribute("value", aContributors[i]);
    label.setAttribute("class", "contributor");
    node.appendChild(label);
  }
}

function loadHomepage(aEvent) {
  window.close();
  openURL(aEvent.target.getAttribute("homepageURL"));
}
