//@line 38 "/home/cltbld/build/mobile-electrolysis-maemo5-qt-nightly/electrolysis/toolkit/mozapps/extensions/content/about.js"

function init() {
  var addon = window.arguments[0];
  var extensionsStrings = document.getElementById("extensionsStrings");

  document.title = extensionsStrings.getFormattedString("aboutWindowTitle", [addon.name]);
  var extensionName = document.getElementById("extensionName");
  extensionName.setAttribute("value", addon.name);

  var extensionVersion = document.getElementById("extensionVersion");
  if (addon.version)
    extensionVersion.setAttribute("value", extensionsStrings.getFormattedString("aboutWindowVersionString", [addon.version]));
  else
    extensionVersion.hidden = true;

  var extensionDescription = document.getElementById("extensionDescription");
  if (addon.description)
    extensionDescription.textContent = addon.description;
  else
    extensionDescription.hidden = true;

  var extensionCreator = document.getElementById("extensionCreator");
  extensionCreator.setAttribute("value", addon.creator);

  var extensionHomepage = document.getElementById("extensionHomepage");
  var homepageURL = addon.homepageURL;
  if (homepageURL) {
    extensionHomepage.setAttribute("homepageURL", homepageURL);
    extensionHomepage.setAttribute("tooltiptext", homepageURL);
  } else {
    extensionHomepage.hidden = true;
  }

  appendToList("extensionDevelopers", "developersBox", addon.developers);
  appendToList("extensionTranslators", "translatorsBox", addon.translators);
  appendToList("extensionContributors", "contributorsBox", addon.contributors);

  var acceptButton = document.documentElement.getButton("accept");
  acceptButton.label = extensionsStrings.getString("aboutWindowCloseButton");
}

function appendToList(aHeaderId, aNodeId, aItems) {
  var header = document.getElementById(aHeaderId);
  var node = document.getElementById(aNodeId);

  if (!aItems || aItems.length == 0) {
    header.hidden = true;
    return;
  }

  for (let i = 0; i < aItems.length; i++) {
    var label = document.createElement("label");
    label.setAttribute("value", aItems[i]);
    label.setAttribute("class", "contributor");
    node.appendChild(label);
  }
}

function loadHomepage(aEvent) {
  window.close();
  openURL(aEvent.target.getAttribute("homepageURL"));
}
