/*
 * Decompiled with CFR 0.152.
 */
package com.codebutler.android_websockets;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.codebutler.android_websockets.HybiParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.LineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClient {
    private static final String TAG = "WebSocketClient";
    private URI mURI;
    private Listener mListener;
    private Socket mSocket;
    private Thread mThread;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private List<BasicNameValuePair> mExtraHeaders;
    private HybiParser mParser;
    private boolean mConnected;
    private final Object mSendLock = new Object();
    private static TrustManager[] sTrustManagers;

    public static void setTrustManagers(TrustManager[] trustManagerArray) {
        sTrustManagers = trustManagerArray;
    }

    public WebSocketClient(URI uRI, Listener listener, List<BasicNameValuePair> list) {
        this.mURI = uRI;
        this.mListener = listener;
        this.mExtraHeaders = list;
        this.mConnected = false;
        this.mParser = new HybiParser(this);
        this.mHandlerThread = new HandlerThread("websocket-thread");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    public Listener getListener() {
        return this.mListener;
    }

    public void connect() {
        if (this.mThread != null && this.mThread.isAlive()) {
            return;
        }
        this.mThread = new Thread(new Runnable(){

            public void run() {
                try {
                    String string;
                    BasicNameValuePair basicNameValuePair2;
                    String string2;
                    int n = WebSocketClient.this.mURI.getPort() != -1 ? WebSocketClient.this.mURI.getPort() : (WebSocketClient.this.mURI.getScheme().equals("wss") || WebSocketClient.this.mURI.getScheme().equals("https") ? 443 : 80);
                    String string3 = string2 = TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getPath()) ? "/" : WebSocketClient.this.mURI.getPath();
                    if (!TextUtils.isEmpty((CharSequence)WebSocketClient.this.mURI.getQuery())) {
                        string2 = string2 + "?" + WebSocketClient.this.mURI.getQuery();
                    }
                    String string4 = WebSocketClient.this.mURI.getScheme().equals("wss") ? "https" : "http";
                    URI uRI = new URI(string4, "//" + WebSocketClient.this.mURI.getHost(), null);
                    SSLSocketFactory sSLSocketFactory = WebSocketClient.this.mURI.getScheme().equals("wss") || WebSocketClient.this.mURI.getScheme().equals("https") ? WebSocketClient.this.getSSLSocketFactory() : SocketFactory.getDefault();
                    WebSocketClient.this.mSocket = sSLSocketFactory.createSocket(WebSocketClient.this.mURI.getHost(), n);
                    PrintWriter printWriter = new PrintWriter(WebSocketClient.this.mSocket.getOutputStream());
                    printWriter.print("GET " + string2 + " HTTP/1.1\r\n");
                    printWriter.print("Upgrade: websocket\r\n");
                    printWriter.print("Connection: Upgrade\r\n");
                    printWriter.print("Host: " + WebSocketClient.this.mURI.getHost() + "\r\n");
                    printWriter.print("Origin: " + uRI.toString() + "\r\n");
                    printWriter.print("Sec-WebSocket-Key: " + WebSocketClient.this.createSecret() + "\r\n");
                    printWriter.print("Sec-WebSocket-Version: 13\r\n");
                    if (WebSocketClient.this.mExtraHeaders != null) {
                        for (BasicNameValuePair basicNameValuePair2 : WebSocketClient.this.mExtraHeaders) {
                            printWriter.print(String.format("%s: %s\r\n", basicNameValuePair2.getName(), basicNameValuePair2.getValue()));
                        }
                    }
                    printWriter.print("\r\n");
                    printWriter.flush();
                    HybiParser.HappyDataInputStream happyDataInputStream = new HybiParser.HappyDataInputStream(WebSocketClient.this.mSocket.getInputStream());
                    basicNameValuePair2 = WebSocketClient.this.parseStatusLine(WebSocketClient.this.readLine(happyDataInputStream));
                    if (basicNameValuePair2 == null) {
                        throw new HttpException("Received no reply from server.");
                    }
                    if (basicNameValuePair2.getStatusCode() != 101) {
                        throw new HttpResponseException(basicNameValuePair2.getStatusCode(), basicNameValuePair2.getReasonPhrase());
                    }
                    while (!TextUtils.isEmpty((CharSequence)(string = WebSocketClient.this.readLine(happyDataInputStream)))) {
                        Header header = WebSocketClient.this.parseHeader(string);
                        if (!header.getName().equals("Sec-WebSocket-Accept")) continue;
                    }
                    WebSocketClient.this.mListener.onConnect();
                    WebSocketClient.this.mConnected = true;
                    WebSocketClient.this.mParser.start(happyDataInputStream);
                }
                catch (EOFException eOFException) {
                    Log.d((String)WebSocketClient.TAG, (String)"WebSocket EOF!", (Throwable)eOFException);
                    WebSocketClient.this.mListener.onDisconnect(0, "EOF");
                    WebSocketClient.this.mConnected = false;
                }
                catch (SSLException sSLException) {
                    Log.d((String)WebSocketClient.TAG, (String)"Websocket SSL error!", (Throwable)sSLException);
                    WebSocketClient.this.mListener.onDisconnect(0, "SSL");
                    WebSocketClient.this.mConnected = false;
                }
                catch (Exception exception) {
                    WebSocketClient.this.mListener.onError(exception);
                }
            }
        });
        this.mThread.start();
    }

    public void disconnect() {
        if (this.mSocket != null) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    if (WebSocketClient.this.mSocket != null) {
                        try {
                            WebSocketClient.this.mSocket.close();
                        }
                        catch (IOException iOException) {
                            Log.d((String)WebSocketClient.TAG, (String)"Error while disconnecting", (Throwable)iOException);
                            WebSocketClient.this.mListener.onError(iOException);
                        }
                        WebSocketClient.this.mSocket = null;
                    }
                    WebSocketClient.this.mConnected = false;
                }
            });
        }
    }

    public void send(String string) {
        this.sendFrame(this.mParser.frame(string));
    }

    public void send(byte[] byArray) {
        this.sendFrame(this.mParser.frame(byArray));
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    private StatusLine parseStatusLine(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return BasicLineParser.parseStatusLine((String)string, (LineParser)new BasicLineParser());
    }

    private Header parseHeader(String string) {
        return BasicLineParser.parseHeader((String)string, (LineParser)new BasicLineParser());
    }

    private String readLine(HybiParser.HappyDataInputStream happyDataInputStream) throws IOException {
        int n = happyDataInputStream.read();
        if (n == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        while (n != 10) {
            if (n != 13) {
                stringBuilder.append((char)n);
            }
            if ((n = happyDataInputStream.read()) != -1) continue;
            return null;
        }
        return stringBuilder.toString();
    }

    private String createSecret() {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeToString((byte[])byArray, (int)0).trim();
    }

    void sendFrame(final byte[] byArray) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = WebSocketClient.this.mSendLock;
                    synchronized (object) {
                        OutputStream outputStream = WebSocketClient.this.mSocket.getOutputStream();
                        outputStream.write(byArray);
                        outputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    WebSocketClient.this.mListener.onError(iOException);
                }
            }
        });
    }

    private SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, sTrustManagers, null);
        return sSLContext.getSocketFactory();
    }

    public static interface Listener {
        public void onConnect();

        public void onMessage(String var1);

        public void onMessage(byte[] var1);

        public void onDisconnect(int var1, String var2);

        public void onError(Exception var1);
    }
}

