/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.ProgressDialog;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import org.mozilla.gecko.AndroidImport;
import org.mozilla.gecko.MultiChoicePreference;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ThreadUtils;

class AndroidImportPreference
extends MultiChoicePreference {
    private static final String LOGTAG = "AndroidImport";
    private static final String PREF_KEY_PREFIX = "import_android.data.";
    private Context mContext;

    public AndroidImportPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        CharSequence[] charSequenceArray = this.getEntryKeys();
        boolean[] blArray = this.getValues();
        for (int i = 0; i < charSequenceArray.length; ++i) {
            String string2 = ((Object)charSequenceArray[i]).toString().substring(PREF_KEY_PREFIX.length());
            boolean bl4 = blArray[i];
            if (string2.equals("bookmarks") && bl4) {
                bl2 = true;
            }
            if (!string2.equals("history") || !bl4) continue;
            bl3 = true;
        }
        this.runImport(bl2, bl3);
    }

    protected void runImport(final boolean bl, final boolean bl2) {
        Log.i((String)LOGTAG, (String)"Importing Android history/bookmarks");
        if (!bl && !bl2) {
            return;
        }
        String string2 = bl && bl2 ? this.mContext.getString(R.string.bookmarkhistory_import_both) : (bl ? this.mContext.getString(R.string.bookmarkhistory_import_bookmarks) : this.mContext.getString(R.string.bookmarkhistory_import_history));
        final ProgressDialog progressDialog = ProgressDialog.show((Context)this.mContext, (CharSequence)string2, (CharSequence)this.mContext.getString(R.string.bookmarkhistory_import_wait), (boolean)true);
        final Runnable runnable = new Runnable(){

            public void run() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        progressDialog.dismiss();
                    }
                });
            }
        };
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                new AndroidImport(AndroidImportPreference.this.mContext, runnable, bl, bl2).run();
            }
        });
    }
}

