/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.SystemClock;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.AutocompleteHandler;
import org.mozilla.gecko.BackButton;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.BrowserToolbarBackground;
import org.mozilla.gecko.CustomEditText;
import org.mozilla.gecko.ForwardButton;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.InputMethods;
import org.mozilla.gecko.PageActionLayout;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.ShapedButton;
import org.mozilla.gecko.SiteIdentityPopup;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.TabCounter;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoImageButton;
import org.mozilla.gecko.widget.GeckoImageView;
import org.mozilla.gecko.widget.GeckoRelativeLayout;
import org.mozilla.gecko.widget.GeckoTextView;

public class BrowserToolbar
extends GeckoRelativeLayout
implements TextWatcher,
AutocompleteHandler,
Tabs.OnTabsChangedListener,
GeckoMenu.ActionItemBarPresenter,
Animation.AnimationListener,
GeckoEventListener {
    private static final String LOGTAG = "GeckoToolbar";
    public static final String PREF_TITLEBAR_MODE = "browser.chrome.titlebarMode";
    private RelativeLayout.LayoutParams mAwesomeBarParams;
    private View mUrlDisplayContainer;
    private View mUrlEditContainer;
    private CustomEditText mUrlEditText;
    private View mUrlBarEntry;
    private ImageView mUrlBarRightEdge;
    private BrowserToolbarBackground mUrlBarBackground;
    private GeckoTextView mTitle;
    private int mTitlePadding;
    private boolean mSiteSecurityVisible;
    private boolean mSwitchingTabs;
    private ShapedButton mTabs;
    private ImageButton mBack;
    private ImageButton mForward;
    public ImageButton mFavicon;
    public ImageButton mStop;
    public ImageButton mSiteSecurity;
    public ImageButton mGo;
    public PageActionLayout mPageActionLayout;
    private Animation mProgressSpinner;
    private TabCounter mTabsCounter;
    private ImageView mShadow;
    private GeckoImageButton mMenu;
    private GeckoImageView mMenuIcon;
    private LinearLayout mActionItemBar;
    private MenuPopup mMenuPopup;
    private List<? extends View> mFocusOrder;
    private OnActivateListener mActivateListener;
    private OnCommitListener mCommitListener;
    private OnDismissListener mDismissListener;
    private OnFilterListener mFilterListener;
    private OnStartEditingListener mStartEditingListener;
    private OnStopEditingListener mStopEditingListener;
    private final BrowserApp mActivity;
    private boolean mHasSoftMenuButton;
    private boolean mShowSiteSecurity;
    private boolean mShowReader;
    private boolean mSpinnerVisible;
    private boolean mDelayRestartInput;
    private String mAutoCompleteResult = "";
    private String mAutoCompletePrefix = null;
    private boolean mIsEditing;
    private boolean mAnimatingEntry;
    private AlphaAnimation mLockFadeIn;
    private TranslateAnimation mTitleSlideLeft;
    private TranslateAnimation mTitleSlideRight;
    private int mUrlBarViewOffset;
    private int mDefaultForwardMargin;
    private PropertyAnimator mForwardAnim = null;
    private int mFaviconSize;
    private PropertyAnimator mVisibilityAnimator;
    private static final Interpolator sButtonsInterpolator = new AccelerateInterpolator();
    private static final int TABS_CONTRACTED = 1;
    private static final int TABS_EXPANDED = 2;
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final ForegroundColorSpan mUrlColor;
    private final ForegroundColorSpan mBlockedColor;
    private final ForegroundColorSpan mDomainColor;
    private final ForegroundColorSpan mPrivateDomainColor;
    private boolean mShowUrl;
    private Integer mPrefObserverId;

    public BrowserToolbar(Context context) {
        this(context, null);
    }

    public BrowserToolbar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mActivity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.browser_toolbar, (ViewGroup)this);
        Tabs.registerOnTabsChangedListener(this);
        this.mSwitchingTabs = true;
        this.mIsEditing = false;
        this.mAnimatingEntry = false;
        this.mShowUrl = false;
        this.mPrefObserverId = PrefsHelper.getPref(PREF_TITLEBAR_MODE, new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, String string3) {
                boolean bl;
                int n = Integer.parseInt(string3);
                boolean bl2 = bl = n == 1;
                if (bl == BrowserToolbar.this.mShowUrl) {
                    return;
                }
                BrowserToolbar.this.mShowUrl = bl;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        BrowserToolbar.this.updateTitle();
                    }
                });
            }

            public boolean isObserver() {
                return true;
            }
        });
        Resources resources = this.getResources();
        this.mUrlColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_urltext));
        this.mBlockedColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_blockedtext));
        this.mDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext));
        this.mPrivateDomainColor = new ForegroundColorSpan(resources.getColor(R.color.url_bar_domaintext_private));
        this.registerEventListener("Reader:Click");
        this.registerEventListener("Reader:LongClick");
        this.mShowSiteSecurity = false;
        this.mShowReader = false;
        this.mAnimatingEntry = false;
        this.mUrlBarBackground = (BrowserToolbarBackground)this.findViewById(R.id.url_bar_bg);
        this.mUrlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.mDefaultForwardMargin = resources.getDimensionPixelSize(R.dimen.forward_default_offset);
        this.mUrlDisplayContainer = this.findViewById(R.id.url_display_container);
        this.mUrlBarEntry = this.findViewById(R.id.url_bar_entry);
        this.mUrlEditContainer = this.findViewById(R.id.url_edit_container);
        this.mUrlEditText = (CustomEditText)this.findViewById(R.id.url_edit_text);
        this.mUrlBarRightEdge = (ImageView)this.findViewById(R.id.url_bar_right_edge);
        if (this.mUrlBarRightEdge != null) {
            this.mUrlBarRightEdge.getDrawable().setLevel(6000);
        }
        this.mTitle = (GeckoTextView)this.findViewById(R.id.url_bar_title);
        this.mTitlePadding = this.mTitle.getPaddingRight();
        this.mTabs = (ShapedButton)this.findViewById(R.id.tabs);
        this.mTabsCounter = (TabCounter)this.findViewById(R.id.tabs_counter);
        this.mBack = (ImageButton)this.findViewById(R.id.back);
        this.mForward = (ImageButton)this.findViewById(R.id.forward);
        this.mForward.setEnabled(false);
        this.mFavicon = (ImageButton)this.findViewById(R.id.favicon);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mFavicon.setImportantForAccessibility(2);
        }
        this.mFaviconSize = Math.round(resources.getDimension(R.dimen.browser_toolbar_favicon_size));
        this.mSiteSecurity = (ImageButton)this.findViewById(R.id.site_security);
        this.mSiteSecurityVisible = this.mSiteSecurity.getVisibility() == 0;
        this.mActivity.getSiteIdentityPopup().setAnchor((View)this.mSiteSecurity);
        this.mProgressSpinner = AnimationUtils.loadAnimation((Context)this.mActivity, (int)R.anim.progress_spinner);
        this.mStop = (ImageButton)this.findViewById(R.id.stop);
        this.mShadow = (ImageView)this.findViewById(R.id.shadow);
        this.mPageActionLayout = (PageActionLayout)this.findViewById(R.id.page_action_layout);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mShadow.setImportantForAccessibility(2);
        }
        this.mMenu = (GeckoImageButton)this.findViewById(R.id.menu);
        this.mMenuIcon = (GeckoImageView)this.findViewById(R.id.menu_icon);
        this.mActionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
        this.mHasSoftMenuButton = !HardwareUtils.hasMenuButton();
        this.mFocusOrder = HardwareUtils.isTablet() ? Arrays.asList(new View[]{this.mTabs, this.mBack, this.mForward, this, this.mSiteSecurity, this.mPageActionLayout, this.mStop, this.mActionItemBar, this.mMenu}) : Arrays.asList(new View[]{this, this.mSiteSecurity, this.mPageActionLayout, this.mStop, this.mTabs, this.mMenu});
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mActivateListener != null) {
                    BrowserToolbar.this.mActivateListener.onActivate();
                }
            }
        });
        this.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener(){

            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                Tab tab;
                if (BrowserToolbar.this.isEditing()) {
                    return;
                }
                MenuInflater menuInflater = BrowserToolbar.this.mActivity.getMenuInflater();
                menuInflater.inflate(R.menu.titlebar_contextmenu, (Menu)contextMenu);
                String string2 = Clipboard.getText();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    contextMenu.findItem(R.id.pasteandgo).setVisible(false);
                    contextMenu.findItem(R.id.paste).setVisible(false);
                }
                if ((tab = Tabs.getInstance().getSelectedTab()) != null) {
                    String string3 = tab.getURL();
                    if (string3 == null) {
                        contextMenu.findItem(R.id.copyurl).setVisible(false);
                        contextMenu.findItem(R.id.share).setVisible(false);
                        contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    }
                    if (!tab.getFeedsEnabled()) {
                        contextMenu.findItem(R.id.subscribe).setVisible(false);
                    }
                } else {
                    contextMenu.findItem(R.id.copyurl).setVisible(false);
                    contextMenu.findItem(R.id.share).setVisible(false);
                    contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    contextMenu.findItem(R.id.subscribe).setVisible(false);
                }
                contextMenu.findItem(R.id.share).setVisible(!GeckoProfile.get(BrowserToolbar.this.getContext()).inGuestMode());
            }
        });
        this.mUrlEditText.addTextChangedListener(this);
        this.mUrlEditText.setOnKeyPreImeListener(new CustomEditText.OnKeyPreImeListener(){

            public boolean onKeyPreIme(View view, int n, KeyEvent keyEvent) {
                Editable editable;
                if (keyEvent.getAction() != 0) {
                    return false;
                }
                if (n == 66 && !BrowserToolbar.hasCompositionString(editable = BrowserToolbar.this.mUrlEditText.getText())) {
                    if (BrowserToolbar.this.mCommitListener != null) {
                        BrowserToolbar.this.mCommitListener.onCommit();
                    }
                    return true;
                }
                if (n == 4) {
                    BrowserToolbar.this.clearFocus();
                    return true;
                }
                return false;
            }
        });
        this.mUrlEditText.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (n == 66 || GamepadUtils.isActionKey((KeyEvent)keyEvent)) {
                    if (keyEvent.getAction() != 0) {
                        return true;
                    }
                    if (BrowserToolbar.this.mCommitListener != null) {
                        BrowserToolbar.this.mCommitListener.onCommit();
                    }
                    return true;
                }
                if (GamepadUtils.isBackKey((KeyEvent)keyEvent)) {
                    if (BrowserToolbar.this.mDismissListener != null) {
                        BrowserToolbar.this.mDismissListener.onDismiss();
                    }
                    return true;
                }
                return false;
            }
        });
        this.mUrlEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (view == null) {
                    return;
                }
                BrowserToolbar.this.setSelected(bl);
                if (bl) {
                    return;
                }
                InputMethodManager inputMethodManager = (InputMethodManager)BrowserToolbar.this.mActivity.getSystemService("input_method");
                try {
                    inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
                }
                catch (NullPointerException nullPointerException) {
                    Log.e((String)BrowserToolbar.LOGTAG, (String)"InputMethodManagerService, why are you throwing a NullPointerException? See bug 782096", (Throwable)nullPointerException);
                }
            }
        });
        this.mUrlEditText.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (Build.VERSION.SDK_INT >= 11) {
                    CustomEditText customEditText = (CustomEditText)view;
                    if (customEditText.getSelectionStart() == customEditText.getSelectionEnd()) {
                        return false;
                    }
                    return false;
                }
                return false;
            }
        });
        this.mTabs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BrowserToolbar.this.toggleTabs();
            }
        });
        this.mTabs.setImageLevel(0);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.mBack.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showBackHistory();
            }
        });
        this.mForward.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.mForward.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showForwardHistory();
            }
        });
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mSiteSecurity.getVisibility() != 0) {
                    return;
                }
                JSONObject jSONObject = Tabs.getInstance().getSelectedTab().getIdentityData();
                if (jSONObject == null) {
                    Log.e((String)BrowserToolbar.LOGTAG, (String)"Selected tab has no identity data");
                    return;
                }
                SiteIdentityPopup siteIdentityPopup = BrowserToolbar.this.mActivity.getSiteIdentityPopup();
                siteIdentityPopup.updateIdentity(jSONObject);
                siteIdentityPopup.show();
            }
        };
        this.mFavicon.setOnClickListener(onClickListener);
        this.mSiteSecurity.setOnClickListener(onClickListener);
        this.mStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.doStop();
                }
                BrowserToolbar.this.setProgressVisibility(false);
            }
        });
        this.mGo = (ImageButton)this.findViewById(R.id.go);
        this.mGo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mCommitListener != null) {
                    BrowserToolbar.this.mCommitListener.onCommit();
                }
            }
        });
        float f = this.getResources().getDimension(R.dimen.browser_toolbar_lock_width);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mSiteSecurity.getLayoutParams();
        float f2 = this.getResources().getDisplayMetrics().density;
        this.mLockFadeIn = new AlphaAnimation(0.0f, 1.0f);
        this.mLockFadeIn.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideLeft = new TranslateAnimation(f += (float)(layoutParams.leftMargin + layoutParams.rightMargin) * f2 + 0.5f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideLeft.setAnimationListener((Animation.AnimationListener)this);
        this.mTitleSlideRight = new TranslateAnimation(-f, 0.0f, 0.0f, 0.0f);
        this.mTitleSlideRight.setAnimationListener((Animation.AnimationListener)this);
        this.mLockFadeIn.setDuration(300L);
        this.mTitleSlideLeft.setDuration(300L);
        this.mTitleSlideRight.setDuration(300L);
        if (this.mHasSoftMenuButton) {
            this.mMenu.setVisibility(0);
            this.mMenuIcon.setVisibility(0);
            this.mMenu.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BrowserToolbar.this.mActivity.openOptionsMenu();
                }
            });
        }
    }

    public boolean onKey(int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if (n > KeyEvent.getMaxKeyCode()) {
            return true;
        }
        if (n == 4 || n == 82 || n == 19 || n == 20 || n == 21 || n == 22 || n == 23 || n == 67 || n == 24 || n == 25) {
            return false;
        }
        if (this.isEditing()) {
            int n2 = this.mUrlEditText.getSelectionStart();
            int n3 = this.mUrlEditText.getSelectionEnd();
            this.mUrlEditText.dispatchKeyEvent(keyEvent);
            int n4 = this.mUrlEditText.getSelectionStart();
            int n5 = this.mUrlEditText.getSelectionEnd();
            if (n2 != n4 || n3 != n5) {
                this.mUrlEditText.requestFocusFromTouch();
                this.mUrlEditText.setSelection(n4, n5);
            }
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent != null && motionEvent.getY() > (float)(this.getHeight() - this.getScrollY())) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n2 != n4) {
            this.post(new Runnable(){

                public void run() {
                    BrowserToolbar.this.mActivity.refreshToolbarHeight();
                }
            });
        }
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case TITLE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateTitle();
                break;
            }
            case START: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateBackButton(tab.canDoBack());
                this.updateForwardButton(tab.canDoForward());
                Boolean bl = (Boolean)object;
                if (bl.booleanValue() && tab.getState() == 1) {
                    this.setProgressVisibility(true);
                }
                this.setSecurityMode(tab.getSecurityMode());
                this.setPageActionVisibility(this.mStop.getVisibility() == 0);
                break;
            }
            case STOP: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateBackButton(tab.canDoBack());
                this.updateForwardButton(tab.canDoForward());
                this.setProgressVisibility(false);
                this.updateTitle();
                break;
            }
            case LOADED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateTitle();
                break;
            }
            case RESTORED: 
            case SELECTED: {
                this.updateTabCount(Tabs.getInstance().getDisplayCount());
                this.mSwitchingTabs = true;
            }
            case LOCATION_CHANGE: 
            case LOAD_ERROR: {
                if (Tabs.getInstance().isSelectedTab(tab)) {
                    this.refresh();
                }
                this.mSwitchingTabs = false;
                break;
            }
            case CLOSED: 
            case ADDED: {
                this.updateTabCount(Tabs.getInstance().getDisplayCount());
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updateBackButton(tab.canDoBack());
                this.updateForwardButton(tab.canDoForward());
                break;
            }
            case FAVICON: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.setFavicon(tab.getFavicon());
                break;
            }
            case SECURITY_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.setSecurityMode(tab.getSecurityMode());
                break;
            }
            case READER_ENABLED: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.setPageActionVisibility(this.mStop.getVisibility() == 0);
            }
        }
    }

    public void onAutocomplete(String string2) {
        String string3 = this.mUrlEditText.getText().toString();
        if (string2 == null) {
            this.mAutoCompleteResult = "";
            return;
        }
        if (!string2.startsWith(string3) || string3.equals(string2)) {
            return;
        }
        this.mAutoCompleteResult = string2;
        this.mUrlEditText.getText().append((CharSequence)string2.substring(string3.length()));
        this.mUrlEditText.setSelection(string3.length(), string2.length());
    }

    public void afterTextChanged(Editable editable) {
        String string2 = editable.toString();
        boolean bl = false;
        boolean bl2 = false;
        if (!BrowserToolbar.hasCompositionString(editable) && !StringUtils.isSearchQuery((String)string2, (boolean)false)) {
            bl = true;
            if (this.mAutoCompletePrefix != null && this.mAutoCompletePrefix.length() >= string2.length()) {
                bl = false;
            } else if (this.mAutoCompleteResult != null && this.mAutoCompleteResult.startsWith(string2)) {
                bl = false;
                bl2 = true;
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mAutoCompleteResult) || !this.mAutoCompleteResult.equals(string2)) {
            if (this.isEditing() && this.mFilterListener != null) {
                this.mFilterListener.onFilter(string2, bl ? this : null);
            }
            this.mAutoCompletePrefix = string2;
            if (bl2) {
                this.onAutocomplete(this.mAutoCompleteResult);
            }
        }
        if (!BrowserToolbar.hasCompositionString(editable) || InputMethods.isGestureKeyboard(this.mUrlEditText.getContext())) {
            this.updateGoButton(string2);
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    public boolean isVisible() {
        return this.getScrollY() == 0;
    }

    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.mTabs.setNextFocusDownId(n);
        this.mBack.setNextFocusDownId(n);
        this.mForward.setNextFocusDownId(n);
        this.mFavicon.setNextFocusDownId(n);
        this.mStop.setNextFocusDownId(n);
        this.mSiteSecurity.setNextFocusDownId(n);
        this.mPageActionLayout.setNextFocusDownId(n);
        this.mMenu.setNextFocusDownId(n);
    }

    public void onAnimationStart(Animation animation) {
        if (animation.equals(this.mLockFadeIn)) {
            if (this.mSiteSecurityVisible) {
                this.mSiteSecurity.setVisibility(0);
            }
        } else if (animation.equals(this.mTitleSlideLeft)) {
            this.mSiteSecurity.setVisibility(8);
        } else if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.setVisibility(4);
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (animation.equals(this.mTitleSlideRight)) {
            this.mSiteSecurity.startAnimation((Animation)this.mLockFadeIn);
        }
    }

    private int getUrlBarEntryTranslation() {
        return this.getWidth() - this.mUrlBarEntry.getRight();
    }

    private int getUrlBarCurveTranslation() {
        return this.getWidth() - this.mTabs.getLeft();
    }

    private static boolean hasCompositionString(Editable editable) {
        Object[] objectArray = editable.getSpans(0, editable.length(), Object.class);
        if (objectArray != null) {
            for (Object object : objectArray) {
                if ((editable.getSpanFlags(object) & 0x100) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private void addTab() {
        this.mActivity.addTab();
    }

    private void toggleTabs() {
        if (this.mActivity.areTabsShown()) {
            if (this.mActivity.hasTabsSideBar()) {
                this.mActivity.hideTabs();
            }
        } else {
            InputMethodManager inputMethodManager = (InputMethodManager)this.mActivity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.mTabs.getWindowToken(), 0);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (!tab.isPrivate()) {
                    this.mActivity.showNormalTabs();
                } else {
                    this.mActivity.showPrivateTabs();
                }
            }
        }
    }

    public void updateTabCountAndAnimate(int n) {
        if (!this.isVisible()) {
            this.updateTabCount(n);
            return;
        }
        if (!this.isEditing() || HardwareUtils.isTablet()) {
            this.mTabsCounter.setCount(n);
            this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
        }
    }

    public void updateTabCount(int n) {
        if (this.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (this.isVisible() && ViewHelper.getAlpha((View)this.mTabsCounter) != 0.0f) {
            this.mTabsCounter.setCountWithAnimation(n);
        } else {
            this.mTabsCounter.setCount(n);
        }
        this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
    }

    public void setProgressVisibility(boolean bl) {
        if (bl) {
            this.mFavicon.setImageResource(R.drawable.progress_spinner);
            if (!this.mSpinnerVisible) {
                this.setPageActionVisibility(true);
                this.mFavicon.setAnimation(this.mProgressSpinner);
                this.mProgressSpinner.start();
                this.mSpinnerVisible = true;
            }
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber start"));
        } else {
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                this.setFavicon(tab.getFavicon());
            }
            if (this.mSpinnerVisible) {
                this.setPageActionVisibility(false);
                this.mFavicon.setAnimation(null);
                this.mProgressSpinner.cancel();
                this.mSpinnerVisible = false;
            }
            Log.i((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - Throbber stop"));
        }
    }

    public void setPageActionVisibility(boolean bl) {
        this.mStop.setVisibility(bl ? 0 : 8);
        this.setSiteSecurityVisibility(this.mShowSiteSecurity && !bl);
        boolean bl2 = false;
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            bl2 = ReaderModeUtils.isAboutReader(tab.getURL());
        }
        this.mPageActionLayout.setVisibility(!bl ? 0 : 8);
        this.mTitle.setPadding(0, 0, !bl && !this.mShowReader && !bl2 ? this.mTitlePadding : 0, 0);
        this.updateFocusOrder();
    }

    private void setSiteSecurityVisibility(boolean bl) {
        if (bl == this.mSiteSecurityVisible) {
            return;
        }
        this.mSiteSecurityVisible = bl;
        if (this.mSwitchingTabs) {
            this.mSiteSecurity.setVisibility(bl ? 0 : 8);
            return;
        }
        this.mTitle.clearAnimation();
        this.mSiteSecurity.clearAnimation();
        this.mLockFadeIn.reset();
        this.mTitleSlideLeft.reset();
        this.mTitleSlideRight.reset();
        if (this.mForwardAnim != null) {
            long l = this.mForwardAnim.getRemainingTime();
            this.mTitleSlideRight.setStartOffset(l);
            this.mTitleSlideLeft.setStartOffset(l);
        } else {
            this.mTitleSlideRight.setStartOffset(0L);
            this.mTitleSlideLeft.setStartOffset(0L);
        }
        this.mTitle.startAnimation((Animation)(bl ? this.mTitleSlideRight : this.mTitleSlideLeft));
    }

    private void updateFocusOrder() {
        View view = null;
        boolean bl = false;
        for (View view2 : this.mFocusOrder) {
            if (view2.getVisibility() != 0 || !view2.isEnabled()) {
                if (!view2.hasFocus()) continue;
                bl = true;
                continue;
            }
            if (view2 == this.mActionItemBar) {
                int n = this.mActionItemBar.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view3 = this.mActionItemBar.getChildAt(i);
                    if (view != null) {
                        view3.setNextFocusLeftId(view.getId());
                        view.setNextFocusRightId(view3.getId());
                    }
                    view = view3;
                }
                continue;
            }
            if (view != null) {
                view2.setNextFocusLeftId(view.getId());
                view.setNextFocusRightId(view2.getId());
            }
            view = view2;
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void setShadowVisibility(boolean bl) {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null) {
            return;
        }
        String string2 = tab.getURL();
        if (this.mShadow.getVisibility() == 0 != bl) {
            this.mShadow.setVisibility(bl ? 0 : 8);
        }
    }

    public void onEditSuggestion(String string2) {
        if (!this.isEditing()) {
            return;
        }
        this.mUrlEditText.setText(string2);
        this.mUrlEditText.setSelection(this.mUrlEditText.getText().length());
        this.mUrlEditText.requestFocus();
        this.showSoftInput();
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle.setText(charSequence);
        this.setContentDescription(charSequence != null ? charSequence : this.mTitle.getHint());
    }

    private void updateTitle() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || tab.isEnteringReaderMode()) {
            return;
        }
        String string2 = tab.getURL();
        if (!this.isEditing()) {
            this.mUrlEditText.setText(string2);
        }
        if ("about:home".equals(string2) || "about:privatebrowsing".equals(string2)) {
            this.setTitle(null);
            return;
        }
        if (tab.getErrorType() == Tab.ErrorType.BLOCKED) {
            String string3 = tab.getDisplayTitle();
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string3);
            spannableStringBuilder.setSpan((Object)this.mBlockedColor, 0, string3.length(), 18);
            this.setTitle((CharSequence)spannableStringBuilder);
            return;
        }
        if (!this.mShowUrl || string2 == null) {
            this.setTitle(tab.getDisplayTitle());
            return;
        }
        String string4 = StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)string2));
        String string5 = tab.getBaseDomain();
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string4);
            int n = string4.toString().indexOf(string5);
            if (n > -1) {
                spannableStringBuilder.setSpan((Object)this.mUrlColor, 0, string4.length(), 18);
                spannableStringBuilder.setSpan((Object)(tab.isPrivate() ? this.mPrivateDomainColor : this.mDomainColor), n, n + string5.length(), 18);
                string4 = spannableStringBuilder;
            }
        }
        this.setTitle(string4);
    }

    private void setFavicon(Bitmap bitmap) {
        if (Tabs.getInstance().getSelectedTab().getState() == 1) {
            return;
        }
        if (bitmap != null) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)this.mFaviconSize, (int)this.mFaviconSize, (boolean)false);
            this.mFavicon.setImageBitmap(bitmap);
        } else {
            this.mFavicon.setImageBitmap(null);
        }
    }

    private void setSecurityMode(String string2) {
        int n = SiteIdentityPopup.getSecurityImageLevel(string2);
        this.mSiteSecurity.setImageLevel(n);
        this.mShowSiteSecurity = n != 0;
        this.setPageActionVisibility(this.mStop.getVisibility() == 0);
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator, boolean bl) {
        if (!bl) {
            PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), sButtonsInterpolator);
            propertyAnimator2.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
            if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
                propertyAnimator2.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
            }
            propertyAnimator2.start();
            return;
        }
        ViewHelper.setAlpha((View)this.mTabsCounter, 0.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            ViewHelper.setAlpha((View)this.mMenuIcon, 0.0f);
        }
    }

    public void finishTabsAnimation(boolean bl) {
        if (bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(150L);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        propertyAnimator.start();
    }

    public void setOnActivateListener(OnActivateListener onActivateListener) {
        this.mActivateListener = onActivateListener;
    }

    public void setOnCommitListener(OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    public void setOnFilterListener(OnFilterListener onFilterListener) {
        this.mFilterListener = onFilterListener;
    }

    public void setOnStartEditingListener(OnStartEditingListener onStartEditingListener) {
        this.mStartEditingListener = onStartEditingListener;
    }

    public void setOnStopEditingListener(OnStopEditingListener onStopEditingListener) {
        this.mStopEditingListener = onStopEditingListener;
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.mActivity.getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mUrlEditText, 1);
    }

    private void showUrlEditContainer() {
        this.setUrlEditContainerVisibility(true, null);
    }

    private void showUrlEditContainer(PropertyAnimator propertyAnimator) {
        this.setUrlEditContainerVisibility(true, propertyAnimator);
    }

    private void hideUrlEditContainer() {
        this.setUrlEditContainerVisibility(false, null);
    }

    private void hideUrlEditContainer(PropertyAnimator propertyAnimator) {
        this.setUrlEditContainerVisibility(false, propertyAnimator);
    }

    private void setUrlEditContainerVisibility(final boolean bl, PropertyAnimator propertyAnimator) {
        View view;
        final View view2 = bl ? this.mUrlEditContainer : this.mUrlDisplayContainer;
        View view3 = view = bl ? this.mUrlDisplayContainer : this.mUrlEditContainer;
        if (propertyAnimator == null) {
            view.setVisibility(8);
            view2.setVisibility(0);
            if (bl) {
                this.mUrlEditText.requestFocus();
                this.showSoftInput();
            }
            return;
        }
        ViewHelper.setAlpha(view2, 0.0f);
        propertyAnimator.attach(view2, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach(view, PropertyAnimator.Property.ALPHA, 0.0f);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                view2.setVisibility(0);
                if (bl) {
                    ViewHelper.setAlpha((View)BrowserToolbar.this.mGo, 0.0f);
                    BrowserToolbar.this.mUrlEditText.requestFocus();
                }
            }

            public void onPropertyAnimationEnd() {
                view.setVisibility(8);
                ViewHelper.setAlpha(view, 1.0f);
                if (bl) {
                    ViewHelper.setAlpha((View)BrowserToolbar.this.mGo, 1.0f);
                    BrowserToolbar.this.showSoftInput();
                }
            }
        });
    }

    public boolean isEditing() {
        return this.mIsEditing;
    }

    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        if (this.isEditing()) {
            return;
        }
        this.mUrlEditText.setText(string2 != null ? string2 : "");
        this.mIsEditing = true;
        if (this.mStartEditingListener != null) {
            this.mStartEditingListener.onStartEditing();
        }
        int n = this.getUrlBarEntryTranslation();
        int n2 = this.getUrlBarCurveTranslation();
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.showUrlEditContainer();
            if (!HardwareUtils.isTablet()) {
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, n);
                }
                ViewHelper.setTranslationX((View)this.mTabs, n2);
                ViewHelper.setTranslationX((View)this.mTabsCounter, n2);
                ViewHelper.setTranslationX((View)this.mActionItemBar, n2);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, n2);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, n2);
                }
            }
            return;
        }
        if (this.mAnimatingEntry) {
            return;
        }
        this.setSelected(true);
        ViewHelper.setAlpha((View)this.mPageActionLayout, 0.0f);
        ViewHelper.setAlpha((View)this.mStop, 0.0f);
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, n);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, n2);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, n2);
        }
        this.showUrlEditContainer(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                BrowserToolbar.this.mAnimatingEntry = false;
            }
        });
        this.mAnimatingEntry = true;
    }

    public String cancelEdit() {
        return this.stopEditing();
    }

    public String commitEdit() {
        String string2 = this.stopEditing();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.setTitle(string2);
        }
        return string2;
    }

    private String stopEditing() {
        String string2 = this.mUrlEditText.getText().toString();
        if (!this.isEditing()) {
            return string2;
        }
        this.mIsEditing = false;
        if (this.mStopEditingListener != null) {
            this.mStopEditingListener.onStopEditing();
        }
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.hideUrlEditContainer();
            if (!HardwareUtils.isTablet()) {
                this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, 0.0f);
                }
                ViewHelper.setTranslationX((View)this.mTabs, 0.0f);
                ViewHelper.setTranslationX((View)this.mTabsCounter, 0.0f);
                ViewHelper.setTranslationX((View)this.mActionItemBar, 0.0f);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, 0.0f);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, 0.0f);
                }
            }
            return string2;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        this.hideUrlEditContainer(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                PropertyAnimator propertyAnimator = new PropertyAnimator(300L);
                propertyAnimator.attach((View)BrowserToolbar.this.mPageActionLayout, PropertyAnimator.Property.ALPHA, 1.0f);
                propertyAnimator.attach((View)BrowserToolbar.this.mStop, PropertyAnimator.Property.ALPHA, 1.0f);
                propertyAnimator.start();
                BrowserToolbar.this.mAnimatingEntry = false;
                BrowserToolbar.this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
            }
        });
        this.mAnimatingEntry = true;
        propertyAnimator.start();
        return string2;
    }

    private void updateGoButton(String string2) {
        InputMethodManager inputMethodManager;
        if (string2.length() == 0) {
            this.mGo.setVisibility(8);
            return;
        }
        this.mGo.setVisibility(0);
        if (InputMethods.shouldDisableUrlBarUpdate(this.mUrlEditText.getContext())) {
            return;
        }
        int n = R.drawable.ic_url_bar_go;
        String string3 = this.mActivity.getString(R.string.go);
        int n2 = 2;
        int n3 = this.mUrlEditText.getImeOptions() & 0xFF;
        if (StringUtils.isSearchQuery((String)string2, (n3 == 3 ? 1 : 0) != 0)) {
            n = R.drawable.ic_url_bar_search;
            string3 = this.mActivity.getString(R.string.search);
            n2 = 3;
        }
        if ((inputMethodManager = InputMethods.getInputMethodManager(this.mUrlEditText.getContext())) == null) {
            return;
        }
        boolean bl = false;
        if (n3 != n2) {
            int n4 = this.mUrlEditText.getImeOptions() & 0xFFFFFF00;
            this.mUrlEditText.setImeOptions(n4 | n2);
            boolean bl2 = this.mDelayRestartInput = n2 == 2 && InputMethods.shouldDelayUrlBarUpdate(this.mUrlEditText.getContext());
            if (!this.mDelayRestartInput) {
                bl = true;
            }
        } else if (this.mDelayRestartInput) {
            this.mDelayRestartInput = false;
            bl = true;
        }
        if (bl) {
            this.updateKeyboardInputType();
            inputMethodManager.restartInput((View)this.mUrlEditText);
            this.mGo.setImageResource(n);
            this.mGo.setContentDescription((CharSequence)string3);
        }
    }

    private void updateKeyboardInputType() {
        int n;
        String string2 = this.mUrlEditText.getText().toString();
        int n2 = this.mUrlEditText.getInputType();
        int n3 = n = StringUtils.isSearchQuery((String)string2, (boolean)false) ? n2 & 0xFFFFFFEF : n2 | 0x10;
        if (n != n2) {
            this.mUrlEditText.setRawInputType(n);
        }
    }

    public void updateBackButton(boolean bl) {
        Drawable drawable2 = this.mBack.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(bl ? 255 : 77);
        }
        this.mBack.setEnabled(bl);
    }

    public void updateForwardButton(final boolean bl) {
        if (this.mForward.isEnabled() == bl) {
            return;
        }
        this.mForward.setEnabled(bl);
        if (this.mForward.getVisibility() != 0) {
            return;
        }
        this.mForwardAnim = new PropertyAnimator(this.mSwitchingTabs ? 10L : 450L);
        final int n = this.mForward.getWidth() / 2;
        this.mForwardAnim.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbar.this.requestLayout();
                }
            }

            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditContainer.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mTitle, 0.0f);
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mFavicon, 0.0f);
                    ViewHelper.setTranslationX((View)BrowserToolbar.this.mSiteSecurity, 0.0f);
                }
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mForward.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbar.this.mDefaultForwardMargin + (BrowserToolbar.this.mForward.isEnabled() ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbar.this.mForward, 0.0f);
                BrowserToolbar.this.requestLayout();
                BrowserToolbar.this.mForwardAnim = null;
            }
        });
        this.prepareForwardAnimation(this.mForwardAnim, bl, n);
        this.mForwardAnim.start();
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, boolean bl, int n) {
        if (!bl) {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 0.0f);
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            ViewHelper.setTranslationX((View)this.mTitle, this.mUrlBarViewOffset);
            ViewHelper.setTranslationX((View)this.mFavicon, this.mUrlBarViewOffset);
            ViewHelper.setTranslationX((View)this.mSiteSecurity, this.mUrlBarViewOffset);
        } else {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 1.0f);
            propertyAnimator.attach((View)this.mTitle, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
            propertyAnimator.attach((View)this.mFavicon, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
            propertyAnimator.attach((View)this.mSiteSecurity, PropertyAnimator.Property.TRANSLATION_X, this.mUrlBarViewOffset);
        }
    }

    public void addActionItem(View view) {
        this.mActionItemBar.addView(view);
    }

    public void removeActionItem(View view) {
        this.mActionItemBar.removeView(view);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void refresh() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.updateTitle();
            this.setFavicon(tab.getFavicon());
            this.setProgressVisibility(tab.getState() == 1);
            this.setSecurityMode(tab.getSecurityMode());
            this.setPageActionVisibility(this.mStop.getVisibility() == 0);
            this.updateBackButton(tab.canDoBack());
            this.updateForwardButton(tab.canDoForward());
            boolean bl = tab.isPrivate();
            this.mUrlBarBackground.setPrivateMode(bl);
            this.setPrivateMode(bl);
            this.mTabs.setPrivateMode(bl);
            this.mTitle.setPrivateMode(bl);
            this.mMenu.setPrivateMode(bl);
            this.mMenuIcon.setPrivateMode(bl);
            this.mUrlEditText.setPrivateMode(bl);
            if (this.mBack instanceof BackButton) {
                ((BackButton)this.mBack).setPrivateMode(bl);
            }
            if (this.mForward instanceof ForwardButton) {
                ((ForwardButton)this.mForward).setPrivateMode(bl);
            }
        }
    }

    public void onDestroy() {
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
        Tabs.unregisterOnTabsChangedListener(this);
        this.unregisterEventListener("Reader:Click");
        this.unregisterEventListener("Reader:LongClick");
    }

    public boolean openOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup == null) {
            MenuPanel menuPanel = this.mActivity.getMenuPanel();
            this.mMenuPopup = new MenuPopup((Context)this.mActivity);
            this.mMenuPopup.setPanelView((View)menuPanel);
            this.mMenuPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BrowserToolbar.this.mActivity.onOptionsMenuClosed(null);
                }
            });
        }
        GeckoAppShell.getGeckoInterface().invalidateOptionsMenu();
        if (!this.mMenuPopup.isShowing()) {
            this.mMenuPopup.showAsDropDown((View)this.mMenu);
        }
        return true;
    }

    public boolean closeOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup != null && this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
        }
        return true;
    }

    protected void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    protected void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Tab tab;
        if (string2.equals("Reader:Click")) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 != null) {
                tab2.toggleReaderMode();
            }
        } else if (string2.equals("Reader:LongClick") && (tab = Tabs.getInstance().getSelectedTab()) != null) {
            tab.addToReadingList();
        }
    }

    public static interface OnStopEditingListener {
        public void onStopEditing();
    }

    public static interface OnStartEditingListener {
        public void onStartEditing();
    }

    public static interface OnFilterListener {
        public void onFilter(String var1, AutocompleteHandler var2);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnCommitListener {
        public void onCommit();
    }

    public static interface OnActivateListener {
        public void onActivate();
    }
}

