/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Intent;
import android.database.Cursor;
import java.util.Queue;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.ActivityResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CameraVideoResultHandler
implements ActivityResultHandler {
    private static final String LOGTAG = "GeckoCameraVideoResultHandler";
    private final Queue<String> mFilePickerResult;
    private final ActivityHandlerHelper.FileResultHandler mHandler;

    CameraVideoResultHandler(Queue<String> queue) {
        this.mFilePickerResult = queue;
        this.mHandler = null;
    }

    public CameraVideoResultHandler(ActivityHandlerHelper.FileResultHandler fileResultHandler) {
        this.mFilePickerResult = null;
        this.mHandler = fileResultHandler;
    }

    private void sendResult(String string2) {
        if (this.mFilePickerResult != null) {
            this.mFilePickerResult.offer(string2);
        }
        if (this.mHandler != null) {
            this.mHandler.gotFile(string2);
        }
    }

    public void onActivityResult(int n, Intent intent) {
        if (intent == null || n != -1) {
            this.sendResult("");
            return;
        }
        Cursor cursor = GeckoAppShell.getGeckoInterface().getActivity().managedQuery(intent.getData(), new String[]{"_data"}, null, null, null);
        cursor.moveToFirst();
        this.sendResult(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
    }
}

