/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.DoorHanger;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.widget.ArrowPopup;

public class DoorHangerPopup
extends ArrowPopup
implements GeckoEventListener,
Tabs.OnTabsChangedListener,
DoorHanger.OnButtonClickListener {
    private static final String LOGTAG = "GeckoDoorHangerPopup";
    private HashSet<DoorHanger> mDoorHangers = new HashSet();
    private boolean mDisabled;

    DoorHangerPopup(GeckoApp geckoApp, View view) {
        super(geckoApp, view);
        this.registerEventListener("Doorhanger:Add");
        this.registerEventListener("Doorhanger:Remove");
        Tabs.registerOnTabsChangedListener(this);
    }

    void destroy() {
        this.unregisterEventListener("Doorhanger:Add");
        this.unregisterEventListener("Doorhanger:Remove");
        Tabs.unregisterOnTabsChangedListener(this);
    }

    void disable() {
        this.mDisabled = true;
        this.updatePopup();
    }

    void enable() {
        this.mDisabled = false;
        this.updatePopup();
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Doorhanger:Add")) {
                final int n = jSONObject.getInt("tabID");
                final String string3 = jSONObject.getString("value");
                final String string4 = jSONObject.getString("message");
                final JSONArray jSONArray = jSONObject.getJSONArray("buttons");
                final JSONObject jSONObject2 = jSONObject.getJSONObject("options");
                this.mActivity.runOnUiThread(new Runnable(){

                    public void run() {
                        DoorHangerPopup.this.addDoorHanger(n, string3, string4, jSONArray, jSONObject2);
                    }
                });
            } else if (string2.equals("Doorhanger:Remove")) {
                final int n = jSONObject.getInt("tabID");
                final String string5 = jSONObject.getString("value");
                this.mActivity.runOnUiThread(new Runnable(){

                    public void run() {
                        DoorHanger doorHanger = DoorHangerPopup.this.getDoorHanger(n, string5);
                        if (doorHanger == null) {
                            return;
                        }
                        DoorHangerPopup.this.removeDoorHanger(doorHanger);
                        DoorHangerPopup.this.updatePopup();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case CLOSED: {
                HashSet<DoorHanger> hashSet = new HashSet<DoorHanger>();
                for (DoorHanger doorHanger : this.mDoorHangers) {
                    if (doorHanger.getTabId() != tab.getId()) continue;
                    hashSet.add(doorHanger);
                }
                for (DoorHanger doorHanger : hashSet) {
                    this.removeDoorHanger(doorHanger);
                }
                break;
            }
            case LOCATION_CHANGE: {
                if (!this.isShowing() || !object.equals(tab.getURL())) {
                    this.removeTransientDoorHangers(tab.getId());
                }
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.updatePopup();
                break;
            }
            case SELECTED: {
                this.updatePopup();
            }
        }
    }

    void addDoorHanger(int n, String string2, String string3, JSONArray jSONArray, JSONObject jSONObject) {
        if (Tabs.getInstance().getTab(n) == null) {
            return;
        }
        DoorHanger doorHanger = this.getDoorHanger(n, string2);
        if (doorHanger != null) {
            this.removeDoorHanger(doorHanger);
        }
        if (!this.mInflated) {
            this.init();
        }
        DoorHanger doorHanger2 = new DoorHanger((Context)this.mActivity, n, string2);
        doorHanger2.setMessage(string3);
        doorHanger2.setOptions(jSONObject);
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string4 = jSONObject2.getString("label");
                String string5 = String.valueOf(jSONObject2.getInt("callback"));
                doorHanger2.addButton(string4, string5, this);
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error creating doorhanger button", (Throwable)jSONException);
            }
        }
        this.mDoorHangers.add(doorHanger2);
        this.mContent.addView((View)doorHanger2);
        if (n == Tabs.getInstance().getSelectedTab().getId()) {
            this.updatePopup();
        }
    }

    public void onButtonClick(DoorHanger doorHanger, String string2) {
        Object object;
        JSONObject jSONObject = new JSONObject();
        try {
            List<PromptInput> list;
            jSONObject.put("callback", (Object)string2);
            object = doorHanger.getCheckBox();
            if (object != null) {
                jSONObject.put("checked", object.isChecked());
            }
            if ((list = doorHanger.getInputs()) != null) {
                JSONObject jSONObject2 = new JSONObject();
                for (PromptInput promptInput : list) {
                    jSONObject2.put(promptInput.getId(), (Object)promptInput.getValue());
                }
                jSONObject.put("inputs", (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error creating onClick response", (Throwable)jSONException);
        }
        object = GeckoEvent.createBroadcastEvent("Doorhanger:Reply", jSONObject.toString());
        GeckoAppShell.sendEventToGecko((GeckoEvent)object);
        this.removeDoorHanger(doorHanger);
        this.updatePopup();
    }

    DoorHanger getDoorHanger(int n, String string2) {
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !doorHanger.getValue().equals(string2)) continue;
            return doorHanger;
        }
        return null;
    }

    void removeDoorHanger(DoorHanger doorHanger) {
        this.mDoorHangers.remove((Object)doorHanger);
        this.mContent.removeView((View)doorHanger);
    }

    void removeTransientDoorHangers(int n) {
        HashSet<DoorHanger> hashSet = new HashSet<DoorHanger>();
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() != n || !doorHanger.shouldRemove(this.isShowing())) continue;
            hashSet.add(doorHanger);
        }
        for (DoorHanger doorHanger : hashSet) {
            this.removeDoorHanger(doorHanger);
        }
    }

    private void updatePopup() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab == null || this.mDoorHangers.size() == 0 || !this.mInflated || this.mDisabled) {
            this.dismiss();
            return;
        }
        int n = tab.getId();
        boolean bl = false;
        for (DoorHanger doorHanger : this.mDoorHangers) {
            if (doorHanger.getTabId() == n) {
                doorHanger.setVisibility(0);
                bl = true;
                continue;
            }
            doorHanger.setVisibility(8);
        }
        if (!bl) {
            this.dismiss();
            return;
        }
        this.showDividers();
        if (this.isShowing()) {
            this.update();
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            this.setFocusable(true);
        }
        this.show();
        if (Build.VERSION.SDK_INT < 14) {
            this.setFocusable(true);
        }
    }

    private void showDividers() {
        int n = this.mContent.getChildCount();
        DoorHanger doorHanger = null;
        for (int i = 0; i < n; ++i) {
            DoorHanger doorHanger2 = (DoorHanger)this.mContent.getChildAt(i);
            doorHanger2.showDivider();
            if (doorHanger2.getVisibility() != 0) continue;
            doorHanger = doorHanger2;
        }
        if (doorHanger != null) {
            doorHanger.hideDivider();
        }
    }

    private void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    private void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public void dismiss() {
        this.setFocusable(false);
        super.dismiss();
    }
}

