/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ShapedButton;

public class ForwardButton
extends ShapedButton {
    private Path mBorderPath;
    private Paint mBorderPaint = new Paint();
    private Paint mBorderPrivatePaint;

    public ForwardButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPrivatePaint = new Paint(this.mBorderPaint);
        this.mBorderPath = new Path();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        float f = this.getContext().getResources().getDimension(R.dimen.nav_button_border_width);
        this.mBorderPaint.setStrokeWidth(f);
        this.mBorderPrivatePaint.setStrokeWidth(f);
        this.mBorderPath.reset();
        this.mBorderPath.moveTo((float)n - f, 0.0f);
        this.mBorderPath.lineTo((float)n - f, (float)n2);
        this.mBorderPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)n2, -4867135, -328708, Shader.TileMode.CLAMP));
        this.mBorderPrivatePaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)n2, -16513529, -16052978, Shader.TileMode.CLAMP));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(this.mBorderPath, this.isPrivateMode() ? this.mBorderPrivatePaint : this.mBorderPaint);
    }

    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.mActivity.getLightweightTheme().getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        Resources resources = this.getContext().getResources();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{R.attr.state_private, 16842919}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_nav_pb)));
        stateListDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_nav)));
        stateListDrawable.addState(new int[]{R.attr.state_private, 16842908}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_nav_focused_pb)));
        stateListDrawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_nav_focused)));
        stateListDrawable.addState(new int[]{R.attr.state_private}, (Drawable)new ColorDrawable(resources.getColor(R.color.background_private)));
        stateListDrawable.addState(new int[0], drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_nav_button);
    }
}

