/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoBatteryManager;
import org.mozilla.gecko.GeckoConnectivityReceiver;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.MemoryMonitor;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoApplication
extends Application {
    private boolean mInited;
    private boolean mInBackground;
    private boolean mPausedGecko;
    private boolean mNeedsRestart;
    private LightweightTheme mLightweightTheme;

    protected void initialize() {
        if (this.mInited) {
            return;
        }
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.mLightweightTheme = new LightweightTheme(this);
        GeckoConnectivityReceiver.getInstance().init(this.getApplicationContext());
        GeckoBatteryManager.getInstance().init(this.getApplicationContext());
        GeckoBatteryManager.getInstance().start();
        GeckoNetworkManager.getInstance().init(this.getApplicationContext());
        MemoryMonitor.getInstance().init(this.getApplicationContext());
        BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                GeckoApplication.this.mNeedsRestart = true;
            }
        };
        this.registerReceiver(broadcastReceiver, new IntentFilter("android.intent.action.LOCALE_CHANGED"));
        this.mInited = true;
    }

    protected void onActivityPause(GeckoActivityStatus geckoActivityStatus) {
        this.mInBackground = true;
        if (!geckoActivityStatus.isFinishing() && !geckoActivityStatus.isGeckoActivityOpened()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createAppBackgroundingEvent());
            this.mPausedGecko = true;
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.expireHistory(GeckoApplication.this.getContentResolver(), BrowserContract.ExpirePriority.NORMAL);
                }
            });
        }
        GeckoConnectivityReceiver.getInstance().stop();
        GeckoNetworkManager.getInstance().stop();
    }

    protected void onActivityResume(GeckoActivityStatus geckoActivityStatus) {
        if (this.mPausedGecko) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createAppForegroundingEvent());
            this.mPausedGecko = false;
        }
        GeckoConnectivityReceiver.getInstance().start();
        GeckoNetworkManager.getInstance().start();
        this.mInBackground = false;
    }

    protected boolean needsRestart() {
        return this.mNeedsRestart;
    }

    public void onCreate() {
        HardwareUtils.init((Context)this.getApplicationContext());
        Clipboard.init((Context)this.getApplicationContext());
        NotificationHelper.init(this.getApplicationContext());
        GeckoLoader.loadMozGlue();
        super.onCreate();
    }

    public boolean isApplicationInBackground() {
        return this.mInBackground;
    }

    public LightweightTheme getLightweightTheme() {
        return this.mLightweightTheme;
    }
}

