/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEditableClient;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoInputConnection;
import org.mozilla.gecko.gfx.InputConnectionHandler;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GeckoEditable
implements InvocationHandler,
Editable,
GeckoEditableClient,
GeckoEditableListener {
    private static final boolean DEBUG = false;
    private static final String LOGTAG = "GeckoEditable";
    private InputFilter[] mFilters;
    private final SpannableStringBuilder mText;
    private final SpannableStringBuilder mChangedText;
    private final Editable mProxy;
    private final ActionQueue mActionQueue = new ActionQueue();
    private Handler mIcRunHandler;
    private Handler mIcPostHandler;
    private GeckoEditableListener mListener;
    private int mSavedSelectionStart = -1;
    private volatile int mGeckoUpdateSeqno;
    private int mIcUpdateSeqno;
    private int mLastIcUpdateSeqno;
    private boolean mUpdateGecko = true;
    private boolean mFocused;
    private volatile boolean mSuppressKeyUp;

    GeckoEditable() {
        this.mText = new SpannableStringBuilder();
        this.mChangedText = new SpannableStringBuilder();
        Class[] classArray = new Class[]{Editable.class};
        this.mProxy = (Editable)Proxy.newProxyInstance(Editable.class.getClassLoader(), classArray, (InvocationHandler)this);
        LayerView layerView = GeckoAppShell.getLayerView();
        this.mListener = GeckoInputConnection.create((View)layerView, this);
        this.mIcRunHandler = this.mIcPostHandler = ThreadUtils.getUiHandler();
    }

    private boolean onIcThread() {
        return this.mIcRunHandler.getLooper() == Looper.myLooper();
    }

    private void assertOnIcThread() {
        ThreadUtils.assertOnThread((Thread)this.mIcRunHandler.getLooper().getThread());
    }

    private void geckoPostToIc(Runnable runnable) {
        this.mIcPostHandler.post(runnable);
    }

    private void geckoUpdateGecko(final boolean bl) {
        final int n = this.mGeckoUpdateSeqno;
        this.geckoPostToIc(new Runnable(){

            public void run() {
                GeckoEditable.this.mActionQueue.syncWithGecko();
                if (n == GeckoEditable.this.mGeckoUpdateSeqno) {
                    GeckoEditable.this.icUpdateGecko(bl);
                }
            }
        });
    }

    private Object getField(Object object, String string2, Object object2) {
        try {
            return object.getClass().getField(string2).get(object);
        }
        catch (Exception exception) {
            return object2;
        }
    }

    private void icUpdateGecko(boolean bl) {
        int n;
        Object[] objectArray;
        if (!bl && this.mIcUpdateSeqno == this.mLastIcUpdateSeqno) {
            return;
        }
        this.mLastIcUpdateSeqno = this.mIcUpdateSeqno;
        this.mActionQueue.syncWithGecko();
        int n2 = this.mText.getSpanStart(Selection.SELECTION_START);
        int n3 = this.mText.getSpanEnd(Selection.SELECTION_END);
        int n4 = this.mText.length();
        int n5 = 0;
        for (Object object : objectArray = this.mText.getSpans(0, n4, Object.class)) {
            if ((this.mText.getSpanFlags(object) & 0x100) == 0) continue;
            n4 = Math.min(n4, this.mText.getSpanStart(object));
            n5 = Math.max(n5, this.mText.getSpanEnd(object));
        }
        if (n4 >= n5) {
            if (n2 >= 0 && n3 >= 0) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createIMESelectEvent(n2, n3));
            } else {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createIMEEvent(GeckoEvent.ImeAction.IME_REMOVE_COMPOSITION));
            }
            return;
        }
        if (n3 >= n4 && n3 <= n5) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createIMERangeEvent(n3 - n4, n3 - n4, 1, 0, 0, false, 0, 0, 0));
        }
        int n6 = n4;
        TextPaint textPaint = new TextPaint();
        TextPaint textPaint2 = new TextPaint();
        textPaint2.setColor(0);
        do {
            int n7;
            int n8 = 0;
            int n9 = 0;
            boolean bl2 = false;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            n = this.mText.nextSpanTransition(n6, n5, Object.class);
            if (n2 > n6 && n2 < n) {
                n = n2;
            } else if (n3 > n6 && n3 < n) {
                n = n3;
            }
            CharacterStyle[] characterStyleArray = (CharacterStyle[])this.mText.getSpans(n6, n, CharacterStyle.class);
            if (characterStyleArray.length == 0) {
                n7 = n2 == n6 && n3 == n ? 3 : 2;
            } else {
                n7 = n2 == n6 && n3 == n ? 5 : 4;
                textPaint.set(textPaint2);
                for (CharacterStyle characterStyle : characterStyleArray) {
                    characterStyle.updateDrawState(textPaint);
                }
                int n13 = 0;
                float f = 0.0f;
                if (Build.VERSION.SDK_INT >= 14) {
                    n13 = (Integer)this.getField(textPaint, "underlineColor", 0);
                    f = ((Float)this.getField(textPaint, "underlineThickness", Float.valueOf(0.0f))).floatValue();
                }
                if (n13 != 0) {
                    n8 |= 9;
                    n12 = n13;
                    if (f <= 0.5f) {
                        n9 = 1;
                    } else {
                        n9 = 3;
                        if (f >= 2.0f) {
                            bl2 = true;
                        }
                    }
                } else if (textPaint.isUnderlineText()) {
                    n8 |= 1;
                    n9 = 3;
                }
                if (textPaint.getColor() != 0) {
                    n8 |= 2;
                    n10 = textPaint.getColor();
                }
                if (textPaint.bgColor != 0) {
                    n8 |= 4;
                    n11 = textPaint.bgColor;
                }
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createIMERangeEvent(n6 - n4, n - n4, n7, n8, n9, bl2, n10, n11, n12));
        } while ((n6 = n) < n5);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createIMECompositionEvent(n4, n5));
    }

    @Override
    public void sendEvent(GeckoEvent geckoEvent) {
        GeckoAppShell.sendEventToGecko(geckoEvent);
        this.mActionQueue.offer(new Action(0));
    }

    @Override
    public Editable getEditable() {
        if (!this.onIcThread()) {
            return null;
        }
        return this.mProxy;
    }

    @Override
    public void setUpdateGecko(boolean bl) {
        if (!this.onIcThread()) {
            return;
        }
        if (bl) {
            this.icUpdateGecko(false);
        }
        this.mUpdateGecko = bl;
    }

    @Override
    public void setSuppressKeyUp(boolean bl) {
        this.mSuppressKeyUp = bl;
    }

    @Override
    public Handler getInputConnectionHandler() {
        return this.mIcRunHandler;
    }

    @Override
    public boolean setInputConnectionHandler(Handler handler) {
        if (handler == this.mIcPostHandler) {
            return true;
        }
        if (!this.mFocused) {
            return false;
        }
        this.mActionQueue.offer(Action.newSetHandler(handler));
        this.mActionQueue.syncWithGecko();
        return true;
    }

    private void geckoSetIcHandler(final Handler handler) {
        this.geckoPostToIc(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Handler handler2 = handler;
                synchronized (handler2) {
                    GeckoEditable.this.mIcRunHandler = handler;
                    handler.notify();
                }
            }
        });
        this.mIcPostHandler = handler;
        this.geckoPostToIc(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Handler handler2 = handler;
                synchronized (handler2) {
                    while (GeckoEditable.this.mIcRunHandler != handler) {
                        try {
                            handler.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        });
    }

    private void geckoActionReply() {
        Action action = this.mActionQueue.peek();
        switch (action.mType) {
            case 2: {
                int n = this.mText.length();
                int n2 = Selection.getSelectionStart((CharSequence)this.mText);
                int n3 = Selection.getSelectionEnd((CharSequence)this.mText);
                final int n4 = Math.min(action.mStart < 0 ? n2 : action.mStart, n);
                final int n5 = Math.min(action.mEnd < 0 ? n3 : action.mEnd, n);
                if (n4 < action.mStart || n5 < action.mEnd) {
                    Log.w((String)LOGTAG, (String)"IME sync error: selection out of bounds");
                }
                Selection.setSelection((Spannable)this.mText, (int)n4, (int)n5);
                this.geckoPostToIc(new Runnable(){

                    public void run() {
                        GeckoEditable.this.mActionQueue.syncWithGecko();
                        int n = Selection.getSelectionStart((CharSequence)GeckoEditable.this.mText);
                        int n2 = Selection.getSelectionEnd((CharSequence)GeckoEditable.this.mText);
                        if (n4 == n && n5 == n2) {
                            GeckoEditable.this.mListener.onSelectionChange(n, n2);
                        }
                    }
                });
                break;
            }
            case 3: {
                this.mText.setSpan(action.mSpanObject, action.mStart, action.mEnd, action.mSpanFlags);
                break;
            }
            case 6: {
                this.geckoSetIcHandler(action.mHandler);
            }
        }
        if (action.mShouldUpdate) {
            this.geckoUpdateGecko(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyIME(final int n) {
        if (n == -1) {
            try {
                if (this.mFocused) {
                    this.geckoActionReply();
                }
            }
            finally {
                this.mActionQueue.poll();
            }
            return;
        }
        this.geckoPostToIc(new Runnable(){

            public void run() {
                if (n == 2) {
                    GeckoEditable.this.mFocused = false;
                } else if (n == 1) {
                    GeckoEditable.this.mFocused = true;
                    GeckoEditable.this.mActionQueue.offer(new Action(5));
                }
                GeckoEditable.this.mActionQueue.syncWithGecko();
                GeckoEditable.this.mListener.notifyIME(n);
            }
        });
    }

    @Override
    public void notifyIMEContext(final int n, final String string2, final String string3, final String string4) {
        this.geckoPostToIc(new Runnable(){

            public void run() {
                GeckoEditable.this.mActionQueue.syncWithGecko();
                LayerView layerView = GeckoAppShell.getLayerView();
                if (layerView != null) {
                    GeckoEditable.this.mListener = GeckoInputConnection.create((View)layerView, GeckoEditable.this);
                    layerView.setInputConnectionHandler((InputConnectionHandler)((Object)GeckoEditable.this.mListener));
                    GeckoEditable.this.mListener.notifyIMEContext(n, string2, string3, string4);
                }
            }
        });
    }

    @Override
    public void onSelectionChange(final int n, final int n2) {
        if (n < 0 || n > this.mText.length() || n2 < 0 || n2 > this.mText.length()) {
            throw new IllegalArgumentException("invalid selection notification range: " + n + " to " + n2 + ", length: " + this.mText.length());
        }
        final int n3 = ++this.mGeckoUpdateSeqno;
        if (!this.mActionQueue.isEmpty() && this.mActionQueue.peek().mType == 0) {
            Selection.setSelection((Spannable)this.mText, (int)n, (int)n2);
            return;
        }
        this.geckoPostToIc(new Runnable(){

            public void run() {
                GeckoEditable.this.mActionQueue.syncWithGecko();
                if (GeckoEditable.this.mGeckoUpdateSeqno == n3) {
                    boolean bl = GeckoEditable.this.mUpdateGecko;
                    GeckoEditable.this.mUpdateGecko = false;
                    Selection.setSelection((Spannable)GeckoEditable.this.mProxy, (int)n, (int)n2);
                    GeckoEditable.this.mUpdateGecko = bl;
                }
            }
        });
    }

    private void geckoReplaceText(int n, int n2, CharSequence charSequence) {
        this.mText.delete(n, n2);
        this.mText.insert(n, charSequence);
    }

    @Override
    public void onTextChange(final String string2, final int n, int n2, int n3) {
        int n4;
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("invalid text notification range: " + n + " to " + n2);
        }
        int n5 = n4 = n2 > this.mText.length() ? this.mText.length() : n2;
        if (n != 0 && n3 != n + string2.length()) {
            throw new IllegalArgumentException("newEnd does not match text: " + n3 + " vs " + (n + string2.length()));
        }
        final int n6 = n + string2.length();
        ++this.mGeckoUpdateSeqno;
        this.mChangedText.clearSpans();
        this.mChangedText.replace(0, this.mChangedText.length(), (CharSequence)string2);
        TextUtils.copySpansFrom((Spanned)this.mText, (int)n, (int)Math.min(n4, n6), Object.class, (Spannable)this.mChangedText, (int)0);
        if (!this.mActionQueue.isEmpty()) {
            Action action = this.mActionQueue.peek();
            if (action.mType == 1 && n <= action.mStart && action.mStart + action.mSequence.length() <= n6) {
                int n7 = action.mStart + action.mSequence.length();
                int n8 = Selection.getSelectionStart((CharSequence)this.mText);
                int n9 = Selection.getSelectionEnd((CharSequence)this.mText);
                this.mChangedText.replace(action.mStart - n, n7 - n, action.mSequence);
                this.geckoReplaceText(n, n4, (CharSequence)this.mChangedText);
                if (n8 >= n && n8 <= n4) {
                    n8 = n8 < action.mStart ? n8 : (n8 < action.mEnd ? n7 : n8 + n7 - action.mEnd);
                    this.mText.setSpan(Selection.SELECTION_START, n8, n8, 34);
                }
                if (n9 >= n && n9 <= n4) {
                    n9 = n9 < action.mStart ? n9 : (n9 < action.mEnd ? n7 : n9 + n7 - action.mEnd);
                    this.mText.setSpan(Selection.SELECTION_END, n9, n9, 34);
                }
            } else {
                this.geckoReplaceText(n, n4, (CharSequence)this.mChangedText);
            }
        } else {
            this.geckoReplaceText(n, n4, (CharSequence)this.mChangedText);
        }
        this.geckoPostToIc(new Runnable(){

            public void run() {
                GeckoEditable.this.mListener.onTextChange(string2, n, n4, n6);
            }
        });
    }

    static String getConstantName(Class<?> clazz, String string2, Object object) {
        for (Field field : clazz.getDeclaredFields()) {
            try {
                if (!field.getName().startsWith(string2) || !field.get(null).equals(object)) continue;
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return String.valueOf(object);
    }

    static StringBuilder debugAppend(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof GeckoEditable) {
            stringBuilder.append(LOGTAG);
        } else if (Proxy.isProxyClass(object.getClass())) {
            GeckoEditable.debugAppend(stringBuilder, Proxy.getInvocationHandler(object));
        } else if (object instanceof CharSequence) {
            stringBuilder.append("\"").append(object.toString().replace('\n', '\u21b2')).append("\"");
        } else if (object.getClass().isArray()) {
            stringBuilder.append(object.getClass().getComponentType().getSimpleName()).append("[").append(Array.getLength(object)).append("]");
        } else {
            stringBuilder.append(object.toString());
        }
        return stringBuilder;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        GeckoEditable geckoEditable;
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Editable.class || clazz == Appendable.class || clazz == Spannable.class) {
            geckoEditable = this;
        } else {
            this.mActionQueue.syncWithGecko();
            geckoEditable = this.mText;
        }
        try {
            object2 = method.invoke((Object)geckoEditable, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (!(invocationTargetException.getCause() instanceof IndexOutOfBoundsException)) {
                throw invocationTargetException;
            }
            Log.w((String)LOGTAG, (String)("Exception in GeckoEditable." + method.getName()), (Throwable)invocationTargetException.getCause());
            Class<?> clazz2 = method.getReturnType();
            object2 = clazz2 == Character.TYPE ? Character.valueOf('\u0000') : (clazz2 == Integer.TYPE ? Integer.valueOf(0) : (clazz2 == String.class ? "" : null));
        }
        return object2;
    }

    public void removeSpan(Object object) {
        if (object == Selection.SELECTION_START || object == Selection.SELECTION_END) {
            Log.w((String)LOGTAG, (String)"selection removed with removeSpan()");
        }
        if (this.mText.getSpanStart(object) >= 0) {
            this.mText.removeSpan(object);
            this.mActionQueue.offer(new Action(4));
        }
    }

    public void setSpan(Object object, int n, int n2, int n3) {
        if (object == Selection.SELECTION_START) {
            if ((n3 & 0x200) != 0) {
                this.mSavedSelectionStart = n;
            } else {
                this.mActionQueue.offer(Action.newSetSelection(n, -1));
            }
        } else if (object == Selection.SELECTION_END) {
            this.mActionQueue.offer(Action.newSetSelection(this.mSavedSelectionStart, n2));
            this.mSavedSelectionStart = -1;
        } else {
            this.mActionQueue.offer(Action.newSetSpan(object, n, n2, n3));
        }
    }

    public Editable append(CharSequence charSequence) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), charSequence, 0, charSequence.length());
    }

    public Editable append(CharSequence charSequence, int n, int n2) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), charSequence, n, n2);
    }

    public Editable append(char c) {
        return this.replace(this.mProxy.length(), this.mProxy.length(), String.valueOf(c), 0, 1);
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    public void setFilters(InputFilter[] inputFilterArray) {
        this.mFilters = inputFilterArray;
    }

    public void clearSpans() {
        Log.w((String)LOGTAG, (String)"selection cleared with clearSpans()");
        this.mText.clearSpans();
    }

    public Editable replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
        CharSequence charSequence2 = charSequence;
        if (n3 < 0 || n3 > n4 || n4 > charSequence2.length()) {
            throw new IllegalArgumentException("invalid replace offsets: " + n3 + " to " + n4 + ", length: " + charSequence2.length());
        }
        if (n3 != 0 || n4 != charSequence2.length()) {
            charSequence2 = charSequence2.subSequence(n3, n4);
        }
        if (this.mFilters != null) {
            for (int i = 0; i < this.mFilters.length; ++i) {
                CharSequence charSequence3 = this.mFilters[i].filter(charSequence2, 0, charSequence2.length(), (Spanned)this.mProxy, n, n2);
                if (charSequence3 == null) continue;
                charSequence2 = charSequence3;
            }
        }
        if (charSequence2 == charSequence) {
            charSequence2 = new SpannableString(charSequence);
        }
        this.mActionQueue.offer(Action.newReplaceText(charSequence2, Math.min(n, n2), Math.max(n, n2)));
        return this.mProxy;
    }

    public void clear() {
        this.replace(0, this.mProxy.length(), "", 0, 0);
    }

    public Editable delete(int n, int n2) {
        return this.replace(n, n2, "", 0, 0);
    }

    public Editable insert(int n, CharSequence charSequence, int n2, int n3) {
        return this.replace(n, n, charSequence, n2, n3);
    }

    public Editable insert(int n, CharSequence charSequence) {
        return this.replace(n, n, charSequence, 0, charSequence.length());
    }

    public Editable replace(int n, int n2, CharSequence charSequence) {
        return this.replace(n, n2, charSequence, 0, charSequence.length());
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanEnd(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanFlags(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int getSpanStart(Object object) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public <T> T[] getSpans(int n, int n2, Class<T> clazz) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int nextSpanTransition(int n, int n2, Class clazz) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public char charAt(int n) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public int length() {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public CharSequence subSequence(int n, int n2) {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    public String toString() {
        throw new UnsupportedOperationException("method must be called through mProxy");
    }

    private final class ActionQueue {
        private final ConcurrentLinkedQueue<Action> mActions = new ConcurrentLinkedQueue();
        private final Semaphore mActionsActive = new Semaphore(1);
        private KeyCharacterMap mKeyMap;

        ActionQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(Action action) {
            if (action.mType != 0 && action.mType != 5 && action.mType != 6) {
                action.mShouldUpdate = GeckoEditable.this.mUpdateGecko;
            }
            if (this.mActions.isEmpty()) {
                this.mActionsActive.acquireUninterruptibly();
                this.mActions.offer(action);
            } else {
                ActionQueue actionQueue = this;
                synchronized (actionQueue) {
                    this.mActionsActive.tryAcquire();
                    this.mActions.offer(action);
                }
            }
            switch (action.mType) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createIMEEvent(GeckoEvent.ImeAction.IME_SYNCHRONIZE));
                    break;
                }
                case 1: {
                    this.sendCharKeyEvents(action);
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createIMEReplaceEvent(action.mStart, action.mEnd, ((Object)action.mSequence).toString()));
                    break;
                }
                case 5: {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createIMEEvent(GeckoEvent.ImeAction.IME_ACKNOWLEDGE_FOCUS));
                }
            }
            ++GeckoEditable.this.mIcUpdateSeqno;
        }

        private KeyEvent[] synthesizeKeyEvents(CharSequence charSequence) {
            try {
                if (this.mKeyMap == null) {
                    this.mKeyMap = KeyCharacterMap.load((int)(Build.VERSION.SDK_INT < 11 ? 3 : -1));
                }
            }
            catch (Exception exception) {
                return null;
            }
            KeyEvent[] keyEventArray = this.mKeyMap.getEvents(((Object)charSequence).toString().toCharArray());
            if (keyEventArray == null || keyEventArray.length == 0) {
                return null;
            }
            return keyEventArray;
        }

        private void sendCharKeyEvents(Action action) {
            if (action.mSequence.length() == 0 || action.mSequence instanceof Spannable && ((Spannable)action.mSequence).nextSpanTransition(-1, Integer.MAX_VALUE, null) < Integer.MAX_VALUE) {
                return;
            }
            KeyEvent[] keyEventArray = this.synthesizeKeyEvents(action.mSequence);
            if (keyEventArray == null) {
                return;
            }
            for (KeyEvent keyEvent : keyEventArray) {
                if (KeyEvent.isModifierKey((int)keyEvent.getKeyCode()) || keyEvent.getAction() == 1 && GeckoEditable.this.mSuppressKeyUp) continue;
                GeckoAppShell.sendEventToGecko(GeckoEvent.createIMEKeyEvent(keyEvent));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void poll() {
            if (this.mActions.isEmpty()) {
                throw new IllegalStateException("empty actions queue");
            }
            this.mActions.poll();
            if (this.mActions.isEmpty()) {
                ActionQueue actionQueue = this;
                synchronized (actionQueue) {
                    if (this.mActions.isEmpty()) {
                        this.mActionsActive.release();
                    }
                }
            }
        }

        Action peek() {
            if (this.mActions.isEmpty()) {
                throw new IllegalStateException("empty actions queue");
            }
            return this.mActions.peek();
        }

        void syncWithGecko() {
            if (GeckoEditable.this.mFocused && !this.mActions.isEmpty()) {
                this.mActionsActive.acquireUninterruptibly();
                this.mActionsActive.release();
            }
        }

        boolean isEmpty() {
            return this.mActions.isEmpty();
        }
    }

    private static final class Action {
        static final int TYPE_EVENT = 0;
        static final int TYPE_REPLACE_TEXT = 1;
        static final int TYPE_SET_SELECTION = 2;
        static final int TYPE_SET_SPAN = 3;
        static final int TYPE_REMOVE_SPAN = 4;
        static final int TYPE_ACKNOWLEDGE_FOCUS = 5;
        static final int TYPE_SET_HANDLER = 6;
        final int mType;
        int mStart;
        int mEnd;
        CharSequence mSequence;
        Object mSpanObject;
        int mSpanFlags;
        boolean mShouldUpdate;
        Handler mHandler;

        Action(int n) {
            this.mType = n;
        }

        static Action newReplaceText(CharSequence charSequence, int n, int n2) {
            if (n < 0 || n > n2) {
                throw new IllegalArgumentException("invalid replace text offsets: " + n + " to " + n2);
            }
            Action action = new Action(1);
            action.mSequence = charSequence;
            action.mStart = n;
            action.mEnd = n2;
            return action;
        }

        static Action newSetSelection(int n, int n2) {
            if (n < -1 || n2 < -1) {
                throw new IllegalArgumentException("invalid selection offsets: " + n + " to " + n2);
            }
            Action action = new Action(2);
            action.mStart = n;
            action.mEnd = n2;
            return action;
        }

        static Action newSetSpan(Object object, int n, int n2, int n3) {
            if (n < 0 || n > n2) {
                throw new IllegalArgumentException("invalid span offsets: " + n + " to " + n2);
            }
            Action action = new Action(3);
            action.mSpanObject = object;
            action.mStart = n;
            action.mEnd = n2;
            action.mSpanFlags = n3;
            return action;
        }

        static Action newSetHandler(Handler handler) {
            Action action = new Action(6);
            action.mHandler = handler;
            return action;
        }
    }
}

