/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.SensorEvent;
import android.location.Address;
import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.nio.ByteBuffer;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;

public class GeckoEvent {
    private static final String LOGTAG = "GeckoEvent";
    public static final int IME_RANGE_CARETPOSITION = 1;
    public static final int IME_RANGE_RAWINPUT = 2;
    public static final int IME_RANGE_SELECTEDRAWTEXT = 3;
    public static final int IME_RANGE_CONVERTEDTEXT = 4;
    public static final int IME_RANGE_SELECTEDCONVERTEDTEXT = 5;
    public static final int IME_RANGE_LINE_NONE = 0;
    public static final int IME_RANGE_LINE_DOTTED = 1;
    public static final int IME_RANGE_LINE_DASHED = 2;
    public static final int IME_RANGE_LINE_SOLID = 3;
    public static final int IME_RANGE_LINE_DOUBLE = 4;
    public static final int IME_RANGE_LINE_WAVY = 5;
    public static final int IME_RANGE_UNDERLINE = 1;
    public static final int IME_RANGE_FORECOLOR = 2;
    public static final int IME_RANGE_BACKCOLOR = 4;
    public static final int IME_RANGE_LINECOLOR = 8;
    public static final int ACTION_MAGNIFY_START = 11;
    public static final int ACTION_MAGNIFY = 12;
    public static final int ACTION_MAGNIFY_END = 13;
    private final int mType;
    private int mAction;
    private boolean mAckNeeded;
    private long mTime;
    private Point[] mPoints;
    private int[] mPointIndicies;
    private int mPointerIndex;
    private float[] mOrientations;
    private float[] mPressures;
    private Point[] mPointRadii;
    private Rect mRect;
    private double mX;
    private double mY;
    private double mZ;
    private int mMetaState;
    private int mFlags;
    private int mKeyCode;
    private int mUnicodeChar;
    private int mBaseUnicodeChar;
    private int mRepeatCount;
    private int mCount;
    private int mStart;
    private int mEnd;
    private String mCharacters;
    private String mCharactersExtra;
    private String mData;
    private int mRangeType;
    private int mRangeStyles;
    private int mRangeLineStyle;
    private boolean mRangeBoldLine;
    private int mRangeForeColor;
    private int mRangeBackColor;
    private int mRangeLineColor;
    private Location mLocation;
    private Address mAddress;
    private DomKeyLocation mDomKeyLocation;
    private double mBandwidth;
    private boolean mCanBeMetered;
    private boolean mIsWifi;
    private int mDHCPGateway;
    private int mNativeWindow;
    private short mScreenOrientation;
    private ByteBuffer mBuffer;
    private int mWidth;
    private int mHeight;
    private String[] mPrefNames;

    private GeckoEvent(NativeGeckoEvent nativeGeckoEvent) {
        this.mType = nativeGeckoEvent.value;
    }

    public static GeckoEvent createAppBackgroundingEvent() {
        return new GeckoEvent(NativeGeckoEvent.APP_BACKGROUNDING);
    }

    public static GeckoEvent createAppForegroundingEvent() {
        return new GeckoEvent(NativeGeckoEvent.APP_FOREGROUNDING);
    }

    public static GeckoEvent createNoOpEvent() {
        return new GeckoEvent(NativeGeckoEvent.NOOP);
    }

    public static GeckoEvent createKeyEvent(KeyEvent keyEvent, int n) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.KEY_EVENT);
        geckoEvent.initKeyEvent(keyEvent, n);
        return geckoEvent;
    }

    public static GeckoEvent createCompositorCreateEvent(int n, int n2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.COMPOSITOR_CREATE);
        geckoEvent.mWidth = n;
        geckoEvent.mHeight = n2;
        return geckoEvent;
    }

    public static GeckoEvent createCompositorPauseEvent() {
        return new GeckoEvent(NativeGeckoEvent.COMPOSITOR_PAUSE);
    }

    public static GeckoEvent createCompositorResumeEvent() {
        return new GeckoEvent(NativeGeckoEvent.COMPOSITOR_RESUME);
    }

    private void initKeyEvent(KeyEvent keyEvent, int n) {
        this.mAction = keyEvent.getAction();
        this.mTime = keyEvent.getEventTime();
        this.mMetaState = keyEvent.getMetaState() | n;
        this.mFlags = keyEvent.getFlags();
        this.mKeyCode = keyEvent.getKeyCode();
        this.mUnicodeChar = keyEvent.getUnicodeChar(this.mMetaState);
        this.mBaseUnicodeChar = keyEvent.getUnicodeChar(0);
        this.mRepeatCount = keyEvent.getRepeatCount();
        this.mCharacters = keyEvent.getCharacters();
        this.mDomKeyLocation = GeckoEvent.isJoystickButton(this.mKeyCode) ? DomKeyLocation.DOM_KEY_LOCATION_JOYSTICK : DomKeyLocation.DOM_KEY_LOCATION_MOBILE;
    }

    private static boolean isJoystickButton(int n) {
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return KeyEvent.isGamepadButton((int)n);
        }
        return GeckoEvent.isGamepadButton(n);
    }

    private static boolean isGamepadButton(int n) {
        switch (n) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: {
                return true;
            }
        }
        return false;
    }

    public static GeckoEvent createNativeGestureEvent(int n, PointF pointF, double d) {
        try {
            GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.NATIVE_GESTURE_EVENT);
            geckoEvent.mAction = n;
            geckoEvent.mCount = 1;
            geckoEvent.mPoints = new Point[1];
            PointF pointF2 = new PointF(pointF.x, pointF.y);
            pointF2 = GeckoAppShell.getLayerView().convertViewPointToLayerPoint(pointF2);
            if (pointF2 == null) {
                return null;
            }
            geckoEvent.mPoints[0] = new Point(Math.round(pointF2.x), Math.round(pointF2.y));
            geckoEvent.mX = d;
            geckoEvent.mTime = System.currentTimeMillis();
            return geckoEvent;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static GeckoEvent createMotionEvent(MotionEvent motionEvent, boolean bl) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.MOTION_EVENT);
        geckoEvent.initMotionEvent(motionEvent, bl);
        return geckoEvent;
    }

    private void initMotionEvent(MotionEvent motionEvent, boolean bl) {
        this.mAction = motionEvent.getActionMasked();
        this.mTime = System.currentTimeMillis() - SystemClock.elapsedRealtime() + motionEvent.getEventTime();
        this.mMetaState = motionEvent.getMetaState();
        switch (this.mAction) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                this.mCount = motionEvent.getPointerCount();
                this.mPoints = new Point[this.mCount];
                this.mPointIndicies = new int[this.mCount];
                this.mOrientations = new float[this.mCount];
                this.mPressures = new float[this.mCount];
                this.mPointRadii = new Point[this.mCount];
                this.mPointerIndex = motionEvent.getActionIndex();
                for (int i = 0; i < this.mCount; ++i) {
                    this.addMotionPoint(i, i, motionEvent, bl);
                }
                break;
            }
            default: {
                this.mCount = 0;
                this.mPointerIndex = -1;
                this.mPoints = new Point[this.mCount];
                this.mPointIndicies = new int[this.mCount];
                this.mOrientations = new float[this.mCount];
                this.mPressures = new float[this.mCount];
                this.mPointRadii = new Point[this.mCount];
            }
        }
    }

    private void addMotionPoint(int n, int n2, MotionEvent motionEvent, boolean bl) {
        try {
            PointF pointF = new PointF(motionEvent.getX(n2), motionEvent.getY(n2));
            if (!bl) {
                pointF = GeckoAppShell.getLayerView().convertViewPointToLayerPoint(pointF);
            }
            this.mPoints[n] = new Point(Math.round(pointF.x), Math.round(pointF.y));
            this.mPointIndicies[n] = motionEvent.getPointerId(n2);
            if (Build.VERSION.SDK_INT >= 9) {
                double d = motionEvent.getOrientation(n2);
                this.mOrientations[n] = (float)Math.toDegrees(d);
                if (this.mOrientations[n] == 90.0f) {
                    this.mOrientations[n] = -90.0f;
                }
                if (this.mOrientations[n] < 0.0f) {
                    int n3 = n;
                    this.mOrientations[n3] = this.mOrientations[n3] + 90.0f;
                    this.mPointRadii[n] = new Point((int)motionEvent.getToolMajor(n2) / 2, (int)motionEvent.getToolMinor(n2) / 2);
                } else {
                    this.mPointRadii[n] = new Point((int)motionEvent.getToolMinor(n2) / 2, (int)motionEvent.getToolMajor(n2) / 2);
                }
            } else {
                float f = motionEvent.getSize(n2);
                Resources resources = GeckoAppShell.getContext().getResources();
                DisplayMetrics displayMetrics = resources.getDisplayMetrics();
                this.mPointRadii[n] = new Point((int)(f *= (float)Math.min(displayMetrics.heightPixels, displayMetrics.widthPixels)), (int)f);
                this.mOrientations[n] = 0.0f;
            }
            if (!bl) {
                float f = GeckoAppShell.getLayerView().getViewportMetrics().zoomFactor;
                this.mPointRadii[n].x = (int)((float)this.mPointRadii[n].x / f);
                this.mPointRadii[n].y = (int)((float)this.mPointRadii[n].y / f);
            }
            this.mPressures[n] = motionEvent.getPressure(n2);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Error creating motion point " + n), (Throwable)exception);
            this.mPointRadii[n] = new Point(0, 0);
            this.mPoints[n] = new Point(0, 0);
        }
    }

    private static int HalSensorAccuracyFor(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    public static GeckoEvent createSensorEvent(SensorEvent sensorEvent) {
        int n = sensorEvent.sensor.getType();
        GeckoEvent geckoEvent = null;
        switch (n) {
            case 1: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 1;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = sensorEvent.values[0];
                geckoEvent.mY = sensorEvent.values[1];
                geckoEvent.mZ = sensorEvent.values[2];
                break;
            }
            case 10: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 3;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = sensorEvent.values[0];
                geckoEvent.mY = sensorEvent.values[1];
                geckoEvent.mZ = sensorEvent.values[2];
                break;
            }
            case 3: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 0;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = sensorEvent.values[0];
                geckoEvent.mY = sensorEvent.values[1];
                geckoEvent.mZ = sensorEvent.values[2];
                break;
            }
            case 4: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 4;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = Math.toDegrees(sensorEvent.values[0]);
                geckoEvent.mY = Math.toDegrees(sensorEvent.values[1]);
                geckoEvent.mZ = Math.toDegrees(sensorEvent.values[2]);
                break;
            }
            case 8: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 2;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = sensorEvent.values[0];
                geckoEvent.mY = 0.0;
                geckoEvent.mZ = sensorEvent.sensor.getMaximumRange();
                break;
            }
            case 5: {
                geckoEvent = new GeckoEvent(NativeGeckoEvent.SENSOR_EVENT);
                geckoEvent.mFlags = 5;
                geckoEvent.mMetaState = GeckoEvent.HalSensorAccuracyFor(sensorEvent.accuracy);
                geckoEvent.mX = sensorEvent.values[0];
            }
        }
        return geckoEvent;
    }

    public static GeckoEvent createLocationEvent(Location location) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.LOCATION_EVENT);
        geckoEvent.mLocation = location;
        return geckoEvent;
    }

    public static GeckoEvent createIMEEvent(ImeAction imeAction) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_EVENT);
        geckoEvent.mAction = imeAction.value;
        return geckoEvent;
    }

    public static GeckoEvent createIMEKeyEvent(KeyEvent keyEvent) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_KEY_EVENT);
        geckoEvent.initKeyEvent(keyEvent, 0);
        return geckoEvent;
    }

    public static GeckoEvent createIMEReplaceEvent(int n, int n2, String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_EVENT);
        geckoEvent.mAction = ImeAction.IME_REPLACE_TEXT.value;
        geckoEvent.mStart = n;
        geckoEvent.mEnd = n2;
        geckoEvent.mCharacters = string2;
        return geckoEvent;
    }

    public static GeckoEvent createIMESelectEvent(int n, int n2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_EVENT);
        geckoEvent.mAction = ImeAction.IME_SET_SELECTION.value;
        geckoEvent.mStart = n;
        geckoEvent.mEnd = n2;
        return geckoEvent;
    }

    public static GeckoEvent createIMECompositionEvent(int n, int n2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_EVENT);
        geckoEvent.mAction = ImeAction.IME_UPDATE_COMPOSITION.value;
        geckoEvent.mStart = n;
        geckoEvent.mEnd = n2;
        return geckoEvent;
    }

    public static GeckoEvent createIMERangeEvent(int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, int n8) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.IME_EVENT);
        geckoEvent.mAction = ImeAction.IME_ADD_COMPOSITION_RANGE.value;
        geckoEvent.mStart = n;
        geckoEvent.mEnd = n2;
        geckoEvent.mRangeType = n3;
        geckoEvent.mRangeStyles = n4;
        geckoEvent.mRangeLineStyle = n5;
        geckoEvent.mRangeBoldLine = bl;
        geckoEvent.mRangeForeColor = n6;
        geckoEvent.mRangeBackColor = n7;
        geckoEvent.mRangeLineColor = n8;
        return geckoEvent;
    }

    public static GeckoEvent createDrawEvent(Rect rect) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.DRAW);
        geckoEvent.mRect = rect;
        return geckoEvent;
    }

    public static GeckoEvent createSizeChangedEvent(int n, int n2, int n3, int n4) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.SIZE_CHANGED);
        geckoEvent.mPoints = new Point[2];
        geckoEvent.mPoints[0] = new Point(n, n2);
        geckoEvent.mPoints[1] = new Point(n3, n4);
        return geckoEvent;
    }

    public static GeckoEvent createBroadcastEvent(String string2, String string3) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.BROADCAST);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = string3;
        return geckoEvent;
    }

    public static GeckoEvent createViewportEvent(ImmutableViewportMetrics immutableViewportMetrics, DisplayPortMetrics displayPortMetrics) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.VIEWPORT);
        geckoEvent.mCharacters = "Viewport:Change";
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("{ \"x\" : ").append(immutableViewportMetrics.viewportRectLeft).append(", \"y\" : ").append(immutableViewportMetrics.viewportRectTop).append(", \"zoom\" : ").append(immutableViewportMetrics.zoomFactor).append(", \"fixedMarginLeft\" : ").append(immutableViewportMetrics.marginLeft).append(", \"fixedMarginTop\" : ").append(immutableViewportMetrics.marginTop).append(", \"fixedMarginRight\" : ").append(immutableViewportMetrics.marginRight).append(", \"fixedMarginBottom\" : ").append(immutableViewportMetrics.marginBottom).append(", \"displayPort\" :").append(displayPortMetrics.toJSON()).append('}');
        geckoEvent.mCharactersExtra = stringBuilder.toString();
        return geckoEvent;
    }

    public static GeckoEvent createURILoadEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.LOAD_URI);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = "";
        return geckoEvent;
    }

    public static GeckoEvent createWebappLoadEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.LOAD_URI);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = "-webapp";
        return geckoEvent;
    }

    public static GeckoEvent createBookmarkLoadEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.LOAD_URI);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = "-bookmark";
        return geckoEvent;
    }

    public static GeckoEvent createVisitedEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.VISITED);
        geckoEvent.mCharacters = string2;
        return geckoEvent;
    }

    public static GeckoEvent createNetworkEvent(double d, boolean bl, boolean bl2, int n) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.NETWORK_CHANGED);
        geckoEvent.mBandwidth = d;
        geckoEvent.mCanBeMetered = bl;
        geckoEvent.mIsWifi = bl2;
        geckoEvent.mDHCPGateway = n;
        return geckoEvent;
    }

    public static GeckoEvent createThumbnailEvent(int n, int n2, int n3, ByteBuffer byteBuffer) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.THUMBNAIL);
        geckoEvent.mPoints = new Point[1];
        geckoEvent.mPoints[0] = new Point(n2, n3);
        geckoEvent.mMetaState = n;
        geckoEvent.mBuffer = byteBuffer;
        return geckoEvent;
    }

    public static GeckoEvent createScreenOrientationEvent(short s) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.SCREENORIENTATION_CHANGED);
        geckoEvent.mScreenOrientation = s;
        return geckoEvent;
    }

    public static GeckoEvent createCallObserverEvent(String string2, String string3, String string4) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.CALL_OBSERVER);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCharactersExtra = string3;
        geckoEvent.mData = string4;
        return geckoEvent;
    }

    public static GeckoEvent createRemoveObserverEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.REMOVE_OBSERVER);
        geckoEvent.mCharacters = string2;
        return geckoEvent;
    }

    public static GeckoEvent createPreferencesObserveEvent(int n, String[] stringArray) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.PREFERENCES_OBSERVE);
        geckoEvent.mCount = n;
        geckoEvent.mPrefNames = stringArray;
        return geckoEvent;
    }

    public static GeckoEvent createPreferencesGetEvent(int n, String[] stringArray) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.PREFERENCES_GET);
        geckoEvent.mCount = n;
        geckoEvent.mPrefNames = stringArray;
        return geckoEvent;
    }

    public static GeckoEvent createPreferencesRemoveObserversEvent(int n) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.PREFERENCES_REMOVE_OBSERVERS);
        geckoEvent.mCount = n;
        return geckoEvent;
    }

    public static GeckoEvent createLowMemoryEvent(int n) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.LOW_MEMORY);
        geckoEvent.mMetaState = n;
        return geckoEvent;
    }

    public static GeckoEvent createNetworkLinkChangeEvent(String string2) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.NETWORK_LINK_CHANGE);
        geckoEvent.mCharacters = string2;
        return geckoEvent;
    }

    public static GeckoEvent createTelemetryHistogramAddEvent(String string2, int n) {
        GeckoEvent geckoEvent = new GeckoEvent(NativeGeckoEvent.TELEMETRY_HISTOGRAM_ADD);
        geckoEvent.mCharacters = string2;
        geckoEvent.mCount = n;
        return geckoEvent;
    }

    public void setAckNeeded(boolean bl) {
        this.mAckNeeded = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImeAction {
        IME_SYNCHRONIZE(0),
        IME_REPLACE_TEXT(1),
        IME_SET_SELECTION(2),
        IME_ADD_COMPOSITION_RANGE(3),
        IME_UPDATE_COMPOSITION(4),
        IME_REMOVE_COMPOSITION(5),
        IME_ACKNOWLEDGE_FOCUS(6);

        public final int value;

        private ImeAction(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DomKeyLocation {
        DOM_KEY_LOCATION_STANDARD(0),
        DOM_KEY_LOCATION_LEFT(1),
        DOM_KEY_LOCATION_RIGHT(2),
        DOM_KEY_LOCATION_NUMPAD(3),
        DOM_KEY_LOCATION_MOBILE(4),
        DOM_KEY_LOCATION_JOYSTICK(5);

        public final int value;

        private DomKeyLocation(int n2) {
            this.value = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NativeGeckoEvent {
        NATIVE_POKE(0),
        KEY_EVENT(1),
        MOTION_EVENT(2),
        SENSOR_EVENT(3),
        LOCATION_EVENT(5),
        IME_EVENT(6),
        DRAW(7),
        SIZE_CHANGED(8),
        APP_BACKGROUNDING(9),
        APP_FOREGROUNDING(10),
        LOAD_URI(12),
        NOOP(15),
        BROADCAST(19),
        VIEWPORT(20),
        VISITED(21),
        NETWORK_CHANGED(22),
        THUMBNAIL(25),
        SCREENORIENTATION_CHANGED(27),
        COMPOSITOR_CREATE(28),
        COMPOSITOR_PAUSE(29),
        COMPOSITOR_RESUME(30),
        NATIVE_GESTURE_EVENT(31),
        IME_KEY_EVENT(32),
        CALL_OBSERVER(33),
        REMOVE_OBSERVER(34),
        LOW_MEMORY(35),
        NETWORK_LINK_CHANGE(36),
        TELEMETRY_HISTOGRAM_ADD(37),
        PREFERENCES_OBSERVE(39),
        PREFERENCES_GET(40),
        PREFERENCES_REMOVE_OBSERVERS(41);

        public final int value;

        private NativeGeckoEvent(int n2) {
            this.value = n2;
        }
    }
}

