/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.app.NotificationManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.preference.TwoStatePreference;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.FontSizePreference;
import org.mozilla.gecko.GeckoActivityStatus;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoPreferenceFragment;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.LinkPreference;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.SearchEnginePreference;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeckoPreferences
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener,
GeckoEventListener,
GeckoActivityStatus {
    private static final String LOGTAG = "GeckoPreferences";
    private static final String NON_PREF_PREFIX = "android.not_a_preference.";
    public static final String INTENT_EXTRA_RESOURCES = "resource";
    public static String PREFS_HEALTHREPORT_UPLOAD_ENABLED = "android.not_a_preference.healthreport.uploadEnabled";
    private static boolean sIsCharEncodingEnabled = false;
    private boolean mInitialized = false;
    private int mPrefsRequestId = 0;
    private static String PREFS_ANNOUNCEMENTS_ENABLED = "android.not_a_preference.privacy.announcements.enabled";
    private static String PREFS_DATA_REPORTING_PREFERENCES = "android.not_a_preference.datareporting.preferences";
    private static String PREFS_TELEMETRY_ENABLED = "datareporting.telemetry.enabled";
    private static String PREFS_CRASHREPORTER_ENABLED = "datareporting.crashreporter.submitEnabled";
    private static String PREFS_MENU_CHAR_ENCODING = "browser.menu.showCharacterEncoding";
    private static String PREFS_MP_ENABLED = "privacy.masterpassword.enabled";
    private static String PREFS_UPDATER_AUTODOWNLOAD = "app.update.autodownload";
    private static String PREFS_GEO_REPORTING = "app.geo.reportdata";
    private static String PREFS_HEALTHREPORT_LINK = "android.not_a_preference.healthreport.link";
    private static String PREFS_DEVTOOLS_REMOTE_ENABLED = "devtools.debugger.remote-enabled";
    private static String PREFS_DISPLAY_REFLOW_ON_ZOOM = "browser.zoom.reflowOnZoom";
    private static String PREFS_SYNC = "android.not_a_preference.sync";
    public static String PREFS_RESTORE_SESSION = "android.not_a_preference.restoreSession3";
    private static int REQUEST_CODE_PREF_SCREEN = 5;
    private static int RESULT_CODE_EXIT_SETTINGS = 6;
    private final int DIALOG_CREATE_MASTER_PASSWORD = 0;
    private final int DIALOG_REMOVE_MASTER_PASSWORD = 1;

    protected void onCreate(Bundle bundle) {
        String string2;
        if (Build.VERSION.SDK_INT >= 11 && !this.getIntent().hasExtra(":android:show_fragment")) {
            this.setupTopLevelFragmentIntent();
        }
        super.onCreate(bundle);
        Bundle bundle2 = this.getIntent().getExtras();
        if (Build.VERSION.SDK_INT < 11) {
            int n = 0;
            if (bundle2 != null && bundle2.containsKey(INTENT_EXTRA_RESOURCES) && (string2 = bundle2.getString(INTENT_EXTRA_RESOURCES)) != null && (n = this.getResources().getIdentifier(string2, "xml", this.getPackageName())) == 0) {
                Log.e((String)LOGTAG, (String)("No resource found named " + string2));
            }
            if (n == 0) {
                Log.e((String)LOGTAG, (String)"Displaying default settings.");
                n = R.xml.preferences;
            }
            this.addPreferencesFromResource(n);
        }
        this.registerEventListener("Sanitize:Finished");
        ListView listView = this.getListView();
        listView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                ListAdapter listAdapter = ((ListView)adapterView).getAdapter();
                Object object = listAdapter.getItem(n);
                if (object instanceof SearchEnginePreference && object instanceof View.OnLongClickListener) {
                    View.OnLongClickListener onLongClickListener = (View.OnLongClickListener)object;
                    return onLongClickListener.onLongClick(view);
                }
                return false;
            }
        });
        if (Build.VERSION.SDK_INT >= 14) {
            this.getActionBar().setHomeButtonEnabled(true);
        }
        if (bundle2 != null && bundle2.containsKey("datareporting-notification")) {
            string2 = (NotificationManager)this.getSystemService("notification");
            string2.cancel("datareporting-notification".hashCode());
        }
    }

    private void setupTopLevelFragmentIntent() {
        Intent intent = this.getIntent();
        Bundle bundle = intent.getExtras();
        Bundle bundle2 = new Bundle();
        if (bundle != null && bundle.containsKey(INTENT_EXTRA_RESOURCES)) {
            String string2 = bundle.getString(INTENT_EXTRA_RESOURCES);
            bundle2.putString(INTENT_EXTRA_RESOURCES, string2);
        } else if (!this.onIsMultiPane()) {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences");
        } else {
            bundle2.putString(INTENT_EXTRA_RESOURCES, "preferences_customize_tablet");
        }
        intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
        intent.putExtra(":android:show_fragment_args", bundle2);
    }

    public void onBuildHeaders(List<PreferenceActivity.Header> list) {
        if (this.onIsMultiPane()) {
            this.loadHeadersFromResource(R.xml.preference_headers, list);
        }
    }

    public void onWindowFocusChanged(boolean bl) {
        if (!bl || this.mInitialized) {
            return;
        }
        this.mInitialized = true;
        if (Build.VERSION.SDK_INT < 11) {
            PreferenceScreen preferenceScreen = this.getPreferenceScreen();
            this.mPrefsRequestId = this.setupPreferences((PreferenceGroup)preferenceScreen);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterEventListener("Sanitize:Finished");
        if (this.mPrefsRequestId > 0) {
            PrefsHelper.removeObserver(this.mPrefsRequestId);
        }
    }

    public void onPause() {
        super.onPause();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityPause(this);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.getApplication() instanceof GeckoApplication) {
            ((GeckoApplication)this.getApplication()).onActivityResume(this);
        }
    }

    public void startActivity(Intent intent) {
        this.startActivityForResult(intent, REQUEST_CODE_PREF_SCREEN);
    }

    public void startWithFragment(String string2, Bundle bundle, Fragment fragment, int n, int n2, int n3) {
        Intent intent = this.onBuildStartFragmentIntent(string2, bundle, n2, n3);
        if (fragment == null) {
            this.startActivityForResult(intent, REQUEST_CODE_PREF_SCREEN);
        } else {
            fragment.startActivityForResult(intent, n);
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (REQUEST_CODE_PREF_SCREEN == n && RESULT_CODE_EXIT_SETTINGS == n2) {
            this.setResult(RESULT_CODE_EXIT_SETTINGS);
            this.finish();
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Sanitize:Finished")) {
                boolean bl = jSONObject.getBoolean("success");
                int n = bl ? R.string.private_data_success : R.string.private_data_fail;
                GeckoPreferences geckoPreferences = this;
                ThreadUtils.postToUiThread((Runnable)new Runnable((Context)geckoPreferences, n){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ int val$stringRes;
                    {
                        this.val$context = context;
                        this.val$stringRes = n;
                    }

                    public void run() {
                        Toast.makeText((Context)this.val$context, (int)this.val$stringRes, (int)0).show();
                    }
                });
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public int setupPreferences(PreferenceGroup preferenceGroup) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.setupPreferences(preferenceGroup, arrayList);
        return this.getGeckoPreferences(preferenceGroup, arrayList);
    }

    private void setupPreferences(PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        for (int i = 0; i < preferenceGroup.getPreferenceCount(); ++i) {
            GeckoPreferences geckoPreferences;
            Preference preference = preferenceGroup.getPreference(i);
            String string2 = preference.getKey();
            if (preference instanceof PreferenceGroup) {
                if (PREFS_DATA_REPORTING_PREFERENCES.equals(string2)) {
                    // empty if block
                }
                this.setupPreferences((PreferenceGroup)preference, arrayList);
                continue;
            }
            preference.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
            if (PREFS_DEVTOOLS_REMOTE_ENABLED.equals(string2)) {
                geckoPreferences = this;
                preference.setOnPreferenceClickListener(new Preference.OnPreferenceClickListener((Context)geckoPreferences){
                    final /* synthetic */ Context val$thisContext;
                    {
                        this.val$thisContext = context;
                    }

                    public boolean onPreferenceClick(Preference preference) {
                        if (((CheckBoxPreference)preference).isChecked()) {
                            Toast.makeText((Context)this.val$thisContext, (int)R.string.devtools_remote_debugging_forward, (int)0).show();
                        }
                        return true;
                    }
                });
            } else {
                if (PREFS_RESTORE_SESSION.equals(string2)) {
                    geckoPreferences = (ListPreference)preference;
                    CharSequence charSequence = geckoPreferences.getEntry();
                    geckoPreferences.setSummary(charSequence);
                    continue;
                }
                if (PREFS_SYNC.equals(string2) && GeckoProfile.get((Context)this).inGuestMode()) {
                    preferenceGroup.removePreference(preference);
                    --i;
                    continue;
                }
            }
            if (string2 == null || string2.startsWith(NON_PREF_PREFIX)) continue;
            arrayList.add(string2);
        }
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public static void setCharEncodingState(boolean bl) {
        sIsCharEncodingEnabled = bl;
    }

    public static boolean getCharEncodingState() {
        return sIsCharEncodingEnabled;
    }

    public static void broadcastAction(Context context, Intent intent) {
        GeckoPreferences.fillIntentWithProfileInfo(context, intent);
        context.sendBroadcast(intent, "org.mozilla.fennec.permission.PER_ANDROID_PACKAGE");
    }

    public static void broadcastPrefAction(Context context, String string2, String string3, boolean bl) {
        Intent intent = new Intent(string2).putExtra("pref", string3).putExtra("branch", "GeckoApp").putExtra("enabled", bl);
        GeckoPreferences.broadcastAction(context, intent);
    }

    private static void fillIntentWithProfileInfo(Context context, Intent intent) {
        GeckoProfile geckoProfile = GeckoProfile.get(context);
        if (geckoProfile != null) {
            intent.putExtra("profileName", geckoProfile.getName()).putExtra("profilePath", geckoProfile.getDir().getAbsolutePath());
        }
    }

    public static void broadcastAnnouncementsPref(Context context, boolean bl) {
        GeckoPreferences.broadcastPrefAction(context, "org.mozilla.fennec.ANNOUNCEMENTS_PREF", PREFS_ANNOUNCEMENTS_ENABLED, bl);
    }

    public static void broadcastAnnouncementsPref(Context context) {
        boolean bl = GeckoPreferences.getBooleanPref(context, PREFS_ANNOUNCEMENTS_ENABLED, true);
        GeckoPreferences.broadcastAnnouncementsPref(context, bl);
    }

    public static void broadcastHealthReportUploadPref(Context context, boolean bl) {
        GeckoPreferences.broadcastPrefAction(context, "org.mozilla.fennec.HEALTHREPORT_UPLOAD_PREF", PREFS_HEALTHREPORT_UPLOAD_ENABLED, bl);
    }

    public static void broadcastHealthReportUploadPref(Context context) {
        boolean bl = GeckoPreferences.getBooleanPref(context, PREFS_HEALTHREPORT_UPLOAD_ENABLED, true);
        GeckoPreferences.broadcastHealthReportUploadPref(context, bl);
    }

    public static void broadcastHealthReportPrune(Context context) {
        Intent intent = new Intent("org.mozilla.fennec.HEALTHREPORT_PRUNE");
        GeckoPreferences.broadcastAction(context, intent);
    }

    public static boolean getBooleanPref(Context context, String string2, boolean bl) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return sharedPreferences.getBoolean(string2, bl);
    }

    public boolean onPreferenceChange(Preference preference, Object object) {
        String string2 = preference.getKey();
        if (PREFS_MP_ENABLED.equals(string2)) {
            this.showDialog((Boolean)object != false ? 0 : 1);
            return false;
        }
        if (PREFS_MENU_CHAR_ENCODING.equals(string2)) {
            GeckoPreferences.setCharEncodingState(((String)object).equals("true"));
        } else if (PREFS_ANNOUNCEMENTS_ENABLED.equals(string2)) {
            GeckoPreferences.broadcastAnnouncementsPref(GeckoAppShell.getContext(), (Boolean)object);
        } else if (PREFS_UPDATER_AUTODOWNLOAD.equals(string2)) {
            UpdateServiceHelper.registerForUpdates(GeckoAppShell.getContext(), (String)object);
        } else if (PREFS_HEALTHREPORT_UPLOAD_ENABLED.equals(string2)) {
            GeckoPreferences.broadcastHealthReportUploadPref(GeckoAppShell.getContext(), (Boolean)object);
        } else if (PREFS_GEO_REPORTING.equals(string2)) {
            object = (Boolean)object != false ? 1 : 0;
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.startsWith(NON_PREF_PREFIX)) {
            PrefsHelper.setPref(string2, object);
        }
        if (preference instanceof ListPreference) {
            int n = ((ListPreference)preference).findIndexOfValue((String)object);
            CharSequence charSequence = ((ListPreference)preference).getEntries()[n];
            ((ListPreference)preference).setSummary(charSequence);
        } else if (preference instanceof LinkPreference) {
            this.setResult(RESULT_CODE_EXIT_SETTINGS);
            this.finish();
        } else if (preference instanceof FontSizePreference) {
            FontSizePreference fontSizePreference = (FontSizePreference)preference;
            fontSizePreference.setSummary(fontSizePreference.getSavedFontSizeName());
        }
        return true;
    }

    private EditText getTextBox(int n) {
        EditText editText = new EditText(GeckoAppShell.getContext());
        int n2 = 1;
        editText.setInputType(n2 |= 0x80080);
        String string2 = this.getResources().getString(n);
        editText.setHint(n);
        return editText;
    }

    protected Dialog onCreateDialog(int n) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        LinearLayout linearLayout = new LinearLayout((Context)this);
        linearLayout.setOrientation(1);
        AlertDialog alertDialog = null;
        switch (n) {
            case 0: {
                final EditText editText = this.getTextBox(R.string.masterpassword_password);
                final EditText editText2 = this.getTextBox(R.string.masterpassword_confirm);
                linearLayout.addView((View)editText);
                linearLayout.addView((View)editText2);
                builder.setTitle(R.string.masterpassword_create_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("name", (Object)PREFS_MP_ENABLED);
                            jSONObject.put("type", (Object)"string");
                            jSONObject.put("value", (Object)editText.getText().toString());
                            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Preferences:Set", jSONObject.toString());
                            GeckoAppShell.sendEventToGecko(geckoEvent);
                        }
                        catch (Exception exception) {
                            Log.e((String)GeckoPreferences.LOGTAG, (String)"Error setting master password", (Throwable)exception);
                        }
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                        editText2.setText((CharSequence)"");
                        editText.requestFocus();
                    }
                });
                PasswordTextWatcher passwordTextWatcher = new PasswordTextWatcher(editText, editText2, alertDialog);
                editText.addTextChangedListener((TextWatcher)passwordTextWatcher);
                editText2.addTextChangedListener((TextWatcher)passwordTextWatcher);
                break;
            }
            case 1: {
                final EditText editText = this.getTextBox(R.string.masterpassword_password);
                linearLayout.addView((View)editText);
                builder.setTitle(R.string.masterpassword_remove_title).setView((View)linearLayout).setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        PrefsHelper.setPref(PREFS_MP_ENABLED, editText.getText().toString());
                    }
                }).setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                    }
                });
                alertDialog = builder.create();
                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                    public void onShow(DialogInterface dialogInterface) {
                        editText.setText((CharSequence)"");
                    }
                });
                editText.addTextChangedListener((TextWatcher)new EmptyTextWatcher(editText, alertDialog));
                break;
            }
            default: {
                return null;
            }
        }
        return alertDialog;
    }

    private int getGeckoPreferences(final PreferenceGroup preferenceGroup, ArrayList<String> arrayList) {
        return PrefsHelper.getPrefs(arrayList, (PrefsHelper.PrefHandler)new PrefsHelper.PrefHandlerBase(){

            private Preference getField(String string2) {
                return preferenceGroup.findPreference((CharSequence)string2);
            }

            public void prefValue(String string2, final boolean bl) {
                final Preference preference = this.getField(string2);
                final CheckBoxPrefSetter checkBoxPrefSetter = Build.VERSION.SDK_INT < 14 ? new CheckBoxPrefSetter() : new TwoStatePrefSetter();
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        checkBoxPrefSetter.setBooleanPref(preference, bl);
                    }
                });
            }

            public void prefValue(String string2, final String string3) {
                final Preference preference = this.getField(string2);
                if (preference instanceof EditTextPreference) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            ((EditTextPreference)preference).setText(string3);
                        }
                    });
                } else if (preference instanceof ListPreference) {
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            ((ListPreference)preference).setValue(string3);
                            CharSequence charSequence = ((ListPreference)preference).getEntry();
                            ((ListPreference)preference).setSummary(charSequence);
                        }
                    });
                } else if (preference instanceof FontSizePreference) {
                    final FontSizePreference fontSizePreference = (FontSizePreference)preference;
                    fontSizePreference.setSavedFontSize(string3);
                    final String string4 = fontSizePreference.getSavedFontSizeName();
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            fontSizePreference.setSummary(string4);
                        }
                    });
                }
            }

            public void prefValue(String string2, final int n) {
                final Preference preference = this.getField(string2);
                if (PREFS_GEO_REPORTING.equals(string2)) {
                    final CheckBoxPrefSetter checkBoxPrefSetter = Build.VERSION.SDK_INT < 14 ? new CheckBoxPrefSetter() : new TwoStatePrefSetter();
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        public void run() {
                            checkBoxPrefSetter.setBooleanPref(preference, n == 1);
                        }
                    });
                } else {
                    Log.w((String)GeckoPreferences.LOGTAG, (String)("Unhandled int value for pref [" + preference + "]"));
                }
            }

            public boolean isObserver() {
                return true;
            }

            public void finish() {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        preferenceGroup.setEnabled(true);
                    }
                });
            }

            class TwoStatePrefSetter
            extends CheckBoxPrefSetter {
                TwoStatePrefSetter() {
                }

                public void setBooleanPref(Preference preference, boolean bl) {
                    if (preference instanceof TwoStatePreference && ((TwoStatePreference)preference).isChecked() != bl) {
                        ((TwoStatePreference)preference).setChecked(bl);
                    }
                }
            }

            class CheckBoxPrefSetter {
                CheckBoxPrefSetter() {
                }

                public void setBooleanPref(Preference preference, boolean bl) {
                    if (preference instanceof CheckBoxPreference && ((CheckBoxPreference)preference).isChecked() != bl) {
                        ((CheckBoxPreference)preference).setChecked(bl);
                    }
                }
            }
        });
    }

    private void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    private void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    @Override
    public boolean isGeckoActivityOpened() {
        return false;
    }

    public static void setResourceToOpen(Intent intent, String string2) {
        if (intent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        if (string2 == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 11) {
            intent.putExtra(INTENT_EXTRA_RESOURCES, string2);
        } else {
            intent.putExtra(":android:show_fragment", GeckoPreferenceFragment.class.getName());
            Bundle bundle = new Bundle();
            bundle.putString(INTENT_EXTRA_RESOURCES, string2);
            intent.putExtra(":android:show_fragment_args", bundle);
        }
    }

    private class EmptyTextWatcher
    implements TextWatcher {
        EditText input = null;
        AlertDialog dialog = null;

        EmptyTextWatcher(EditText editText, AlertDialog alertDialog) {
            this.input = editText;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class PasswordTextWatcher
    implements TextWatcher {
        EditText input1 = null;
        EditText input2 = null;
        AlertDialog dialog = null;

        PasswordTextWatcher(EditText editText, EditText editText2, AlertDialog alertDialog) {
            this.input1 = editText;
            this.input2 = editText2;
            this.dialog = alertDialog;
        }

        public void afterTextChanged(Editable editable) {
            if (this.dialog == null) {
                return;
            }
            String string2 = this.input1.getText().toString();
            String string3 = this.input2.getText().toString();
            boolean bl = TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || !string2.equals(string3);
            this.dialog.getButton(-1).setEnabled(!bl);
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }
}

