/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.util.INIParser;
import org.mozilla.gecko.util.INISection;

public final class GeckoProfile {
    private static final String LOGTAG = "GeckoProfile";
    private static final String LOCK_FILE_NAME = ".active_lock";
    private static HashMap<String, GeckoProfile> sProfileCache = new HashMap();
    private static String sDefaultProfileName = null;
    private final Context mContext;
    private final String mName;
    private File mMozDir;
    private File mDir;
    private LockState mLocked = LockState.UNDEFINED;
    private static File mGuestDir = null;
    private boolean mInGuestMode = false;
    private static GeckoProfile mGuestProfile = null;

    private static INIParser getProfilesINI(Context context) {
        File file = context.getFilesDir();
        File file2 = new File(file, "mozilla");
        File file3 = new File(file2, "profiles.ini");
        return new INIParser(file3);
    }

    public static GeckoProfile get(Context context) {
        if (context instanceof GeckoApp && ((GeckoApp)context).mProfile != null) {
            return ((GeckoApp)context).mProfile;
        }
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile != null && geckoProfile.locked()) {
            return geckoProfile;
        }
        if (context instanceof GeckoApp) {
            return GeckoProfile.get(context, ((GeckoApp)context).getDefaultProfileName());
        }
        return GeckoProfile.get(context, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoProfile get(Context context, String string2) {
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile != null) {
                return geckoProfile;
            }
        }
        return GeckoProfile.get(context, string2, (File)null);
    }

    public static GeckoProfile get(Context context, String string2, String string3) {
        File file = null;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            file = new File(string3);
        }
        return GeckoProfile.get(context, string2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeckoProfile get(Context context, String string2, File file) {
        if (context == null) {
            throw new IllegalArgumentException("context must be non-null");
        }
        if (TextUtils.isEmpty((CharSequence)string2) && file == null && (string2 = GeckoProfile.findDefaultProfile(context)) == null) {
            string2 = "default";
        }
        HashMap<String, GeckoProfile> hashMap = sProfileCache;
        synchronized (hashMap) {
            GeckoProfile geckoProfile = sProfileCache.get(string2);
            if (geckoProfile == null) {
                geckoProfile = new GeckoProfile(context, string2, file);
                sProfileCache.put(string2, geckoProfile);
            } else {
                geckoProfile.setDir(file);
            }
            return geckoProfile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File ensureMozillaDirectory(Context context) throws IOException {
        Context context2 = context;
        synchronized (context2) {
            File file = context.getFilesDir();
            File file2 = new File(file, "mozilla");
            if (!file2.exists() && !file2.mkdirs()) {
                throw new IOException("Unable to create mozilla directory at " + file2.getAbsolutePath());
            }
            return file2;
        }
    }

    public static boolean removeProfile(Context context, String string2) {
        return new GeckoProfile(context, string2).remove();
    }

    public static GeckoProfile createGuestProfile(Context context) {
        try {
            GeckoProfile.removeGuestProfile(context);
            GeckoProfile.getGuestDir(context).mkdir();
            GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
            geckoProfile.lock();
            return geckoProfile;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error creating guest profile", (Throwable)exception);
            return null;
        }
    }

    public static void leaveGuestSession(Context context) {
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile != null) {
            geckoProfile.unlock();
        }
    }

    private static File getGuestDir(Context context) {
        if (mGuestDir == null) {
            mGuestDir = context.getFileStreamPath("guest");
        }
        return mGuestDir;
    }

    private static GeckoProfile getGuestProfile(Context context) {
        File file;
        if (mGuestProfile == null && (file = GeckoProfile.getGuestDir(context)).exists()) {
            mGuestProfile = GeckoProfile.get(context, "guest", file);
            GeckoProfile.mGuestProfile.mInGuestMode = true;
        }
        return mGuestProfile;
    }

    public static boolean maybeCleanupGuestProfile(Context context) {
        GeckoProfile geckoProfile = GeckoProfile.getGuestProfile(context);
        if (geckoProfile == null) {
            return false;
        }
        if (!geckoProfile.locked()) {
            geckoProfile.mInGuestMode = false;
            GeckoProfile.removeGuestProfile(context);
            return true;
        }
        return false;
    }

    private static void removeGuestProfile(Context context) {
        try {
            File file = GeckoProfile.getGuestDir(context);
            if (file.exists()) {
                GeckoProfile.delete(file);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error removing guest profile", (Throwable)exception);
        }
    }

    public static boolean delete(File file) throws IOException {
        if (file.delete()) {
            return true;
        }
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                File file2 = new File(file, string2);
                GeckoProfile.delete(file2);
            }
        }
        return file.delete();
    }

    public boolean locked() {
        File file;
        boolean bl;
        if (this.mLocked != LockState.UNDEFINED) {
            return this.mLocked == LockState.LOCKED;
        }
        this.mLocked = this.mDir != null && this.mDir.exists() ? ((bl = (file = new File(this.mDir, LOCK_FILE_NAME)).exists()) ? LockState.LOCKED : LockState.UNLOCKED) : LockState.UNLOCKED;
        return this.mLocked == LockState.LOCKED;
    }

    public boolean lock() {
        try {
            File file = new File(this.getDir(), LOCK_FILE_NAME);
            boolean bl = file.createNewFile();
            this.mLocked = bl ? LockState.LOCKED : LockState.UNLOCKED;
            return bl;
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error locking profile", (Throwable)iOException);
            this.mLocked = LockState.UNLOCKED;
            return false;
        }
    }

    public boolean unlock() {
        if (this.mDir == null || !this.mDir.exists()) {
            return true;
        }
        try {
            File file = new File(this.mDir, LOCK_FILE_NAME);
            boolean bl = GeckoProfile.delete(file);
            this.mLocked = bl ? LockState.UNLOCKED : LockState.LOCKED;
            return bl;
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error unlocking profile", (Throwable)iOException);
            this.mLocked = LockState.LOCKED;
            return false;
        }
    }

    private GeckoProfile(Context context, String string2) {
        this.mContext = context;
        this.mName = string2;
    }

    private GeckoProfile(Context context, String string2, File file) {
        this.mContext = context;
        this.mName = string2;
        this.setDir(file);
    }

    public boolean inGuestMode() {
        return this.mInGuestMode;
    }

    private void setDir(File file) {
        if (file != null && file.exists() && file.isDirectory()) {
            this.mDir = file;
        } else {
            Log.w((String)LOGTAG, (String)("requested profile directory missing: " + file));
        }
    }

    public String getName() {
        return this.mName;
    }

    public synchronized File getDir() {
        this.forceCreate();
        return this.mDir;
    }

    public synchronized GeckoProfile forceCreate() {
        if (this.mDir != null) {
            return this;
        }
        try {
            File file = GeckoProfile.ensureMozillaDirectory(this.mContext);
            this.mDir = this.findProfileDir(file);
            if (this.mDir == null) {
                this.mDir = this.createProfileDir(file);
            } else {
                Log.d((String)LOGTAG, (String)("Found profile dir: " + this.mDir.getAbsolutePath()));
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting profile dir", (Throwable)iOException);
        }
        return this;
    }

    public File getFile(String string2) {
        File file = this.getDir();
        if (file == null) {
            return null;
        }
        return new File(file, string2);
    }

    public File getFilesDir() {
        return this.mContext.getFilesDir();
    }

    public void moveSessionFile() {
        File file = this.getFile("sessionstore.js");
        if (file != null && file.exists()) {
            File file2 = this.getFile("sessionstore.bak");
            file.renameTo(file2);
        }
    }

    public String readSessionFile(boolean bl) {
        File file = this.getFile(bl ? "sessionstore.bak" : "sessionstore.js");
        try {
            if (file != null && file.exists()) {
                return this.readFile(file);
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Unable to read session file", (Throwable)iOException);
        }
        return null;
    }

    public String readFile(String string2) throws IOException {
        File file = this.getDir();
        if (file == null) {
            throw new IOException("No profile directory found");
        }
        File file2 = new File(file, string2);
        return this.readFile(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            int n = fileReader.read(cArray);
            while (n >= 0) {
                stringBuilder.append(cArray, 0, n);
                n = fileReader.read(cArray);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            fileReader.close();
        }
    }

    private boolean remove() {
        try {
            File file = this.getDir();
            if (file.exists()) {
                GeckoProfile.delete(file);
            }
            File file2 = GeckoProfile.ensureMozillaDirectory(this.mContext);
            this.mDir = this.findProfileDir(file2);
            if (this.mDir == null) {
                return false;
            }
            INIParser iNIParser = GeckoProfile.getProfilesINI(this.mContext);
            Hashtable hashtable = iNIParser.getSections();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = (INISection)enumeration.nextElement();
                String string2 = iNISection.getStringProperty("Name");
                if (string2 == null || !string2.equals(this.mName)) continue;
                if (iNISection.getName().startsWith("Profile")) {
                    try {
                        int n = Integer.parseInt(iNISection.getName().substring("Profile".length()));
                        String string3 = "Profile" + n;
                        String string4 = "Profile" + (n + 1);
                        hashtable.remove(string3);
                        while (hashtable.containsKey(string4)) {
                            iNIParser.renameSection(string4, string3);
                            string3 = string4;
                            string4 = "Profile" + (++n + 1);
                        }
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.e((String)LOGTAG, (String)("Malformed section name in profiles.ini: " + iNISection.getName()));
                        return false;
                    }
                }
                iNIParser.removeSection(this.mName);
                return true;
            }
            iNIParser.write();
            return true;
        }
        catch (IOException iOException) {
            Log.w((String)LOGTAG, (String)("Failed to remove profile " + this.mName + ":\n" + iOException));
            return false;
        }
    }

    public static String findDefaultProfile(Context context) {
        if (sDefaultProfileName != null) {
            return sDefaultProfileName;
        }
        INIParser iNIParser = GeckoProfile.getProfilesINI(context);
        Enumeration enumeration = iNIParser.getSections().elements();
        while (enumeration.hasMoreElements()) {
            INISection iNISection = (INISection)enumeration.nextElement();
            if (iNISection.getIntProperty("Default") != 1) continue;
            sDefaultProfileName = iNISection.getStringProperty("Name");
            return sDefaultProfileName;
        }
        return null;
    }

    private File findProfileDir(File file) {
        INIParser iNIParser = GeckoProfile.getProfilesINI(this.mContext);
        Enumeration enumeration = iNIParser.getSections().elements();
        while (enumeration.hasMoreElements()) {
            INISection iNISection = (INISection)enumeration.nextElement();
            String string2 = iNISection.getStringProperty("Name");
            if (string2 == null || !string2.equals(this.mName)) continue;
            if (iNISection.getIntProperty("IsRelative") == 1) {
                return new File(file, iNISection.getStringProperty("Path"));
            }
            return new File(iNISection.getStringProperty("Path"));
        }
        return null;
    }

    private static String saltProfileName(String string2) {
        String string3 = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder stringBuilder = new StringBuilder(16);
        for (int i = 0; i < 8; ++i) {
            stringBuilder.append(string3.charAt((int)(Math.random() * (double)string3.length())));
        }
        stringBuilder.append('.');
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createProfileDir(File file) throws IOException {
        Object object;
        INIParser iNIParser = GeckoProfile.getProfilesINI(this.mContext);
        String string2 = GeckoProfile.saltProfileName(this.mName);
        File file2 = new File(file, string2);
        while (file2.exists()) {
            string2 = GeckoProfile.saltProfileName(this.mName);
            file2 = new File(file, string2);
        }
        if (!file2.mkdirs()) {
            throw new IOException("Unable to create profile at " + file2.getAbsolutePath());
        }
        Log.d((String)LOGTAG, (String)("Created new profile dir at " + file2.getAbsolutePath()));
        int n = 0;
        while (iNIParser.getSection("Profile" + n) != null) {
            ++n;
        }
        INISection iNISection = new INISection("Profile" + n);
        iNISection.setProperty("Name", (Object)this.mName);
        iNISection.setProperty("IsRelative", (Object)1);
        iNISection.setProperty("Path", (Object)string2);
        if (iNIParser.getSection("General") == null) {
            object = new INISection("General");
            object.setProperty("StartWithLastProfile", (Object)1);
            iNIParser.addSection(object);
            iNISection.setProperty("Default", (Object)1);
        }
        iNIParser.addSection(iNISection);
        iNIParser.write();
        try {
            object = new FileOutputStream(file2.getAbsolutePath() + File.separator + "times.json");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object, Charset.forName("UTF-8"));
            try {
                outputStreamWriter.append("{\"created\": " + System.currentTimeMillis() + "}\n");
            }
            finally {
                outputStreamWriter.close();
            }
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Couldn't write times.json.", (Throwable)exception);
        }
        return file2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LockState {
        LOCKED,
        UNLOCKED,
        UNDEFINED;

    }
}

