/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.OrientationEventListener;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;

public class GeckoScreenOrientationListener {
    private static final String LOGTAG = "GeckoScreenOrientationListener";
    private static GeckoScreenOrientationListener sInstance = null;
    public static final short eScreenOrientation_None = 0;
    public static final short eScreenOrientation_PortraitPrimary = 1;
    public static final short eScreenOrientation_PortraitSecondary = 2;
    public static final short eScreenOrientation_LandscapePrimary = 4;
    public static final short eScreenOrientation_LandscapeSecondary = 8;
    public static final short eScreenOrientation_Default = 16;
    private static final short DEFAULT_ORIENTATION = -1;
    private short mOrientation;
    private OrientationEventListenerImpl mListener = new OrientationEventListenerImpl(GeckoAppShell.getContext());
    private boolean mShouldBeListening = false;
    private boolean mShouldNotify = false;
    private short mDefaultOrientation;
    private static final String DEFAULT_ORIENTATION_PREF = "app.orientation.default";

    private GeckoScreenOrientationListener() {
        PrefsHelper.getPref(DEFAULT_ORIENTATION_PREF, new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, String string3) {
                GeckoScreenOrientationListener.this.mDefaultOrientation = GeckoScreenOrientationListener.this.orientationFromStringArray(string3);
                GeckoScreenOrientationListener.this.unlockScreenOrientation();
            }

            public boolean isObserver() {
                return true;
            }
        });
        this.mDefaultOrientation = (short)-1;
    }

    public static GeckoScreenOrientationListener getInstance() {
        if (sInstance == null) {
            sInstance = new GeckoScreenOrientationListener();
        }
        return sInstance;
    }

    public void start() {
        this.mShouldBeListening = true;
        this.updateScreenOrientation();
        if (this.mShouldNotify) {
            this.startListening();
        }
    }

    public void stop() {
        this.mShouldBeListening = false;
        if (this.mShouldNotify) {
            this.stopListening();
        }
    }

    public void enableNotifications() {
        this.updateScreenOrientation();
        this.mShouldNotify = true;
        if (this.mShouldBeListening) {
            this.startListening();
        }
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
        if (this.mShouldBeListening) {
            this.stopListening();
        }
    }

    private void startListening() {
        this.mListener.enable();
    }

    private void stopListening() {
        this.mListener.disable();
    }

    private short orientationFromStringArray(String string2) {
        List<String> list = Arrays.asList(string2.split(","));
        if (list.size() == 0) {
            return -1;
        }
        return this.orientationFromString(list.get(0));
    }

    private short orientationFromString(String string2) {
        if ("portrait".equals(string2)) {
            return 7;
        }
        if ("landscape".equals(string2)) {
            return 6;
        }
        if ("portrait-primary".equals(string2)) {
            return 1;
        }
        if ("portrait-secondary".equals(string2)) {
            return 9;
        }
        if ("landscape-primary".equals(string2)) {
            return 0;
        }
        if ("landscape-secondary".equals(string2)) {
            return 8;
        }
        return -1;
    }

    private void updateScreenOrientation() {
        Context context = GeckoAppShell.getContext();
        int n = this.mDefaultOrientation;
        if (context instanceof Activity) {
            n = ((Activity)context).getWindowManager().getDefaultDisplay().getRotation();
        }
        short s = this.mOrientation;
        if (n == 0) {
            this.mOrientation = 1;
        } else if (n == 2) {
            this.mOrientation = (short)2;
        } else if (n == 3) {
            this.mOrientation = (short)8;
        } else if (n == 1) {
            this.mOrientation = (short)4;
        } else {
            Log.e((String)LOGTAG, (String)("Unexpected value received! (" + n + ")"));
            return;
        }
        if (this.mShouldNotify && this.mOrientation != s) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createScreenOrientationEvent(this.mOrientation));
        }
    }

    public short getScreenOrientation() {
        return this.mOrientation;
    }

    public void lockScreenOrientation(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 9;
                break;
            }
            case 3: {
                n2 = 7;
                break;
            }
            case 4: {
                n2 = 0;
                break;
            }
            case 8: {
                n2 = 8;
                break;
            }
            case 12: {
                n2 = 6;
                break;
            }
            case 16: {
                n2 = 5;
                break;
            }
            default: {
                Log.e((String)LOGTAG, (String)("Unexpected value received! (" + n + ")"));
                return;
            }
        }
        if (GeckoAppShell.getContext() instanceof Activity) {
            ((Activity)GeckoAppShell.getContext()).setRequestedOrientation(n2);
        }
        this.updateScreenOrientation();
    }

    public void unlockScreenOrientation() {
        if (!(GeckoAppShell.getContext() instanceof Activity)) {
            return;
        }
        if (((Activity)GeckoAppShell.getContext()).getRequestedOrientation() == this.mDefaultOrientation) {
            return;
        }
        ((Activity)GeckoAppShell.getContext()).setRequestedOrientation((int)this.mDefaultOrientation);
        this.updateScreenOrientation();
    }

    static class OrientationEventListenerImpl
    extends OrientationEventListener {
        public OrientationEventListenerImpl(Context context) {
            super(context);
        }

        public void onOrientationChanged(int n) {
            GeckoScreenOrientationListener.getInstance().updateScreenOrientation();
        }
    }
}

