/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.util.AttributeSet;
import org.json.JSONObject;
import org.mozilla.gecko.BaseGeckoInterface;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoView
extends LayerView
implements GeckoEventListener,
ContextGetter {
    private static final String LOGTAG = "GeckoView";

    public GeckoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Object object;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GeckoView);
        String string2 = typedArray.getString(0);
        boolean bl = typedArray.getBoolean(1, true);
        typedArray.recycle();
        if (!bl) {
            return;
        }
        if (!(context instanceof GeckoActivity)) {
            if (context instanceof Activity && GeckoView.getGeckoInterface() == null) {
                GeckoView.setGeckoInterface(new BaseGeckoInterface(context));
            }
            Clipboard.init((Context)context);
            HardwareUtils.init((Context)context);
            GeckoNetworkManager.getInstance().init(context);
            GeckoLoader.loadMozGlue();
            BrowserDB.setEnableContentProviders(false);
        }
        if (string2 != null) {
            GeckoThread.setUri(string2);
            GeckoThread.setAction("android.intent.action.VIEW");
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string2));
        }
        GeckoAppShell.setContextGetter(this);
        if (context instanceof Activity) {
            object = Tabs.getInstance();
            ((Tabs)object).attachToContext(context);
        }
        GeckoAppShell.registerEventListener("Gecko:Ready", this);
        ThreadUtils.setUiThread((Thread)Thread.currentThread(), (Handler)new Handler());
        this.initializeView(GeckoAppShell.getEventDispatcher());
        object = GeckoProfile.get(context).forceCreate();
        BrowserDB.initialize(((GeckoProfile)object).getName());
        if (GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.Launched)) {
            GeckoAppShell.setLayerView(this);
            GeckoThread.createAndStart();
        }
    }

    public void loadUrl(String string2) {
        Tabs.getInstance().loadUrl(string2);
    }

    public void loadUrlInNewTab(String string2) {
        Tabs.getInstance().loadUrl(string2, 1);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (string2.equals("Gecko:Ready")) {
            GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoRunning);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                Tabs.getInstance().notifyListeners(tab, Tabs.TabEvents.SELECTED);
            }
            this.geckoConnected();
            GeckoAppShell.setLayerClient(this.getLayerClient());
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Viewport:Flush", null));
            this.show();
            this.requestRender();
        }
    }

    public static void setGeckoInterface(BaseGeckoInterface baseGeckoInterface) {
        GeckoAppShell.setGeckoInterface(baseGeckoInterface);
    }

    public static GeckoAppShell.GeckoInterface getGeckoInterface() {
        return GeckoAppShell.getGeckoInterface();
    }
}

