/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.util.ThreadUtils;

class GlobalHistory {
    private static final String LOGTAG = "GeckoGlobalHistory";
    private static GlobalHistory sInstance = new GlobalHistory();
    private static final long BATCHING_DELAY_MS = 100L;
    private final Handler mHandler = ThreadUtils.getBackgroundHandler();
    private final Queue<String> mPendingUris = new LinkedList<String>();
    private SoftReference<Set<String>> mVisitedCache = new SoftReference<Object>(null);
    private final Runnable mNotifierRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string2;
            HashSet<String> hashSet = (HashSet<String>)GlobalHistory.this.mVisitedCache.get();
            if (hashSet == null) {
                Log.w((String)GlobalHistory.LOGTAG, (String)"Rebuilding visited link set...");
                hashSet = new HashSet<String>();
                string2 = null;
                try {
                    string2 = BrowserDB.getAllVisitedHistory(GeckoAppShell.getContext().getContentResolver());
                    if (string2 == null) {
                        return;
                    }
                    if (string2.moveToFirst()) {
                        do {
                            hashSet.add(string2.getString(0));
                        } while (string2.moveToNext());
                    }
                    GlobalHistory.this.mVisitedCache = new SoftReference(hashSet);
                }
                finally {
                    if (string2 != null) {
                        string2.close();
                    }
                }
            }
            while ((string2 = (String)GlobalHistory.this.mPendingUris.poll()) != null) {
                if (!hashSet.contains(string2)) continue;
                GeckoAppShell.notifyUriVisited(string2);
            }
            GlobalHistory.this.mProcessing = false;
        }
    };
    private boolean mProcessing;

    static GlobalHistory getInstance() {
        return sInstance;
    }

    private GlobalHistory() {
    }

    public void addToGeckoOnly(String string2) {
        Set<String> set = this.mVisitedCache.get();
        if (set != null) {
            set.add(string2);
        }
        GeckoAppShell.notifyUriVisited(string2);
    }

    private boolean canAddURI(String string2) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string2.startsWith("http:") || string2.startsWith("https:")) {
            return true;
        }
        String string3 = Uri.parse((String)string2).getScheme();
        if (string3 == null) {
            return false;
        }
        return !string3.equals("about") && !string3.equals("imap") && !string3.equals("news") && !string3.equals("mailbox") && !string3.equals("moz-anno") && !string3.equals("view-source") && !string3.equals("chrome") && !string3.equals("resource") && !string3.equals("data") && !string3.equals("wyciwyg") && !string3.equals("javascript");
    }

    public void add(String string2) {
        if (!this.canAddURI(string2)) {
            return;
        }
        BrowserDB.updateVisitedHistory(GeckoAppShell.getContext().getContentResolver(), string2);
        this.addToGeckoOnly(string2);
    }

    public void update(String string2, String string3) {
        if (!this.canAddURI(string2)) {
            return;
        }
        BrowserDB.updateHistoryTitle(GeckoAppShell.getContext().getContentResolver(), string2, string3);
    }

    public void checkUriVisited(final String string2) {
        this.mHandler.post(new Runnable(){

            public void run() {
                GlobalHistory.this.mPendingUris.add(string2);
                if (GlobalHistory.this.mProcessing) {
                    return;
                }
                GlobalHistory.this.mProcessing = true;
                GlobalHistory.this.mHandler.postDelayed(GlobalHistory.this.mNotifierRunnable, 100L);
            }
        });
    }
}

