/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;

public final class NotificationHelper
implements GeckoEventListener {
    public static final String NOTIFICATION_ID = "NotificationHelper_ID";
    private static final String LOGTAG = "GeckoNotificationManager";
    private static final String HELPER_NOTIFICATION = "helperNotif";
    private static final String HELPER_BROADCAST_ACTION = "helperBroadcastAction";
    private static final String TITLE_ATTR = "title";
    private static final String TEXT_ATTR = "text";
    private static final String ID_ATTR = "id";
    private static final String SMALLICON_ATTR = "smallIcon";
    private static final String PROGRESS_VALUE_ATTR = "progress_value";
    private static final String PROGRESS_MAX_ATTR = "progress_max";
    private static final String LIGHT_ATTR = "light";
    private static final String ONGOING_ATTR = "ongoing";
    private static final String WHEN_ATTR = "when";
    private static final String LARGE_ICON_ATTR = "largeIcon";
    private static final String COOKIE_ATTR = "cookie";
    private static final String EVENT_TYPE_ATTR = "eventType";
    private static final String ACTIONS_ATTR = "actions";
    private static final String ACTION_ATTR = "actionKind";
    private static final String ACTION_TITLE_ATTR = "title";
    private static final String ACTION_ICON_ATTR = "icon";
    private static final String NOTIFICATION_SCHEME = "moz-notification";
    private static final String CLICK_EVENT = "notification-clicked";
    private static final String CLEARED_EVENT = "notification-cleared";
    private static Context mContext;
    private static Set<String> mShowing;
    private static BroadcastReceiver mReceiver;
    private static NotificationHelper mInstance;

    private NotificationHelper() {
    }

    public static void init(Context context) {
        if (mInstance != null) {
            Log.w((String)LOGTAG, (String)"NotificationHelper.init() called twice!");
        }
        mInstance = new NotificationHelper();
        mContext = context;
        mShowing = new HashSet<String>();
        NotificationHelper.registerEventListener("Notification:Show");
        NotificationHelper.registerEventListener("Notification:Hide");
        NotificationHelper.registerReceiver(context);
    }

    private static void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)mInstance);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (string2.equals("Notification:Show")) {
            this.showNotification(jSONObject);
        } else if (string2.equals("Notification:Hide")) {
            this.hideNotification(jSONObject);
        }
    }

    public boolean isHelperIntent(Intent intent) {
        return intent.getBooleanExtra(HELPER_NOTIFICATION, false);
    }

    private static void registerReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter(HELPER_BROADCAST_ACTION);
        intentFilter.addDataScheme(NOTIFICATION_SCHEME);
        mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                mInstance.handleNotificationIntent(intent);
            }
        };
        context.registerReceiver(mReceiver, intentFilter);
    }

    private void handleNotificationIntent(Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            Log.w((String)LOGTAG, (String)"handleNotificationEvent: empty data");
            return;
        }
        String string2 = uri.getQueryParameter(ID_ATTR);
        String string3 = uri.getQueryParameter(EVENT_TYPE_ATTR);
        if (string2 == null || string3 == null) {
            Log.w((String)LOGTAG, (String)"handleNotificationEvent: invalid intent parameters");
            return;
        }
        if (CLEARED_EVENT.equals(string3)) {
            mShowing.remove(string2);
        }
        if (CLICK_EVENT.equals(string3) && !intent.getBooleanExtra(ONGOING_ATTR, false)) {
            this.hideNotification(string2);
        }
        String string4 = uri.getQueryParameter(COOKIE_ATTR);
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(NOTIFICATION_ID, (Object)string2);
                if (string4 != null) {
                    jSONObject.put(COOKIE_ATTR, (Object)string4);
                }
                jSONObject.put(EVENT_TYPE_ATTR, (Object)string3);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Notification:Event", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"Error building JSON notification arguments.", (Throwable)jSONException);
            }
        }
    }

    private PendingIntent buildNotificationPendingIntent(JSONObject jSONObject, String string2) {
        String string3;
        Intent intent = new Intent(HELPER_BROADCAST_ACTION);
        boolean bl = jSONObject.optBoolean(ONGOING_ATTR);
        intent.putExtra(ONGOING_ATTR, bl);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(NOTIFICATION_SCHEME).appendQueryParameter(EVENT_TYPE_ATTR, string2);
        try {
            string3 = jSONObject.getString(ID_ATTR);
            builder.appendQueryParameter(ID_ATTR, string3);
            if (jSONObject.has(COOKIE_ATTR)) {
                builder.appendQueryParameter(COOKIE_ATTR, jSONObject.getString(COOKIE_ATTR));
            }
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"buildNotificationPendingIntent, error parsing", (Throwable)jSONException);
        }
        string3 = builder.build();
        intent.setData((Uri)string3);
        intent.putExtra(HELPER_NOTIFICATION, true);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)mContext, (int)0, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    private void showNotification(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONArray jSONArray;
        int n;
        int n2;
        String string2;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(mContext);
        try {
            builder.setContentTitle((CharSequence)jSONObject.getString("title"));
            builder.setContentText((CharSequence)jSONObject.getString(TEXT_ATTR));
            string2 = jSONObject.getString(ID_ATTR);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            return;
        }
        Uri uri = Uri.parse((String)jSONObject.optString(SMALLICON_ATTR));
        builder.setSmallIcon(BitmapUtils.getResource(uri, R.drawable.ic_status_logo));
        JSONArray jSONArray2 = jSONObject.optJSONArray(LIGHT_ATTR);
        if (jSONArray2 != null && jSONArray2.length() == 3) {
            try {
                builder.setLights(jSONArray2.getInt(0), jSONArray2.getInt(1), jSONArray2.getInt(2));
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        boolean bl = jSONObject.optBoolean(ONGOING_ATTR);
        builder.setOngoing(bl);
        if (jSONObject.has(WHEN_ATTR)) {
            n2 = jSONObject.optInt(WHEN_ATTR);
            builder.setWhen((long)n2);
        }
        if (jSONObject.has(LARGE_ICON_ATTR)) {
            Bitmap bitmap = BitmapUtils.getBitmapFromDataURI(jSONObject.optString(LARGE_ICON_ATTR));
            builder.setLargeIcon(bitmap);
        }
        if (jSONObject.has(PROGRESS_VALUE_ATTR) && jSONObject.has(PROGRESS_MAX_ATTR)) {
            try {
                n2 = jSONObject.getInt(PROGRESS_VALUE_ATTR);
                n = jSONObject.getInt(PROGRESS_MAX_ATTR);
                builder.setProgress(n, n2, false);
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        if ((jSONArray = jSONObject.optJSONArray(ACTIONS_ATTR)) != null) {
            try {
                for (n = 0; n < jSONArray.length(); ++n) {
                    jSONObject2 = jSONArray.getJSONObject(n);
                    PendingIntent pendingIntent = this.buildNotificationPendingIntent(jSONObject, jSONObject2.getString(ACTION_ATTR));
                    String string3 = jSONObject2.getString("title");
                    Uri uri2 = Uri.parse((String)jSONObject2.optString(ACTION_ICON_ATTR));
                    builder.addAction(BitmapUtils.getResource(uri2, R.drawable.ic_status_logo), (CharSequence)string3, pendingIntent);
                }
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        PendingIntent pendingIntent = this.buildNotificationPendingIntent(jSONObject, CLICK_EVENT);
        builder.setContentIntent(pendingIntent);
        jSONObject2 = this.buildNotificationPendingIntent(jSONObject, CLEARED_EVENT);
        builder.setDeleteIntent((PendingIntent)jSONObject2);
        GeckoAppShell.sNotificationClient.add(string2.hashCode(), builder.build());
        if (!mShowing.contains(string2)) {
            mShowing.add(string2);
        }
    }

    private void hideNotification(JSONObject jSONObject) {
        String string2;
        try {
            string2 = jSONObject.getString(ID_ATTR);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            return;
        }
        this.hideNotification(string2);
    }

    public void hideNotification(String string2) {
        GeckoAppShell.sNotificationClient.remove(string2.hashCode());
        mShowing.remove(string2);
    }

    private void clearAll() {
        for (String string2 : mShowing) {
            this.hideNotification(string2);
        }
    }
}

