/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.CanvasDelegate;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.GeckoImageButton;

public class ShapedButton
extends GeckoImageButton
implements CanvasDelegate.DrawManager {
    protected GeckoActivity mActivity;
    private Path mPath;
    private CurveTowards mSide;
    protected CanvasDelegate mCanvasDelegate;

    public ShapedButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mActivity = (GeckoActivity)context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.BrowserToolbarCurve);
        int n = typedArray.getInt(0, 0);
        typedArray.recycle();
        this.mSide = n == 0 ? CurveTowards.NONE : (n == 1 ? CurveTowards.LEFT : CurveTowards.RIGHT);
        this.mPath = new Path();
        this.mCanvasDelegate = new CanvasDelegate(this, PorterDuff.Mode.DST_IN);
        this.setWillNotDraw(false);
    }

    public void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.mSide == CurveTowards.NONE) {
            return;
        }
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        int n5 = (int)((float)n4 * 1.125f);
        this.mPath.reset();
        if (this.mSide == CurveTowards.RIGHT) {
            this.mPath.moveTo(0.0f, 0.0f);
            this.mPath.cubicTo((float)n5 * 0.75f, 0.0f, (float)n5 * 0.25f, (float)n4, (float)n5, (float)n4);
            this.mPath.lineTo((float)n3, (float)n4);
            this.mPath.lineTo((float)n3, 0.0f);
            this.mPath.lineTo(0.0f, 0.0f);
        } else if (this.mSide == CurveTowards.LEFT) {
            this.mPath.moveTo((float)n3, 0.0f);
            this.mPath.cubicTo((float)n3 - (float)n5 * 0.75f, 0.0f, (float)n3 - (float)n5 * 0.25f, (float)n4, (float)(n3 - n5), (float)n4);
            this.mPath.lineTo(0.0f, (float)n4);
            this.mPath.lineTo(0.0f, 0.0f);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mCanvasDelegate != null && this.mSide != CurveTowards.NONE) {
            this.mCanvasDelegate.draw(canvas, this.mPath, this.getWidth(), this.getHeight());
        } else {
            this.defaultDraw(canvas);
        }
    }

    public void defaultDraw(Canvas canvas) {
        super.draw(canvas);
    }

    public void onLightweightThemeChanged() {
        int n = this.mActivity.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mActivity.getLightweightTheme().getColorDrawable((View)this, n);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 34);
        Resources resources = this.getContext().getResources();
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_shaped)));
        stateListDrawable.addState(new int[]{16842908}, (Drawable)new ColorDrawable(resources.getColor(R.color.highlight_shaped_focused)));
        stateListDrawable.addState(new int[]{R.attr.state_private}, (Drawable)new ColorDrawable(resources.getColor(R.color.background_tabs)));
        stateListDrawable.addState(new int[0], (Drawable)lightweightThemeDrawable);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.shaped_button);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        if (this.getBackground() == null || drawable2 == null) {
            super.setBackgroundDrawable(drawable2);
            return;
        }
        int[] nArray = new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
        drawable2.setLevel(this.getBackground().getLevel());
        super.setBackgroundDrawable(drawable2);
        this.setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setBackgroundResource(int n) {
        if (this.getBackground() == null || n == 0) {
            super.setBackgroundResource(n);
            return;
        }
        this.setBackgroundDrawable(this.getContext().getResources().getDrawable(n));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CurveTowards {
        NONE,
        LEFT,
        RIGHT;

    }
}

