/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.DoorHanger;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.ArrowPopup;

public class SiteIdentityPopup
extends ArrowPopup
implements DoorHanger.OnButtonClickListener {
    private static final String LOGTAG = "GeckoSiteIdentityPopup";
    public static final String UNKNOWN = "unknown";
    public static final String VERIFIED = "verified";
    public static final String IDENTIFIED = "identified";
    public static final String MIXED_CONTENT_BLOCKED = "mixed_content_blocked";
    public static final String MIXED_CONTENT_LOADED = "mixed_content_loaded";
    public static final int LEVEL_UKNOWN = 0;
    public static final int LEVEL_IDENTIFIED = 1;
    public static final int LEVEL_VERIFIED = 2;
    public static final int LEVEL_MIXED_CONTENT_BLOCKED = 3;
    public static final int LEVEL_MIXED_CONTENT_LOADED = 4;
    private static final String MIXED_CONTENT_SUPPORT_URL = "https://support.mozilla.org/kb/how-does-content-isnt-secure-affect-my-safety";
    private Resources mResources;
    private LinearLayout mIdentity;
    private TextView mHost;
    private TextView mOwner;
    private TextView mVerifier;
    private DoorHanger mMixedContentNotification;

    SiteIdentityPopup(BrowserApp browserApp) {
        super(browserApp, null);
        this.mResources = browserApp.getResources();
    }

    public static int getSecurityImageLevel(String string2) {
        if (IDENTIFIED.equals(string2)) {
            return 1;
        }
        if (VERIFIED.equals(string2)) {
            return 2;
        }
        if (MIXED_CONTENT_BLOCKED.equals(string2)) {
            return 3;
        }
        if (MIXED_CONTENT_LOADED.equals(string2)) {
            return 4;
        }
        return 0;
    }

    protected void init() {
        super.init();
        this.setFocusable(true);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mActivity);
        this.mIdentity = (LinearLayout)layoutInflater.inflate(R.layout.site_identity, null);
        this.mContent.addView((View)this.mIdentity);
        this.mHost = (TextView)this.mIdentity.findViewById(R.id.host);
        this.mOwner = (TextView)this.mIdentity.findViewById(R.id.owner);
        this.mVerifier = (TextView)this.mIdentity.findViewById(R.id.verifier);
    }

    private void setIdentity(JSONObject jSONObject) {
        try {
            String string2 = jSONObject.getString("host");
            this.mHost.setText((CharSequence)string2);
            String string3 = jSONObject.getString("owner");
            String string4 = jSONObject.optString("supplemental");
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                string3 = string3 + "\n" + string4;
            }
            this.mOwner.setText((CharSequence)string3);
            String string5 = jSONObject.getString("verifier");
            String string6 = jSONObject.getString("encrypted");
            this.mVerifier.setText((CharSequence)(string5 + "\n" + string6));
            this.mContent.setPadding(0, 0, 0, 0);
            this.mIdentity.setVisibility(0);
        }
        catch (JSONException jSONException) {
            this.mContent.setPadding(0, (int)this.mResources.getDimension(R.dimen.identity_padding_top), 0, 0);
            this.mIdentity.setVisibility(8);
        }
    }

    public void onButtonClick(DoorHanger doorHanger, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("allowMixedContent", string2.equals("disable"));
            GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Session:Reload", jSONObject.toString());
            GeckoAppShell.sendEventToGecko(geckoEvent);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Exception creating message to enable/disable mixed content blocking", (Throwable)jSONException);
        }
        this.dismiss();
    }

    private void addMixedContentNotification(boolean bl) {
        this.removeMixedContentNotification();
        this.mMixedContentNotification = new DoorHanger((Context)this.mActivity, DoorHanger.Theme.DARK);
        String string2 = bl ? this.mActivity.getString(R.string.blocked_mixed_content_message_top) + "\n\n" + this.mActivity.getString(R.string.blocked_mixed_content_message_bottom) : this.mActivity.getString(R.string.loaded_mixed_content_message);
        this.mMixedContentNotification.setMessage(string2);
        this.mMixedContentNotification.addLink(this.mActivity.getString(R.string.learn_more), MIXED_CONTENT_SUPPORT_URL, "\n\n");
        if (bl) {
            this.mMixedContentNotification.setIcon(R.drawable.shield_doorhanger);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.disable_protection), "disable", this);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.keep_blocking), "keepBlocking", this);
        } else {
            this.mMixedContentNotification.setIcon(R.drawable.warning_doorhanger);
            this.mMixedContentNotification.addButton(this.mActivity.getString(R.string.enable_protection), "enable", this);
        }
        this.mContent.addView((View)this.mMixedContentNotification);
    }

    private void removeMixedContentNotification() {
        if (this.mMixedContentNotification != null) {
            this.mContent.removeView((View)this.mMixedContentNotification);
            this.mMixedContentNotification = null;
        }
    }

    public void updateIdentity(JSONObject jSONObject) {
        String string2;
        try {
            string2 = jSONObject.getString("mode");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Exception trying to get identity mode", (Throwable)jSONException);
            return;
        }
        if (UNKNOWN.equals(string2)) {
            Log.e((String)LOGTAG, (String)"Can't show site identity popup in non-identified state");
            return;
        }
        if (!this.mInflated) {
            this.init();
        }
        this.setIdentity(jSONObject);
        if (MIXED_CONTENT_BLOCKED.equals(string2) || MIXED_CONTENT_LOADED.equals(string2)) {
            this.addMixedContentNotification(MIXED_CONTENT_BLOCKED.equals(string2));
        }
    }

    public void dismiss() {
        super.dismiss();
        this.removeMixedContentNotification();
    }
}

