/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SysInfo {
    private static final String LOG_TAG = "GeckoSysInfo";
    private static volatile int cpuCount = -1;
    private static volatile int totalRAM = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUCount() {
        if (cpuCount > 0) {
            return cpuCount;
        }
        if (Build.VERSION.SDK_INT < 9) {
            return SysInfo.readCPUCount();
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            int n = SysInfo.readCPUCount();
            return n;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static int readCPUCount() {
        try {
            File file = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            cpuCount = file.listFiles(new CpuFilter()).length;
            return cpuCount;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Assuming 1 CPU; got exception.", (Throwable)exception);
            cpuCount = 1;
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMemSize() {
        if (totalRAM >= 0) {
            return totalRAM;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
            try {
                String string2;
                int n = 0;
                String string3 = null;
                while (n++ < 3 && (string3 = randomAccessFile.readLine()) != null && !string3.startsWith("MemTotal: ")) {
                    string3 = null;
                }
                if (string3 == null) {
                    totalRAM = 0;
                    int n2 = 0;
                    return n2;
                }
                Matcher matcher = Pattern.compile("^MemTotal:\\s+([0-9]+) kB\\s*$").matcher(string3);
                if (matcher.matches() && (string2 = matcher.group(1)) != null) {
                    int n3 = totalRAM = Integer.parseInt(string2) / 1024;
                    return n3;
                }
                Log.w((String)LOG_TAG, (String)("Got unexpected MemTotal line: " + string3));
                totalRAM = 0;
                int n4 = 0;
                return n4;
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            totalRAM = 0;
            return 0;
        }
        catch (IOException iOException) {
            totalRAM = 0;
            return 0;
        }
    }

    public static int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getReleaseVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getKernelVersion() {
        return System.getProperty("os.version", "");
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getName() {
        return "Android";
    }

    public static String getArch() {
        return "arm";
    }

    public static String getArchABI() {
        return Build.CPU_ABI;
    }

    public static String getLocale() {
        return Locale.getDefault().toString().replace('_', '-');
    }
}

