/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.LightweightThemeDrawable;
import org.mozilla.gecko.R;
import org.mozilla.gecko.RemoteTabs;
import org.mozilla.gecko.TabsTray;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.widget.IconTabWidget;

public class TabsPanel
extends LinearLayout
implements LightweightTheme.OnChangeListener,
IconTabWidget.OnTabChangedListener {
    private static final String LOGTAG = "GeckoTabsPanel";
    private Context mContext;
    private GeckoApp mActivity;
    private RelativeLayout mHeader;
    private TabsListContainer mTabsContainer;
    private PanelView mPanel;
    private PanelView mPanelNormal;
    private PanelView mPanelPrivate;
    private PanelView mPanelRemote;
    private RelativeLayout mFooter;
    private TabsLayoutChangeListener mLayoutChangeListener;
    private IconTabWidget mTabWidget;
    private static ImageButton mAddTab;
    private Panel mCurrentPanel;
    private boolean mIsSideBar;
    private boolean mVisible;

    public TabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mActivity = (GeckoApp)context;
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.setOrientation(1);
        this.mCurrentPanel = Panel.NORMAL_TABS;
        this.mVisible = false;
        this.mIsSideBar = false;
        LayoutInflater.from((Context)context).inflate(R.layout.tabs_panel, (ViewGroup)this);
        this.initialize();
    }

    private void initialize() {
        this.mHeader = (RelativeLayout)this.findViewById(R.id.tabs_panel_header);
        this.mTabsContainer = (TabsListContainer)this.findViewById(R.id.tabs_container);
        this.mPanelNormal = (TabsTray)this.findViewById(R.id.normal_tabs);
        this.mPanelNormal.setTabsPanel(this);
        this.mPanelPrivate = (TabsTray)this.findViewById(R.id.private_tabs);
        this.mPanelPrivate.setTabsPanel(this);
        this.mPanelRemote = (RemoteTabs)this.findViewById(R.id.synced_tabs);
        this.mPanelRemote.setTabsPanel(this);
        this.mFooter = (RelativeLayout)this.findViewById(R.id.tabs_panel_footer);
        mAddTab = (ImageButton)this.findViewById(R.id.add_tab);
        mAddTab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TabsPanel.this.addTab();
            }
        });
        this.mTabWidget = (IconTabWidget)this.findViewById(R.id.tab_widget);
        this.mTabWidget.addTab(R.drawable.tabs_normal, R.string.tabs_normal);
        this.mTabWidget.addTab(R.drawable.tabs_private, R.string.tabs_private);
        if (!GeckoProfile.get(this.mContext).inGuestMode()) {
            this.mTabWidget.addTab(R.drawable.tabs_synced, R.string.tabs_synced);
        }
        this.mTabWidget.setTabSelectionListener(this);
    }

    public void addTab() {
        if (this.mCurrentPanel == Panel.NORMAL_TABS) {
            this.mActivity.addTab();
        } else {
            this.mActivity.addPrivateTab();
        }
        this.mActivity.autoHideTabs();
    }

    public void onTabChanged(int n) {
        if (n == 0) {
            this.show(Panel.NORMAL_TABS, false);
        } else if (n == 1) {
            this.show(Panel.PRIVATE_TABS, false);
        } else {
            this.show(Panel.REMOTE_TABS, false);
        }
    }

    private static int getTabContainerHeight(TabsListContainer tabsListContainer) {
        Resources resources = tabsListContainer.getContext().getResources();
        PanelView panelView = tabsListContainer.getCurrentPanelView();
        if (panelView != null && !panelView.shouldExpand()) {
            return resources.getDimensionPixelSize(R.dimen.tabs_tray_horizontal_height);
        }
        int n = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
        int n2 = resources.getDisplayMetrics().heightPixels;
        Rect rect = new Rect();
        tabsListContainer.getWindowVisibleDisplayFrame(rect);
        int n3 = rect.bottom - rect.top;
        return (int)Math.max((float)n2 * 0.5f, Math.min((float)n3 - 2.5f * (float)n, (float)n3 * 0.8f) - (float)n);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mActivity.getLightweightTheme().addListener(this);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mActivity.getLightweightTheme().removeListener(this);
    }

    public void onLightweightThemeChanged() {
        int n = this.mActivity.getResources().getColor(R.color.background_tabs);
        LightweightThemeDrawable lightweightThemeDrawable = this.mActivity.getLightweightTheme().getColorDrawable((View)this, n, true);
        if (lightweightThemeDrawable == null) {
            return;
        }
        lightweightThemeDrawable.setAlpha(34, 0);
        this.setBackgroundDrawable(lightweightThemeDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public void show(Panel panel) {
        this.show(panel, true);
    }

    public void show(Panel panel, boolean bl) {
        if (!this.isShown()) {
            this.setVisibility(0);
        }
        if (this.mPanel != null) {
            this.mPanel.hide();
        }
        boolean bl2 = !this.mVisible;
        this.mVisible = true;
        this.mCurrentPanel = panel;
        int n = panel.ordinal();
        this.mTabWidget.setCurrentTab(n);
        this.mPanel = n == 0 ? this.mPanelNormal : (n == 1 ? this.mPanelPrivate : this.mPanelRemote);
        this.mPanel.show();
        if (this.mCurrentPanel == Panel.REMOTE_TABS) {
            if (this.mFooter != null) {
                this.mFooter.setVisibility(8);
            }
            mAddTab.setVisibility(4);
        } else {
            if (this.mFooter != null) {
                this.mFooter.setVisibility(0);
            }
            mAddTab.setVisibility(0);
            mAddTab.setImageLevel(n);
        }
        if (bl) {
            if (this.isSideBar()) {
                if (bl2) {
                    this.dispatchLayoutChange(this.getWidth(), this.getHeight());
                }
            } else {
                int n2 = this.mContext.getResources().getDimensionPixelSize(R.dimen.browser_toolbar_height);
                int n3 = n2 + TabsPanel.getTabContainerHeight(this.mTabsContainer);
                this.dispatchLayoutChange(this.getWidth(), n3);
            }
        }
    }

    public void hide() {
        if (this.mVisible) {
            this.mVisible = false;
            this.dispatchLayoutChange(0, 0);
        }
    }

    public void refresh() {
        this.removeAllViews();
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.tabs_panel, (ViewGroup)this);
        this.initialize();
        if (this.mVisible) {
            this.show(this.mCurrentPanel);
        }
    }

    public void autoHidePanel() {
        this.mActivity.autoHideTabs();
    }

    public boolean isShown() {
        return this.mVisible;
    }

    public boolean isSideBar() {
        return this.mIsSideBar;
    }

    public void setIsSideBar(boolean bl) {
        this.mIsSideBar = bl;
    }

    public Panel getCurrentPanel() {
        return this.mCurrentPanel;
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        Resources resources = this.getContext().getResources();
        int n = resources.getDimensionPixelSize(R.dimen.browser_toolbar_height);
        int n2 = this.getWidth();
        if (this.mVisible) {
            if (this.mIsSideBar) {
                ViewHelper.setTranslationX((View)this.mHeader, -n2);
            } else {
                ViewHelper.setTranslationY((View)this.mHeader, -n);
            }
            if (this.mIsSideBar) {
                ViewHelper.setTranslationX((View)this.mTabsContainer, -n2);
            } else {
                ViewHelper.setTranslationY((View)this.mTabsContainer, -n);
                ViewHelper.setAlpha((View)this.mTabsContainer, 0.0f);
            }
            if (this.mIsSideBar) {
                ViewHelper.setTranslationX((View)this.mFooter, -n2);
            }
        }
        if (this.mIsSideBar) {
            int n3 = this.mVisible ? 0 : -n2;
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_X, n3);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_X, n3);
            propertyAnimator.attach((View)this.mFooter, PropertyAnimator.Property.TRANSLATION_X, n3);
        } else {
            int n4 = this.mVisible ? 0 : -n;
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.ALPHA, this.mVisible ? 1.0f : 0.0f);
            propertyAnimator.attach((View)this.mTabsContainer, PropertyAnimator.Property.TRANSLATION_Y, n4);
            propertyAnimator.attach((View)this.mHeader, PropertyAnimator.Property.TRANSLATION_Y, n4);
        }
        this.mHeader.setLayerType(2, null);
        this.mTabsContainer.setLayerType(2, null);
    }

    public void finishTabsAnimation() {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        this.mHeader.setLayerType(0, null);
        this.mTabsContainer.setLayerType(0, null);
    }

    public void setTabsLayoutChangeListener(TabsLayoutChangeListener tabsLayoutChangeListener) {
        this.mLayoutChangeListener = tabsLayoutChangeListener;
    }

    private void dispatchLayoutChange(int n, int n2) {
        if (this.mLayoutChangeListener != null) {
            this.mLayoutChangeListener.onTabsLayoutChange(n, n2);
        }
    }

    public static class TabsPanelToolbar
    extends LinearLayout
    implements LightweightTheme.OnChangeListener {
        private BrowserApp mActivity;

        public TabsPanelToolbar(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mActivity = (BrowserApp)context;
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, (int)context.getResources().getDimension(R.dimen.browser_toolbar_height)));
            this.setOrientation(0);
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mActivity.getLightweightTheme().addListener(this);
        }

        public void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            this.mActivity.getLightweightTheme().removeListener(this);
        }

        public void onLightweightThemeChanged() {
            int n = this.mActivity.getResources().getColor(R.color.background_tabs);
            LightweightThemeDrawable lightweightThemeDrawable = this.mActivity.getLightweightTheme().getColorDrawable((View)this, n);
            if (lightweightThemeDrawable == null) {
                return;
            }
            lightweightThemeDrawable.setAlpha(34, 34);
            this.setBackgroundDrawable(lightweightThemeDrawable);
        }

        public void onLightweightThemeReset() {
            this.setBackgroundColor(this.getContext().getResources().getColor(R.color.background_tabs));
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            super.onLayout(bl, n, n2, n3, n4);
            this.onLightweightThemeChanged();
        }
    }

    public static class TabsListContainer
    extends FrameLayout {
        private Context mContext;

        public TabsListContainer(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.mContext = context;
        }

        public PanelView getCurrentPanelView() {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (!(view instanceof PanelView) || view.getVisibility() != 0) continue;
                return (PanelView)view;
            }
            return null;
        }

        protected void onMeasure(int n, int n2) {
            if (!GeckoAppShell.getGeckoInterface().hasTabsSideBar()) {
                int n3 = View.MeasureSpec.makeMeasureSpec((int)TabsPanel.getTabContainerHeight(this), (int)0x40000000);
                super.onMeasure(n, n3);
            } else {
                super.onMeasure(n, n2);
            }
        }
    }

    public static interface TabsLayoutChangeListener {
        public void onTabsLayoutChange(int var1, int var2);
    }

    public static interface PanelView {
        public ViewGroup getLayout();

        public void setTabsPanel(TabsPanel var1);

        public void show();

        public void hide();

        public boolean shouldExpand();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Panel {
        NORMAL_TABS,
        PRIVATE_TABS,
        REMOTE_TABS;

    }
}

