/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.SystemClock;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;

public class Telemetry {
    private static final String LOGTAG = "Telemetry";

    public static void HistogramAdd(String string2, int n) {
        GeckoEvent geckoEvent = GeckoEvent.createTelemetryHistogramAddEvent(string2, n);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    public static class Timer {
        private long mStartTime;
        private String mName;
        private boolean mHasFinished;
        private volatile long mElapsed = -1L;

        public Timer(String string2) {
            this.mName = string2;
            this.mStartTime = SystemClock.uptimeMillis();
            this.mHasFinished = false;
        }

        public void cancel() {
            this.mHasFinished = true;
        }

        public long getElapsed() {
            return this.mElapsed;
        }

        public void stop() {
            long l;
            if (this.mHasFinished) {
                return;
            }
            this.mHasFinished = true;
            this.mElapsed = l = SystemClock.uptimeMillis() - this.mStartTime;
            if (l < Integer.MAX_VALUE) {
                Telemetry.HistogramAdd(this.mName, (int)l);
            } else {
                Log.e((String)Telemetry.LOGTAG, (String)("Duration of " + l + " ms is too long to add to histogram."));
            }
        }
    }
}

