/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.TextSelectionHandle;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

class TextSelection
extends Layer
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoTextSelection";
    private final TextSelectionHandle mStartHandle;
    private final TextSelectionHandle mMiddleHandle;
    private final TextSelectionHandle mEndHandle;
    private final EventDispatcher mEventDispatcher;
    private float mViewLeft;
    private float mViewTop;
    private float mViewZoom;

    TextSelection(TextSelectionHandle textSelectionHandle, TextSelectionHandle textSelectionHandle2, TextSelectionHandle textSelectionHandle3, EventDispatcher eventDispatcher, GeckoApp geckoApp) {
        this.mStartHandle = textSelectionHandle;
        this.mMiddleHandle = textSelectionHandle2;
        this.mEndHandle = textSelectionHandle3;
        this.mEventDispatcher = eventDispatcher;
        if (this.mStartHandle == null || this.mMiddleHandle == null || this.mEndHandle == null) {
            Log.e((String)LOGTAG, (String)"Failed to initialize text selection because at least one handle is null");
        } else {
            this.registerEventListener("TextSelection:ShowHandles");
            this.registerEventListener("TextSelection:HideHandles");
            this.registerEventListener("TextSelection:PositionHandles");
        }
    }

    void destroy() {
        this.unregisterEventListener("TextSelection:ShowHandles");
        this.unregisterEventListener("TextSelection:HideHandles");
        this.unregisterEventListener("TextSelection:PositionHandles");
    }

    private TextSelectionHandle getHandle(String string2) {
        if (string2.equals("START")) {
            return this.mStartHandle;
        }
        if (string2.equals("MIDDLE")) {
            return this.mMiddleHandle;
        }
        return this.mEndHandle;
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                try {
                    if (string2.equals("TextSelection:ShowHandles")) {
                        JSONArray jSONArray = jSONObject.getJSONArray("handles");
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            String string22 = jSONArray.getString(i);
                            TextSelection.this.getHandle(string22).setVisibility(0);
                        }
                        TextSelection.this.mViewLeft = 0.0f;
                        TextSelection.this.mViewTop = 0.0f;
                        TextSelection.this.mViewZoom = 0.0f;
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            layerView.addLayer(TextSelection.this);
                        }
                    } else if (string2.equals("TextSelection:HideHandles")) {
                        LayerView layerView = GeckoAppShell.getLayerView();
                        if (layerView != null) {
                            layerView.removeLayer(TextSelection.this);
                        }
                        TextSelection.this.mStartHandle.setVisibility(8);
                        TextSelection.this.mMiddleHandle.setVisibility(8);
                        TextSelection.this.mEndHandle.setVisibility(8);
                    } else if (string2.equals("TextSelection:PositionHandles")) {
                        boolean bl = jSONObject.getBoolean("rtl");
                        JSONArray jSONArray = jSONObject.getJSONArray("positions");
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                            int n = jSONObject2.getInt("left");
                            int n2 = jSONObject2.getInt("top");
                            TextSelectionHandle textSelectionHandle = TextSelection.this.getHandle(jSONObject2.getString("handle"));
                            textSelectionHandle.setVisibility(jSONObject2.getBoolean("hidden") ? 8 : 0);
                            textSelectionHandle.positionFromGecko(n, n2, bl);
                        }
                    }
                }
                catch (JSONException jSONException) {
                    Log.e((String)TextSelection.LOGTAG, (String)"JSON exception", (Throwable)jSONException);
                }
            }
        });
    }

    public void draw(Layer.RenderContext renderContext) {
        final float f = renderContext.viewport.left - renderContext.offset.x;
        final float f2 = renderContext.viewport.top - renderContext.offset.y;
        final float f3 = renderContext.zoomFactor;
        if (FloatUtils.fuzzyEquals((float)this.mViewLeft, (float)f) && FloatUtils.fuzzyEquals((float)this.mViewTop, (float)f2) && FloatUtils.fuzzyEquals((float)this.mViewZoom, (float)f3)) {
            return;
        }
        this.mViewLeft = f;
        this.mViewTop = f2;
        this.mViewZoom = f3;
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                TextSelection.this.mStartHandle.repositionWithViewport(f, f2, f3);
                TextSelection.this.mMiddleHandle.repositionWithViewport(f, f2, f3);
                TextSelection.this.mEndHandle.repositionWithViewport(f, f2, f3);
            }
        });
    }

    private void registerEventListener(String string2) {
        this.mEventDispatcher.registerEventListener(string2, (GeckoEventListener)this);
    }

    private void unregisterEventListener(String string2) {
        this.mEventDispatcher.unregisterEventListener(string2, (GeckoEventListener)this);
    }
}

