/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.graphics.Bitmap;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;
import org.mozilla.gecko.mozglue.GeneratableAndroidBridgeTarget;

public final class ThumbnailHelper {
    private static final String LOGTAG = "GeckoThumbnailHelper";
    public static final float THUMBNAIL_ASPECT_RATIO = 0.571f;
    private static ThumbnailHelper sInstance;
    private final LinkedList<Tab> mPendingThumbnails = new LinkedList();
    private AtomicInteger mPendingWidth = new AtomicInteger((int)GeckoAppShell.getContext().getResources().getDimension(R.dimen.tab_thumbnail_width));
    private int mWidth = -1;
    private int mHeight = -1;
    private ByteBuffer mBuffer;

    public static synchronized ThumbnailHelper getInstance() {
        if (sInstance == null) {
            sInstance = new ThumbnailHelper();
        }
        return sInstance;
    }

    private ThumbnailHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndProcessThumbnailFor(Tab tab) {
        if ("about:home".equals(tab.getURL())) {
            tab.updateThumbnail(null);
            return;
        }
        if (tab.getState() == 0) {
            byte[] byArray;
            String string2 = tab.getURL();
            if (string2 != null && (byArray = BrowserDB.getThumbnailForUrl(GeckoAppShell.getContext().getContentResolver(), string2)) != null) {
                this.setTabThumbnail(tab, null, byArray);
            }
            return;
        }
        LinkedList<Tab> linkedList = this.mPendingThumbnails;
        synchronized (linkedList) {
            if (this.mPendingThumbnails.lastIndexOf(tab) > 0) {
                return;
            }
            this.mPendingThumbnails.add(tab);
            if (this.mPendingThumbnails.size() > 1) {
                return;
            }
        }
        this.requestThumbnailFor(tab);
    }

    public void setThumbnailWidth(int n) {
        this.mPendingWidth.set(IntSize.nextPowerOfTwo(n));
    }

    private void updateThumbnailSize() {
        this.mWidth = this.mPendingWidth.get();
        this.mWidth &= 0xFFFFFFFE;
        this.mHeight = Math.round((float)this.mWidth * 0.571f);
        int n = GeckoAppShell.getScreenDepth() == 24 ? 4 : 2;
        int n2 = this.mWidth * this.mHeight * n;
        if (this.mBuffer == null || this.mBuffer.capacity() != n2) {
            if (this.mBuffer != null) {
                this.mBuffer = DirectBufferAllocator.free((ByteBuffer)this.mBuffer);
            }
            try {
                this.mBuffer = DirectBufferAllocator.allocate((int)n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)LOGTAG, (String)illegalArgumentException.toString());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w((String)LOGTAG, (String)("Unable to allocate thumbnail buffer of capacity " + n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestThumbnailFor(Tab tab) {
        this.updateThumbnailSize();
        if (this.mBuffer == null) {
            LinkedList<Tab> linkedList = this.mPendingThumbnails;
            synchronized (linkedList) {
                this.mPendingThumbnails.clear();
            }
            return;
        }
        GeckoEvent geckoEvent = GeckoEvent.createThumbnailEvent(tab.getId(), this.mWidth, this.mHeight, this.mBuffer);
        GeckoAppShell.sendEventToGecko(geckoEvent);
    }

    @GeneratableAndroidBridgeTarget(stubName="SendThumbnail")
    public static void notifyThumbnail(ByteBuffer byteBuffer, int n, boolean bl) {
        Tab tab = Tabs.getInstance().getTab(n);
        ThumbnailHelper thumbnailHelper = ThumbnailHelper.getInstance();
        if (bl && tab != null) {
            thumbnailHelper.handleThumbnailData(tab, byteBuffer);
        }
        thumbnailHelper.processNextThumbnail(tab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextThumbnail(Tab tab) {
        Tab tab2 = null;
        LinkedList<Tab> linkedList = this.mPendingThumbnails;
        synchronized (linkedList) {
            if (tab != null && tab != this.mPendingThumbnails.peek()) {
                Log.e((String)LOGTAG, (String)"handleThumbnailData called with unexpected tab's data!");
            } else {
                this.mPendingThumbnails.remove();
            }
            tab2 = this.mPendingThumbnails.peek();
        }
        if (tab2 != null) {
            this.requestThumbnailFor(tab2);
        }
    }

    private void handleThumbnailData(Tab tab, ByteBuffer byteBuffer) {
        if (byteBuffer != this.mBuffer) {
            Log.e((String)LOGTAG, (String)"handleThumbnailData called with an unexpected ByteBuffer!");
        }
        if (this.shouldUpdateThumbnail(tab)) {
            this.processThumbnailData(tab, byteBuffer);
        }
    }

    private void processThumbnailData(Tab tab, ByteBuffer byteBuffer) {
        Bitmap bitmap = tab.getThumbnailBitmap(this.mWidth, this.mHeight);
        byteBuffer.position(0);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        this.setTabThumbnail(tab, bitmap, null);
    }

    private void setTabThumbnail(Tab tab, Bitmap bitmap, byte[] byArray) {
        if (bitmap == null) {
            if (byArray == null) {
                Log.w((String)LOGTAG, (String)"setTabThumbnail: one of bitmap or compressed must be non-null!");
                return;
            }
            bitmap = BitmapUtils.decodeByteArray(byArray);
        }
        tab.updateThumbnail(bitmap);
    }

    private boolean shouldUpdateThumbnail(Tab tab) {
        return Tabs.getInstance().isSelectedTab(tab) || GeckoAppShell.getGeckoInterface() != null && GeckoAppShell.getGeckoInterface().areTabsShown();
    }
}

