/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.announcements;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.IBinder;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import org.mozilla.gecko.background.BackgroundService;
import org.mozilla.gecko.background.announcements.Announcement;
import org.mozilla.gecko.background.announcements.AnnouncementPresenter;
import org.mozilla.gecko.background.announcements.AnnouncementsConstants;
import org.mozilla.gecko.background.announcements.AnnouncementsFetchDelegate;
import org.mozilla.gecko.background.announcements.AnnouncementsFetcher;
import org.mozilla.gecko.background.common.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsService
extends BackgroundService
implements AnnouncementsFetchDelegate {
    private static final String WORKER_THREAD_NAME = "AnnouncementsServiceWorker";
    private static final String LOG_TAG = "AnnounceService";

    public AnnouncementsService() {
        super(WORKER_THREAD_NAME);
        Logger.setThreadLogTag("GeckoAnnounce");
        Logger.debug(LOG_TAG, "Creating AnnouncementsService.");
    }

    public boolean shouldFetchAnnouncements() {
        long l = System.currentTimeMillis();
        if (!this.backgroundDataIsEnabled()) {
            Logger.debug(LOG_TAG, "Background data not possible. Skipping.");
            return false;
        }
        if (this.getEarliestNextFetch() > l) {
            return false;
        }
        long l2 = this.getLastFetch();
        if (l - l2 < AnnouncementsConstants.MINIMUM_FETCH_INTERVAL_MSEC) {
            Logger.debug(LOG_TAG, "Returning: minimum fetch interval of " + AnnouncementsConstants.MINIMUM_FETCH_INTERVAL_MSEC + "ms not met.");
            return false;
        }
        return true;
    }

    protected void processAnnouncements(List<Announcement> list) {
        if (list == null) {
            Logger.warn(LOG_TAG, "No announcements to present.");
            return;
        }
        boolean bl = false;
        for (Announcement announcement : list) {
            if (bl) {
                Logger.warn(LOG_TAG, "Skipping announcement \"" + announcement.getTitle() + "\": one already shown.");
                continue;
            }
            if (!Announcement.isValidAnnouncement(announcement)) continue;
            bl = true;
            AnnouncementPresenter.displayAnnouncement((Context)this, announcement);
        }
    }

    public void onHandleIntent(Intent intent) {
        Logger.setThreadLogTag("GeckoAnnounce");
        Logger.debug(LOG_TAG, "Running AnnouncementsService.");
        if (AnnouncementsConstants.DISABLED) {
            Logger.debug(LOG_TAG, "Announcements disabled. Returning from AnnouncementsService.");
            return;
        }
        if (!this.shouldFetchAnnouncements()) {
            Logger.debug(LOG_TAG, "Not fetching.");
            return;
        }
        AnnouncementsFetcher.fetchAndProcessAnnouncements(this.getLastLaunch(), this);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected long getLastLaunch() {
        return this.getSharedPreferences().getLong("last_firefox_launch", 0L);
    }

    protected SharedPreferences getSharedPreferences() {
        return this.getSharedPreferences("background", 0);
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(fileDescriptor, printWriter, stringArray);
        long l = this.getLastFetch();
        long l2 = this.getLastLaunch();
        printWriter.write("AnnouncementsService: last fetch " + l + ", last Firefox activity: " + l2 + "\n");
    }

    protected void setEarliestNextFetch(long l) {
        this.getSharedPreferences().edit().putLong("earliest_next_announce_fetch", l).commit();
    }

    protected long getEarliestNextFetch() {
        return this.getSharedPreferences().getLong("earliest_next_announce_fetch", 0L);
    }

    protected void setLastFetch(long l) {
        this.getSharedPreferences().edit().putLong("last_fetch", l).commit();
    }

    @Override
    public long getLastFetch() {
        return this.getSharedPreferences().getLong("last_fetch", 0L);
    }

    protected String setLastDate(String string2) {
        if (string2 == null) {
            this.getSharedPreferences().edit().remove("last_announce_date").commit();
            return null;
        }
        this.getSharedPreferences().edit().putString("last_announce_date", string2).commit();
        return string2;
    }

    @Override
    public String getLastDate() {
        return this.getSharedPreferences().getString("last_announce_date", null);
    }

    public void setAnnouncementsServerBaseURL(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        String string2 = uRI.getScheme();
        if (string2 == null) {
            throw new IllegalArgumentException("url must have a scheme.");
        }
        if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("url must be http or https.");
        }
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        sharedPreferences.edit().putString("announce_server_base_url", uRI.toASCIIString()).commit();
    }

    @Override
    public String getServiceURL() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        String string2 = sharedPreferences.getString("announce_server_base_url", AnnouncementsConstants.DEFAULT_ANNOUNCE_SERVER_BASE_URL);
        return string2 + AnnouncementsConstants.ANNOUNCE_PATH_SUFFIX;
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public String getUserAgent() {
        return AnnouncementsConstants.ANNOUNCE_USER_AGENT;
    }

    protected void persistTimes(long l, String string2) {
        this.setLastFetch(l);
        if (string2 != null) {
            this.setLastDate(string2);
        }
    }

    @Override
    public void onNoNewAnnouncements(long l, String string2) {
        Logger.info(LOG_TAG, "No new announcements to display.");
        this.persistTimes(l, string2);
    }

    @Override
    public void onNewAnnouncements(List<Announcement> list, long l, String string2) {
        Logger.info(LOG_TAG, "Processing announcements: " + list.size());
        this.persistTimes(l, string2);
        this.processAnnouncements(list);
    }

    @Override
    public void onRemoteFailure(int n) {
        Logger.warn(LOG_TAG, "Got remote fetch status " + n + "; bumping fetch time.");
        this.setLastFetch(System.currentTimeMillis());
    }

    @Override
    public void onRemoteError(Exception exception) {
        Logger.warn(LOG_TAG, "Error processing response.", exception);
        this.setLastFetch(System.currentTimeMillis());
    }

    @Override
    public void onLocalError(Exception exception) {
        Logger.error(LOG_TAG, "Got exception in fetch.", exception);
    }

    @Override
    public void onBackoff(int n) {
        Logger.info(LOG_TAG, "Got retry after: " + n);
        long l = Math.max((long)(n * 1000), AnnouncementsConstants.DEFAULT_BACKOFF_MSEC);
        long l2 = l + Math.round((double)l * 0.25 * Math.random());
        Logger.debug(LOG_TAG, "Fuzzed backoff: " + l2 + "ms.");
        this.setEarliestNextFetch(l2 + System.currentTimeMillis());
    }
}

