/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.bagheera;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.mozilla.gecko.background.bagheera.BagheeraRequestDelegate;
import org.mozilla.gecko.background.bagheera.DeflateHelper;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagheeraClient {
    protected final String serverURI;
    protected final Executor executor;
    protected static final Pattern URI_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    protected static String PROTOCOL_VERSION = "1.0";
    protected static String SUBMIT_PATH = "/submit/";

    public BagheeraClient(String string2, Executor executor) {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide a server URI.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must provide a non-null executor.");
        }
        this.serverURI = string2.endsWith("/") ? string2 : string2 + "/";
        this.executor = executor;
    }

    public BagheeraClient(String string2) {
        this(string2, Executors.newSingleThreadExecutor());
    }

    public void deleteDocument(String string2, String string3, BagheeraRequestDelegate bagheeraRequestDelegate) throws URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide namespace.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Must provide id.");
        }
        BaseResource baseResource = this.makeResource(string2, string3);
        baseResource.delegate = new BagheeraResourceDelegate(baseResource, string2, string3, bagheeraRequestDelegate);
        baseResource.delete();
    }

    public void uploadJSONDocument(String string2, String string3, String string4, Collection<String> collection, BagheeraRequestDelegate bagheeraRequestDelegate) throws URISyntaxException {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide namespace.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Must provide id.");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("Must provide payload.");
        }
        BaseResource baseResource = this.makeResource(string2, string3);
        HttpEntity httpEntity = DeflateHelper.deflateBody(string4);
        baseResource.delegate = new BagheeraUploadResourceDelegate(baseResource, string2, string3, collection, bagheeraRequestDelegate);
        baseResource.post(httpEntity);
    }

    public static boolean isValidURIComponent(String string2) {
        return URI_PATTERN.matcher(string2).matches();
    }

    protected BaseResource makeResource(String string2, String string3) throws URISyntaxException {
        if (!BagheeraClient.isValidURIComponent(string2)) {
            throw new URISyntaxException(string2, "Illegal namespace name. Must be alphanumeric + [_-].");
        }
        if (!BagheeraClient.isValidURIComponent(string3)) {
            throw new URISyntaxException(string3, "Illegal id value. Must be alphanumeric + [_-].");
        }
        String string4 = this.serverURI + PROTOCOL_VERSION + SUBMIT_PATH + string2 + "/" + string3;
        return new BaseResource(string4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class BagheeraUploadResourceDelegate
    extends BagheeraResourceDelegate {
        private static final String HEADER_OBSOLETE_DOCUMENT = "X-Obsolete-Document";
        private static final String COMPRESSED_CONTENT_TYPE = "application/json+zlib; charset=utf-8";
        protected final Collection<String> obsoleteDocumentIDs;

        public BagheeraUploadResourceDelegate(Resource resource, String string2, String string3, Collection<String> collection, BagheeraRequestDelegate bagheeraRequestDelegate) {
            super(resource, string2, string3, bagheeraRequestDelegate);
            this.obsoleteDocumentIDs = collection;
        }

        @Override
        public void addHeaders(HttpRequestBase httpRequestBase, DefaultHttpClient defaultHttpClient) {
            super.addHeaders(httpRequestBase, defaultHttpClient);
            httpRequestBase.setHeader("Content-Type", COMPRESSED_CONTENT_TYPE);
            if (this.obsoleteDocumentIDs != null && this.obsoleteDocumentIDs.size() > 0) {
                httpRequestBase.addHeader(HEADER_OBSOLETE_DOCUMENT, Utils.toCommaSeparatedString(this.obsoleteDocumentIDs));
            }
        }
    }

    public class BagheeraResourceDelegate
    extends BaseResourceDelegate {
        private static final int DEFAULT_SOCKET_TIMEOUT_MSEC = 300000;
        protected final BagheeraRequestDelegate delegate;
        protected final String namespace;
        protected final String id;

        public BagheeraResourceDelegate(Resource resource, String string2, String string3, BagheeraRequestDelegate bagheeraRequestDelegate) {
            super(resource);
            this.namespace = string2;
            this.id = string3;
            this.delegate = bagheeraRequestDelegate;
        }

        public int socketTimeout() {
            return 300000;
        }

        public void handleHttpResponse(HttpResponse httpResponse) {
            int n = httpResponse.getStatusLine().getStatusCode();
            switch (n) {
                case 200: 
                case 201: {
                    this.invokeHandleSuccess(n, httpResponse);
                    return;
                }
            }
            this.invokeHandleFailure(n, httpResponse);
        }

        protected void invokeHandleError(final Exception exception) {
            BagheeraClient.this.executor.execute(new Runnable(){

                public void run() {
                    BagheeraResourceDelegate.this.delegate.handleError(exception);
                }
            });
        }

        protected void invokeHandleFailure(final int n, final HttpResponse httpResponse) {
            BagheeraClient.this.executor.execute(new Runnable(){

                public void run() {
                    BagheeraResourceDelegate.this.delegate.handleFailure(n, BagheeraResourceDelegate.this.namespace, httpResponse);
                }
            });
        }

        protected void invokeHandleSuccess(final int n, final HttpResponse httpResponse) {
            BagheeraClient.this.executor.execute(new Runnable(){

                public void run() {
                    BagheeraResourceDelegate.this.delegate.handleSuccess(n, BagheeraResourceDelegate.this.namespace, BagheeraResourceDelegate.this.id, httpResponse);
                }
            });
        }

        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            this.invokeHandleError((Exception)((Object)clientProtocolException));
        }

        public void handleHttpIOException(IOException iOException) {
            this.invokeHandleError(iOException);
        }

        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            this.invokeHandleError(generalSecurityException);
        }
    }
}

