/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.upload;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.IOException;
import java.util.Collection;
import org.json.JSONObject;
import org.mozilla.gecko.background.bagheera.BagheeraClient;
import org.mozilla.gecko.background.bagheera.BagheeraRequestDelegate;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportGenerator;
import org.mozilla.gecko.background.healthreport.upload.SubmissionClient;
import org.mozilla.gecko.sync.net.BaseResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidSubmissionClient
implements SubmissionClient {
    protected static final String LOG_TAG = AndroidSubmissionClient.class.getSimpleName();
    protected final Context context;
    protected final SharedPreferences sharedPreferences;
    protected final String profilePath;

    public AndroidSubmissionClient(Context context, SharedPreferences sharedPreferences, String string2) {
        this.context = context;
        this.sharedPreferences = sharedPreferences;
        this.profilePath = string2;
    }

    public SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    public String getDocumentServerURI() {
        return this.getSharedPreferences().getString("healthreport_document_server_uri", "https://fhr.data.mozilla.com/");
    }

    public String getDocumentServerNamespace() {
        return this.getSharedPreferences().getString("healthreport_document_server_namespace", "metrics");
    }

    public long getLastUploadLocalTime() {
        return this.getSharedPreferences().getLong("healthreport_last_upload_local_time", 0L);
    }

    public String getLastUploadDocumentId() {
        return this.getSharedPreferences().getString("healthreport_last_upload_document_id", null);
    }

    public void setLastUploadLocalTimeAndDocumentId(long l, String string2) {
        this.getSharedPreferences().edit().putLong("healthreport_last_upload_local_time", l).putString("healthreport_last_upload_document_id", string2).commit();
    }

    protected void uploadPayload(String string2, String string3, Collection<String> collection, BagheeraRequestDelegate bagheeraRequestDelegate) {
        BagheeraClient bagheeraClient = new BagheeraClient(this.getDocumentServerURI());
        Logger.pii(LOG_TAG, "New health report has id " + string2 + "and obsoletes " + (collection != null ? Integer.toString(collection.size()) : "no") + " old ids.");
        try {
            bagheeraClient.uploadJSONDocument(this.getDocumentServerNamespace(), string2, string3, collection, bagheeraRequestDelegate);
        }
        catch (Exception exception) {
            bagheeraRequestDelegate.handleError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(long l, String string2, Collection<String> collection, SubmissionClient.Delegate delegate) {
        ContentProviderClient contentProviderClient = EnvironmentBuilder.getContentProviderClient(this.context);
        if (contentProviderClient == null) {
            delegate.onHardFailure(l, null, "Could not fetch content provider client.", null);
            return;
        }
        try {
            HealthReportDatabaseStorage healthReportDatabaseStorage = EnvironmentBuilder.getStorage(contentProviderClient, this.profilePath);
            if (healthReportDatabaseStorage == null) {
                delegate.onHardFailure(l, null, "No storage when generating report.", null);
                return;
            }
            long l2 = l - 15552000000L;
            long l3 = Math.max(this.getLastUploadLocalTime(), 1367500000000L);
            if (!healthReportDatabaseStorage.hasEventSince(l3)) {
                delegate.onHardFailure(l, null, "No new events in storage.", null);
                return;
            }
            HealthReportGenerator healthReportGenerator = new HealthReportGenerator(healthReportDatabaseStorage);
            JSONObject jSONObject = healthReportGenerator.generateDocument(l2, l3, this.profilePath);
            if (jSONObject == null) {
                delegate.onHardFailure(l, null, "Generator returned null document.", null);
                return;
            }
            RequestDelegate requestDelegate = new RequestDelegate(delegate, l, true, string2);
            this.uploadPayload(string2, jSONObject.toString(), collection, requestDelegate);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception generating document.", exception);
            delegate.onHardFailure(l, null, "Got exception uploading.", exception);
            return;
        }
        finally {
            contentProviderClient.release();
        }
    }

    @Override
    public void delete(long l, String string2, SubmissionClient.Delegate delegate) {
        BagheeraClient bagheeraClient = new BagheeraClient(this.getDocumentServerURI());
        Logger.pii(LOG_TAG, "Deleting health report with id " + string2 + ".");
        RequestDelegate requestDelegate = new RequestDelegate(delegate, l, false, string2);
        try {
            bagheeraClient.deleteDocument(this.getDocumentServerNamespace(), string2, requestDelegate);
        }
        catch (Exception exception) {
            requestDelegate.handleError(exception);
        }
    }

    protected class RequestDelegate
    implements BagheeraRequestDelegate {
        protected final SubmissionClient.Delegate delegate;
        protected final boolean isUpload;
        protected final String methodString;
        protected final long localTime;
        protected final String id;

        public RequestDelegate(SubmissionClient.Delegate delegate, long l, boolean bl, String string2) {
            this.delegate = delegate;
            this.localTime = l;
            this.isUpload = bl;
            this.methodString = this.isUpload ? "upload" : "delete";
            this.id = string2;
        }

        public void handleSuccess(int n, String string2, String string3, HttpResponse httpResponse) {
            BaseResource.consumeEntity(httpResponse);
            if (this.isUpload) {
                AndroidSubmissionClient.this.setLastUploadLocalTimeAndDocumentId(this.localTime, string3);
            }
            Logger.debug(LOG_TAG, "Successful " + this.methodString + " at " + this.localTime + ".");
            this.delegate.onSuccess(this.localTime, string3);
        }

        public void handleFailure(int n, String string2, HttpResponse httpResponse) {
            BaseResource.consumeEntity(httpResponse);
            Logger.debug(LOG_TAG, "Failed " + this.methodString + " at " + this.localTime + ".");
            if (n >= 500) {
                this.delegate.onSoftFailure(this.localTime, this.id, "Got status " + n + " from server.", null);
                return;
            }
            this.delegate.onHardFailure(this.localTime, this.id, "Got status " + n + " from server.", null);
        }

        public void handleError(Exception exception) {
            Logger.debug(LOG_TAG, "Exception during " + this.methodString + " at " + this.localTime + ".", exception);
            if (exception instanceof IOException) {
                this.delegate.onSoftFailure(this.localTime, this.id, "Got exception during " + this.methodString + ".", exception);
                return;
            }
            this.delegate.onHardFailure(this.localTime, this.id, "Got exception during " + this.methodString + ".", exception);
        }
    }
}

