/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.http.AndroidHttpClient;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFaviconTask
extends UiAsyncTask<Void, Void, Bitmap> {
    private static final String LOGTAG = "LoadFaviconTask";
    private static final HashMap<String, LoadFaviconTask> loadsInFlight = new HashMap();
    public static final int FLAG_PERSIST = 1;
    public static final int FLAG_SCALE = 2;
    private static final int MAX_REDIRECTS_TO_FOLLOW = 5;
    private static AtomicInteger mNextFaviconLoadId = new AtomicInteger(0);
    private int mId = mNextFaviconLoadId.incrementAndGet();
    private String mPageUrl;
    private String mFaviconUrl;
    private OnFaviconLoadedListener mListener;
    private int mFlags;
    private final boolean mOnlyFromLocal;
    protected int mTargetWidth;
    private LinkedList<LoadFaviconTask> mChainees;
    private boolean mIsChaining;
    static AndroidHttpClient sHttpClient = AndroidHttpClient.newInstance((String)GeckoAppShell.getGeckoInterface().getDefaultUAString());

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener) {
        this(handler, string2, string3, n, onFaviconLoadedListener, -1, false);
    }

    public LoadFaviconTask(Handler handler, String string2, String string3, int n, OnFaviconLoadedListener onFaviconLoadedListener, int n2, boolean bl) {
        super(handler);
        this.mPageUrl = string2;
        this.mFaviconUrl = string3;
        this.mListener = onFaviconLoadedListener;
        this.mFlags = n;
        this.mTargetWidth = n2;
        this.mOnlyFromLocal = bl;
    }

    private Bitmap loadFaviconFromDb() {
        ContentResolver contentResolver = Favicons.sContext.getContentResolver();
        return BrowserDB.getFaviconForFaviconUrl(contentResolver, this.mFaviconUrl);
    }

    private void saveFaviconToDb(Bitmap bitmap) {
        if ((this.mFlags & 1) == 0) {
            return;
        }
        ContentResolver contentResolver = Favicons.sContext.getContentResolver();
        BrowserDB.updateFaviconForUrl(contentResolver, this.mPageUrl, bitmap, this.mFaviconUrl);
    }

    private HttpResponse tryDownload(URI uRI) throws URISyntaxException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(uRI.toString());
        return this.tryDownloadRecurse(uRI, hashSet);
    }

    private HttpResponse tryDownloadRecurse(URI uRI, HashSet<String> hashSet) throws URISyntaxException, IOException {
        if (hashSet.size() == 5) {
            return null;
        }
        HttpGet httpGet = new HttpGet(uRI);
        HttpResponse httpResponse = sHttpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse == null) {
            return null;
        }
        if (httpResponse.getStatusLine() != null) {
            int n = httpResponse.getStatusLine().getStatusCode();
            if (n >= 300 && n < 400) {
                Header header = httpResponse.getFirstHeader("Location");
                if (header == null) {
                    return null;
                }
                String string2 = header.getValue();
                if (string2 == null || string2.equals(uRI.toString())) {
                    return null;
                }
                if (hashSet.contains(string2)) {
                    return null;
                }
                hashSet.add(string2);
                return this.tryDownloadRecurse(new URI(string2), hashSet);
            }
            if (n >= 400) {
                return null;
            }
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap downloadFavicon(URI uRI) {
        if (this.mFaviconUrl.startsWith("jar:jar:")) {
            return GeckoJarReader.getBitmap((Resources)Favicons.sContext.getResources(), (String)this.mFaviconUrl);
        }
        String string2 = uRI.getScheme();
        if (!"http".equals(string2) && !"https".equals(string2)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            HttpResponse httpResponse = this.tryDownload(uRI);
            if (httpResponse == null) {
                return null;
            }
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                return null;
            }
            BufferedHttpEntity bufferedHttpEntity = new BufferedHttpEntity(httpEntity);
            InputStream inputStream = null;
            try {
                inputStream = bufferedHttpEntity.getContent();
                bitmap = BitmapUtils.decodeStream(inputStream);
                inputStream.close();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error reading favicon", (Throwable)exception);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap doInBackground(Void ... voidArray) {
        if (this.isCancelled()) {
            return null;
        }
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)this.mFaviconUrl)) {
            String string2 = Favicons.getFaviconURLForPageURLFromCache(this.mPageUrl);
            if (string2 == null && (string2 = Favicons.getFaviconUrlForPageUrl(this.mPageUrl)) != null) {
                Favicons.putFaviconURLForPageURLInCache(this.mPageUrl, string2);
            }
            if (string2 != null) {
                this.mFaviconUrl = string2;
            } else {
                this.mFaviconUrl = Favicons.guessDefaultFaviconURL(this.mPageUrl);
                if (TextUtils.isEmpty((CharSequence)this.mFaviconUrl)) {
                    return null;
                }
                bl = true;
            }
        }
        if (Favicons.isFailedFavicon(this.mFaviconUrl)) {
            return null;
        }
        if (this.isCancelled()) {
            return null;
        }
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.mFaviconUrl);
            if (loadFaviconTask != null && !loadFaviconTask.isCancelled()) {
                loadFaviconTask.chainTasks(this);
                this.mIsChaining = true;
                return null;
            }
            loadsInFlight.put(this.mFaviconUrl, this);
        }
        if (this.isCancelled()) {
            return null;
        }
        Bitmap bitmap = this.loadFaviconFromDb();
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            return bitmap;
        }
        if (this.mOnlyFromLocal || this.isCancelled()) {
            return null;
        }
        try {
            bitmap = this.downloadFavicon(new URI(this.mFaviconUrl));
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.e((String)LOGTAG, (String)"The provided favicon URL is not valid");
            return null;
        }
        if (bitmap == null && !bl) {
            try {
                bitmap = this.downloadFavicon(new URI(Favicons.guessDefaultFaviconURL(this.mPageUrl)));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (bitmap != null && bitmap.getWidth() > 0 && bitmap.getHeight() > 0) {
            this.saveFaviconToDb(bitmap);
        } else {
            Favicons.putFaviconInFailedCache(this.mFaviconUrl);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Bitmap bitmap) {
        if (this.mIsChaining) {
            return;
        }
        Favicons.putFaviconInMemCache(this.mFaviconUrl, bitmap);
        this.processResult(bitmap);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            loadsInFlight.remove(this.mFaviconUrl);
        }
        if (this.mChainees != null) {
            for (LoadFaviconTask loadFaviconTask : this.mChainees) {
                loadFaviconTask.processResult(bitmap);
            }
        }
    }

    private void processResult(Bitmap bitmap) {
        Favicons.removeLoadTask(this.mId);
        Bitmap bitmap2 = bitmap;
        if (this.mTargetWidth != -1 && bitmap != null && bitmap.getWidth() != this.mTargetWidth) {
            bitmap2 = Favicons.getSizedFaviconFromCache(this.mFaviconUrl, this.mTargetWidth);
        }
        Favicons.dispatchResult(this.mPageUrl, this.mFaviconUrl, bitmap2, this.mListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCancelled() {
        Favicons.removeLoadTask(this.mId);
        HashMap<String, LoadFaviconTask> hashMap = loadsInFlight;
        synchronized (hashMap) {
            LoadFaviconTask loadFaviconTask = loadsInFlight.get(this.mFaviconUrl);
            if (loadFaviconTask == this) {
                loadsInFlight.remove(this.mFaviconUrl);
                return;
            }
            if (loadFaviconTask == null) {
                return;
            }
            if (loadFaviconTask.mChainees != null) {
                loadFaviconTask.mChainees.remove((Object)this);
            }
        }
    }

    private void chainTasks(LoadFaviconTask loadFaviconTask) {
        if (this.mChainees == null) {
            this.mChainees = new LinkedList();
        }
        this.mChainees.add(loadFaviconTask);
    }

    int getId() {
        return this.mId;
    }

    static void closeHTTPClient() {
        if (ThreadUtils.isOnBackgroundThread()) {
            if (sHttpClient != null) {
                sHttpClient.close();
            }
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                LoadFaviconTask.closeHTTPClient();
            }
        });
    }
}

