/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.RectF;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.util.FloatUtils;

public final class DisplayPortMetrics {
    public final float resolution;
    private final RectF mPosition;

    public DisplayPortMetrics() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public DisplayPortMetrics(float f, float f2, float f3, float f4, float f5) {
        this.resolution = f5;
        this.mPosition = new RectF(f, f2, f3, f4);
    }

    public float getLeft() {
        return this.mPosition.left;
    }

    public float getTop() {
        return this.mPosition.top;
    }

    public float getRight() {
        return this.mPosition.right;
    }

    public float getBottom() {
        return this.mPosition.bottom;
    }

    public boolean contains(RectF rectF) {
        return this.mPosition.contains(rectF);
    }

    public boolean fuzzyEquals(DisplayPortMetrics displayPortMetrics) {
        return RectUtils.fuzzyEquals(this.mPosition, displayPortMetrics.mPosition) && FloatUtils.fuzzyEquals((float)this.resolution, (float)displayPortMetrics.resolution);
    }

    public String toJSON() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("{ \"left\": ").append(this.mPosition.left).append(", \"top\": ").append(this.mPosition.top).append(", \"right\": ").append(this.mPosition.right).append(", \"bottom\": ").append(this.mPosition.bottom).append(", \"resolution\": ").append(this.resolution).append('}');
        return stringBuilder.toString();
    }

    public String toString() {
        return "DisplayPortMetrics v=(" + this.mPosition.left + "," + this.mPosition.top + "," + this.mPosition.right + "," + this.mPosition.bottom + ") z=" + this.resolution;
    }
}

