/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.gfx.GfxInfoThread;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.mozglue.GeneratableAndroidBridgeTarget;
import org.mozilla.gecko.util.ThreadUtils;

public class GLController {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final String LOGTAG = "GeckoGLController";
    private static GLController sInstance;
    private LayerView mView;
    private boolean mSurfaceValid;
    private int mWidth;
    private int mHeight;
    private volatile boolean mCompositorCreated;
    private EGL10 mEGL;
    private EGLDisplay mEGLDisplay;
    private EGLConfig mEGLConfig;
    private EGLSurface mEGLSurface;
    private static final int LOCAL_EGL_OPENGL_ES2_BIT = 4;
    private static final int[] CONFIG_SPEC_16BPP;
    private static final int[] CONFIG_SPEC_24BPP;

    private GLController() {
        GfxInfoThread.startThread();
    }

    static GLController getInstance(LayerView layerView) {
        if (sInstance == null) {
            sInstance = new GLController();
        }
        GLController.sInstance.mView = layerView;
        return sInstance;
    }

    synchronized void surfaceDestroyed() {
        ThreadUtils.assertOnUiThread();
        Log.w((String)LOGTAG, (String)("GLController::surfaceDestroyed() with mCompositorCreated=" + this.mCompositorCreated));
        this.mSurfaceValid = false;
        this.mEGLSurface = null;
        if (this.mCompositorCreated) {
            GeckoAppShell.sendEventToGeckoSync(GeckoEvent.createCompositorPauseEvent());
        }
        Log.w((String)LOGTAG, (String)"done GLController::surfaceDestroyed()");
    }

    synchronized void surfaceChanged(int n, int n2) {
        ThreadUtils.assertOnUiThread();
        Log.w((String)LOGTAG, (String)("GLController::surfaceChanged(" + n + ", " + n2 + ") with mSurfaceValid=" + this.mSurfaceValid));
        this.mWidth = n;
        this.mHeight = n2;
        if (this.mSurfaceValid) {
            this.resumeCompositor(this.mWidth, this.mHeight);
            Log.w((String)LOGTAG, (String)"done GLController::surfaceChanged with compositor resume");
            return;
        }
        this.mSurfaceValid = true;
        this.mView.post(new Runnable(){

            public void run() {
                Log.w((String)GLController.LOGTAG, (String)("GLController::surfaceChanged, creating compositor; mCompositorCreated=" + GLController.this.mCompositorCreated + ", mSurfaceValid=" + GLController.this.mSurfaceValid));
                if (!GLController.this.mCompositorCreated && !GfxInfoThread.hasData()) {
                    GLController.this.mView.postDelayed(this, 1L);
                    return;
                }
                try {
                    if (GLController.this.mSurfaceValid) {
                        if (GLController.this.mEGL == null) {
                            GLController.this.initEGL();
                        }
                        GLController.this.mEGLSurface = GLController.this.mEGL.eglCreateWindowSurface(GLController.this.mEGLDisplay, GLController.this.mEGLConfig, GLController.this.mView.getNativeWindow(), null);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)GLController.LOGTAG, (String)"Unable to create window surface", (Throwable)exception);
                }
                if (GLController.this.mEGLSurface == null || GLController.this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                    GLController.this.mSurfaceValid = false;
                    GLController.this.mEGLSurface = null;
                    Log.e((String)GLController.LOGTAG, (String)("EGL window surface could not be created: " + GLController.this.getEGLError()));
                    return;
                }
                GLController.this.createCompositor();
            }
        });
    }

    void createCompositor() {
        ThreadUtils.assertOnUiThread();
        Log.w((String)LOGTAG, (String)("GLController::createCompositor with mCompositorCreated=" + this.mCompositorCreated));
        if (this.mCompositorCreated) {
            this.resumeCompositor(this.mWidth, this.mHeight);
            Log.w((String)LOGTAG, (String)"done GLController::createCompositor with compositor resume");
            return;
        }
        if (this.mEGLSurface != null && GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.sendEventToGeckoSync(GeckoEvent.createCompositorCreateEvent(this.mWidth, this.mHeight));
        }
        Log.w((String)LOGTAG, (String)"done GLController::createCompositor");
    }

    void compositorCreated() {
        Log.w((String)LOGTAG, (String)"GLController::compositorCreated");
        this.mCompositorCreated = true;
    }

    public boolean hasValidSurface() {
        return this.mSurfaceValid;
    }

    private void initEGL() {
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new GLControllerException("eglGetDisplay() failed");
        }
        this.mEGLConfig = this.chooseConfig();
    }

    private EGLConfig chooseConfig() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2 = new int[1];
        switch (GeckoAppShell.getScreenDepth()) {
            case 24: {
                nArray = CONFIG_SPEC_24BPP;
                n3 = 8;
                n2 = 8;
                n = 8;
                break;
            }
            default: {
                nArray = CONFIG_SPEC_16BPP;
                n = 5;
                n2 = 6;
                n3 = 5;
            }
        }
        if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, nArray, null, 0, nArray2) || nArray2[0] <= 0) {
            throw new GLControllerException("No available EGL configurations " + this.getEGLError());
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[nArray2[0]];
        if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, nArray, eGLConfigArray, nArray2[0], nArray2)) {
            throw new GLControllerException("No EGL configuration for that specification " + this.getEGLError());
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        for (EGLConfig eGLConfig : eGLConfigArray) {
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12324, nArray3);
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12323, nArray4);
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12322, nArray5);
            if (nArray3[0] != n || nArray4[0] != n2 || nArray5[0] != n3) continue;
            return eGLConfig;
        }
        throw new GLControllerException("No suitable EGL configuration found");
    }

    @GeneratableAndroidBridgeTarget(allowMultithread=true, stubName="ProvideEGLSurfaceWrapper")
    private EGLSurface provideEGLSurface() {
        return this.mEGLSurface;
    }

    private String getEGLError() {
        return "Error " + (this.mEGL == null ? "(no mEGL)" : Integer.valueOf(this.mEGL.eglGetError()));
    }

    void resumeCompositor(int n, int n2) {
        Log.w((String)LOGTAG, (String)("GLController::resumeCompositor(" + n + ", " + n2 + ") and mCompositorCreated=" + this.mCompositorCreated));
        if (this.mCompositorCreated) {
            GeckoAppShell.scheduleResumeComposition(n, n2);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createCompositorResumeEvent());
        }
        Log.w((String)LOGTAG, (String)"done GLController::resumeCompositor");
    }

    static {
        CONFIG_SPEC_16BPP = new int[]{12324, 5, 12323, 6, 12322, 5, 12339, 4, 12352, 4, 12344};
        CONFIG_SPEC_24BPP = new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 4, 12352, 4, 12344};
    }

    public static class GLControllerException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        GLControllerException(String string2) {
            super(string2);
        }
    }
}

