/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.gfx.DisplayPortCalculator;
import org.mozilla.gecko.gfx.DisplayPortMetrics;
import org.mozilla.gecko.gfx.DrawTimingQueue;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerMarginsAnimator;
import org.mozilla.gecko.gfx.LayerRenderer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PanZoomTarget;
import org.mozilla.gecko.gfx.ProgressiveUpdateData;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.gfx.ViewTransform;
import org.mozilla.gecko.gfx.VirtualLayer;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.FloatUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoLayerClient
implements LayerView.Listener,
PanZoomTarget {
    private static final String LOGTAG = "GeckoLayerClient";
    private LayerRenderer mLayerRenderer;
    private boolean mLayerRendererInitialized;
    private Context mContext;
    private IntSize mScreenSize;
    private IntSize mWindowSize;
    private DisplayPortMetrics mDisplayPort;
    private boolean mRecordDrawTimes;
    private final DrawTimingQueue mDrawTimingQueue;
    private VirtualLayer mRootLayer;
    private ImmutableViewportMetrics mGeckoViewport;
    private ImmutableViewportMetrics mFrameMetrics;
    private DrawListener mDrawListener;
    private final ViewTransform mCurrentViewTransform;
    private final RectF mCurrentViewTransformMargins;
    private final ProgressiveUpdateData mProgressiveUpdateData;
    private DisplayPortMetrics mProgressiveUpdateDisplayPort;
    private boolean mLastProgressiveUpdateWasLowPrecision;
    private boolean mProgressiveUpdateWasInDanger;
    private boolean mForceRedraw;
    private volatile ImmutableViewportMetrics mViewportMetrics;
    private OnMetricsChangedListener mViewportChangeListener;
    private ZoomConstraints mZoomConstraints;
    private boolean mGeckoIsReady;
    private final PanZoomController mPanZoomController;
    private final LayerMarginsAnimator mMarginsAnimator;
    private LayerView mView;
    private volatile boolean mContentDocumentIsDisplayed;

    public GeckoLayerClient(Context context, LayerView layerView, EventDispatcher eventDispatcher) {
        this.mContext = context;
        this.mScreenSize = new IntSize(0, 0);
        this.mWindowSize = new IntSize(0, 0);
        this.mDisplayPort = new DisplayPortMetrics();
        this.mRecordDrawTimes = true;
        this.mDrawTimingQueue = new DrawTimingQueue();
        this.mCurrentViewTransform = new ViewTransform(0.0f, 0.0f, 1.0f);
        this.mCurrentViewTransformMargins = new RectF();
        this.mProgressiveUpdateData = new ProgressiveUpdateData();
        this.mProgressiveUpdateDisplayPort = new DisplayPortMetrics();
        this.mLastProgressiveUpdateWasLowPrecision = false;
        this.mProgressiveUpdateWasInDanger = false;
        this.mForceRedraw = true;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mFrameMetrics = this.mViewportMetrics = new ImmutableViewportMetrics(displayMetrics).setViewportSize(layerView.getWidth(), layerView.getHeight());
        this.mZoomConstraints = new ZoomConstraints(false);
        this.mPanZoomController = PanZoomController.Factory.create(this, (View)layerView, eventDispatcher);
        this.mMarginsAnimator = new LayerMarginsAnimator(this, layerView);
        this.mView = layerView;
        this.mView.setListener(this);
        this.mContentDocumentIsDisplayed = true;
    }

    public void setOverscrollHandler(Overscroll overscroll) {
        this.mPanZoomController.setOverscrollHandler(overscroll);
    }

    public void notifyGeckoReady() {
        this.mGeckoIsReady = true;
        this.mRootLayer = new VirtualLayer(new IntSize(this.mView.getWidth(), this.mView.getHeight()));
        this.mLayerRenderer = this.mView.getRenderer();
        this.sendResizeEventIfNecessary(true);
        DisplayPortCalculator.initPrefs();
        this.mView.post(new Runnable(){

            public void run() {
                GeckoLayerClient.this.mView.getGLController().createCompositor();
            }
        });
    }

    public void destroy() {
        this.mPanZoomController.destroy();
        this.mMarginsAnimator.destroy();
    }

    private boolean getRedrawHint() {
        if (this.mForceRedraw) {
            this.mForceRedraw = false;
            return true;
        }
        if (!this.mPanZoomController.getRedrawHint()) {
            return false;
        }
        return DisplayPortCalculator.aboutToCheckerboard(this.mViewportMetrics, this.mPanZoomController.getVelocityVector(), this.mDisplayPort);
    }

    Layer getRoot() {
        return this.mGeckoIsReady ? this.mRootLayer : null;
    }

    public LayerView getView() {
        return this.mView;
    }

    public FloatSize getViewportSize() {
        return this.mViewportMetrics.getSize();
    }

    void setViewportSize(int n, int n2) {
        this.mViewportMetrics = this.mViewportMetrics.setViewportSize(n, n2);
        if (this.mGeckoIsReady) {
            this.sendResizeEventIfNecessary(true);
            GeckoAppShell.viewSizeChanged();
        }
    }

    PanZoomController getPanZoomController() {
        return this.mPanZoomController;
    }

    LayerMarginsAnimator getLayerMarginsAnimator() {
        return this.mMarginsAnimator;
    }

    private void sendResizeEventIfNecessary(boolean bl) {
        boolean bl2;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        IntSize intSize = new IntSize(displayMetrics.widthPixels, displayMetrics.heightPixels);
        IntSize intSize2 = new IntSize(this.mView.getWidth(), this.mView.getHeight());
        boolean bl3 = !this.mScreenSize.equals(intSize);
        boolean bl4 = bl2 = !this.mWindowSize.equals(intSize2);
        if (!(bl || bl3 || bl2)) {
            return;
        }
        this.mScreenSize = intSize;
        this.mWindowSize = intSize2;
        if (bl3) {
            Log.d((String)LOGTAG, (String)("Screen-size changed to " + this.mScreenSize));
        }
        if (bl2) {
            Log.d((String)LOGTAG, (String)("Window-size changed to " + this.mWindowSize));
        }
        GeckoEvent geckoEvent = GeckoEvent.createSizeChangedEvent(this.mWindowSize.width, this.mWindowSize.height, this.mScreenSize.width, this.mScreenSize.height);
        GeckoAppShell.sendEventToGecko(geckoEvent);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Window:Resize", ""));
    }

    private void setPageRect(RectF rectF, RectF rectF2) {
        if (this.mViewportMetrics.getCssPageRect().equals((Object)rectF2)) {
            return;
        }
        this.mViewportMetrics = this.mViewportMetrics.setPageRect(rectF, rectF2);
        this.post(new Runnable(){

            public void run() {
                GeckoLayerClient.this.mPanZoomController.pageRectUpdated();
                GeckoLayerClient.this.mView.requestRender();
            }
        });
    }

    private void getFixedMargins(ImmutableViewportMetrics immutableViewportMetrics, RectF rectF) {
        rectF.left = 0.0f;
        rectF.top = 0.0f;
        rectF.right = 0.0f;
        rectF.bottom = 0.0f;
        float f = Math.max(0.0f, immutableViewportMetrics.getPageWidth() - immutableViewportMetrics.getWidthWithoutMargins());
        float f2 = Math.max(0.0f, immutableViewportMetrics.getPageHeight() - immutableViewportMetrics.getHeightWithoutMargins());
        PointF pointF = immutableViewportMetrics.getMarginOffset();
        RectF rectF2 = immutableViewportMetrics.getOverscroll();
        if (pointF.x >= 0.0f) {
            rectF.right = Math.max(0.0f, Math.min(pointF.x - rectF2.right, f));
        } else {
            rectF.left = Math.max(0.0f, Math.min(-pointF.x - rectF2.left, f));
        }
        if (pointF.y >= 0.0f) {
            rectF.bottom = Math.max(0.0f, Math.min(pointF.y - rectF2.bottom, f2));
        } else {
            rectF.top = Math.max(0.0f, Math.min(-pointF.y - rectF2.top, f2));
        }
        if (rectF2.left > 0.0f) {
            rectF.right = Math.min(f - rectF.left, rectF.right + rectF2.left);
        } else if (rectF2.right > 0.0f) {
            rectF.left = Math.min(f - rectF.right, rectF.left + rectF2.right);
        }
        if (rectF2.top > 0.0f) {
            rectF.bottom = Math.min(f2 - rectF.top, rectF.bottom + rectF2.top);
        } else if (rectF2.bottom > 0.0f) {
            rectF.top = Math.min(f2 - rectF.bottom, rectF.top + rectF2.bottom);
        }
    }

    private void adjustViewport(DisplayPortMetrics displayPortMetrics) {
        ImmutableViewportMetrics immutableViewportMetrics = this.getViewportMetrics();
        ImmutableViewportMetrics immutableViewportMetrics2 = immutableViewportMetrics.clamp();
        RectF rectF = new RectF();
        this.getFixedMargins(immutableViewportMetrics, rectF);
        immutableViewportMetrics2 = immutableViewportMetrics2.setMargins(rectF.left, rectF.top, rectF.right, rectF.bottom);
        if (displayPortMetrics == null) {
            displayPortMetrics = DisplayPortCalculator.calculate(immutableViewportMetrics, this.mPanZoomController.getVelocityVector());
        }
        this.mDisplayPort = displayPortMetrics;
        this.mGeckoViewport = immutableViewportMetrics2;
        if (this.mRecordDrawTimes) {
            this.mDrawTimingQueue.add(displayPortMetrics);
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createViewportEvent(immutableViewportMetrics2, displayPortMetrics));
    }

    private void abortPanZoomAnimation() {
        if (this.mPanZoomController != null) {
            this.post(new Runnable(){

                public void run() {
                    GeckoLayerClient.this.mPanZoomController.abortAnimation();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayPortMetrics handleViewportMessage(ImmutableViewportMetrics immutableViewportMetrics, ViewportMessageType viewportMessageType) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics2;
            ImmutableViewportMetrics immutableViewportMetrics3 = this.getViewportMetrics();
            switch (viewportMessageType) {
                default: {
                    immutableViewportMetrics2 = immutableViewportMetrics.setViewportSize(immutableViewportMetrics3.getWidth(), immutableViewportMetrics3.getHeight());
                    if (!immutableViewportMetrics3.fuzzyEquals(immutableViewportMetrics2)) {
                        this.abortPanZoomAnimation();
                    }
                    this.mPanZoomController.updateScrollOffset(immutableViewportMetrics.viewportRectLeft / immutableViewportMetrics.zoomFactor, immutableViewportMetrics.viewportRectTop / immutableViewportMetrics.zoomFactor);
                    break;
                }
                case PAGE_SIZE: {
                    float f = immutableViewportMetrics3.zoomFactor / immutableViewportMetrics.zoomFactor;
                    immutableViewportMetrics2 = immutableViewportMetrics3.setPageRect(RectUtils.scale(immutableViewportMetrics.getPageRect(), f), immutableViewportMetrics.getCssPageRect());
                }
            }
            final ImmutableViewportMetrics immutableViewportMetrics4 = immutableViewportMetrics2.clamp();
            this.post(new Runnable(){

                public void run() {
                    GeckoLayerClient.this.mGeckoViewport = immutableViewportMetrics4;
                }
            });
            this.setViewportMetrics(immutableViewportMetrics2, viewportMessageType == ViewportMessageType.UPDATE);
            this.mDisplayPort = DisplayPortCalculator.calculate(this.getViewportMetrics(), null);
        }
        return this.mDisplayPort;
    }

    DisplayPortMetrics getDisplayPort(boolean bl, boolean bl2, int n, ImmutableViewportMetrics immutableViewportMetrics) {
        Tabs tabs = Tabs.getInstance();
        if (bl2 && tabs.isSelectedTabId(n)) {
            return this.handleViewportMessage(immutableViewportMetrics, bl ? ViewportMessageType.PAGE_SIZE : ViewportMessageType.UPDATE);
        }
        return DisplayPortCalculator.calculate(immutableViewportMetrics, null);
    }

    void contentDocumentChanged() {
        this.mContentDocumentIsDisplayed = false;
    }

    boolean isContentDocumentDisplayed() {
        return this.mContentDocumentIsDisplayed;
    }

    public ProgressiveUpdateData progressiveUpdateCallback(boolean bl, float f, float f2, float f3, float f4, float f5, boolean bl2) {
        if (bl2 && !this.mLastProgressiveUpdateWasLowPrecision) {
            if (!this.mProgressiveUpdateWasInDanger) {
                this.mProgressiveUpdateData.abort = true;
                return this.mProgressiveUpdateData;
            }
            this.mProgressiveUpdateWasInDanger = false;
        }
        this.mLastProgressiveUpdateWasLowPrecision = bl2;
        DisplayPortMetrics displayPortMetrics = this.mDisplayPort;
        ImmutableViewportMetrics immutableViewportMetrics = this.mViewportMetrics;
        this.mProgressiveUpdateData.setViewport(immutableViewportMetrics);
        this.mProgressiveUpdateData.abort = false;
        if (!FloatUtils.fuzzyEquals((float)f5, (float)immutableViewportMetrics.zoomFactor)) {
            Log.d((String)LOGTAG, (String)"Aborting draw due to resolution change");
            this.mProgressiveUpdateData.abort = true;
            return this.mProgressiveUpdateData;
        }
        if (!(bl2 || FloatUtils.fuzzyEquals((float)f5, (float)this.mProgressiveUpdateDisplayPort.resolution) && FloatUtils.fuzzyEquals((float)f, (float)this.mProgressiveUpdateDisplayPort.getLeft()) && FloatUtils.fuzzyEquals((float)f2, (float)this.mProgressiveUpdateDisplayPort.getTop()) && FloatUtils.fuzzyEquals((float)(f + f3), (float)this.mProgressiveUpdateDisplayPort.getRight()) && FloatUtils.fuzzyEquals((float)(f2 + f4), (float)this.mProgressiveUpdateDisplayPort.getBottom()))) {
            this.mProgressiveUpdateDisplayPort = new DisplayPortMetrics(f, f2, f + f3, f2 + f4, f5);
        }
        if (!bl2 && !this.mProgressiveUpdateWasInDanger && DisplayPortCalculator.aboutToCheckerboard(immutableViewportMetrics, this.mPanZoomController.getVelocityVector(), this.mProgressiveUpdateDisplayPort)) {
            this.mProgressiveUpdateWasInDanger = true;
        }
        if (Math.abs(displayPortMetrics.getLeft() - this.mProgressiveUpdateDisplayPort.getLeft()) <= 2.0f && Math.abs(displayPortMetrics.getTop() - this.mProgressiveUpdateDisplayPort.getTop()) <= 2.0f && Math.abs(displayPortMetrics.getBottom() - this.mProgressiveUpdateDisplayPort.getBottom()) <= 2.0f && Math.abs(displayPortMetrics.getRight() - this.mProgressiveUpdateDisplayPort.getRight()) <= 2.0f) {
            return this.mProgressiveUpdateData;
        }
        if (Math.max(immutableViewportMetrics.viewportRectLeft, immutableViewportMetrics.pageRectLeft) + 1.0f < f || Math.max(immutableViewportMetrics.viewportRectTop, immutableViewportMetrics.pageRectTop) + 1.0f < f2 || Math.min(immutableViewportMetrics.viewportRectRight, immutableViewportMetrics.pageRectRight) - 1.0f > f + f3 || Math.min(immutableViewportMetrics.viewportRectBottom, immutableViewportMetrics.pageRectBottom) - 1.0f > f2 + f4) {
            Log.d((String)LOGTAG, (String)"Aborting update due to viewport not in display-port");
            this.mProgressiveUpdateData.abort = true;
            this.mProgressiveUpdateWasInDanger = true;
            return this.mProgressiveUpdateData;
        }
        if (bl2 && !bl) {
            this.mProgressiveUpdateData.abort = true;
        }
        return this.mProgressiveUpdateData;
    }

    void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mZoomConstraints = zoomConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsRTL(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics = this.getViewportMetrics().setIsRTL(bl);
            this.setViewportMetrics(immutableViewportMetrics, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstPaintViewport(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        Object object = this.getLock();
        synchronized (object) {
            ImmutableViewportMetrics immutableViewportMetrics = this.getViewportMetrics();
            Tab tab = Tabs.getInstance().getSelectedTab();
            RectF rectF = new RectF(f4, f5, f6, f7);
            RectF rectF2 = RectUtils.scaleAndRound(rectF, f3);
            final ImmutableViewportMetrics immutableViewportMetrics2 = immutableViewportMetrics.setViewportOrigin(f, f2).setZoomFactor(f3).setPageRect(rectF2, rectF).setIsRTL(tab.getIsRTL());
            this.post(new Runnable(){

                public void run() {
                    GeckoLayerClient.this.mGeckoViewport = immutableViewportMetrics2;
                }
            });
            this.setViewportMetrics(immutableViewportMetrics2);
            this.mView.setBackgroundColor(tab.getBackgroundColor());
            this.setZoomConstraints(tab.getZoomConstraints());
            this.abortPanZoomAnimation();
            if (this.mView.getPaintState() == 0) {
                this.mView.setPaintState(1);
            }
        }
        DisplayPortCalculator.resetPageState();
        this.mDrawTimingQueue.reset();
        this.mContentDocumentIsDisplayed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageRect(float f, float f2, float f3, float f4) {
        Object object = this.getLock();
        synchronized (object) {
            RectF rectF = new RectF(f, f2, f3, f4);
            float f5 = this.getViewportMetrics().zoomFactor;
            this.setPageRect(RectUtils.scale(rectF, f5), rectF);
        }
    }

    public ViewTransform syncViewportInfo(int n, int n2, int n3, int n4, float f, boolean bl) {
        DisplayPortMetrics displayPortMetrics;
        long l;
        this.mFrameMetrics = this.getViewportMetrics();
        this.mCurrentViewTransform.x = this.mFrameMetrics.viewportRectLeft;
        this.mCurrentViewTransform.y = this.mFrameMetrics.viewportRectTop;
        this.mCurrentViewTransform.scale = this.mFrameMetrics.zoomFactor;
        this.getFixedMargins(this.mFrameMetrics, this.mCurrentViewTransformMargins);
        this.mCurrentViewTransform.fixedLayerMarginLeft = this.mCurrentViewTransformMargins.left;
        this.mCurrentViewTransform.fixedLayerMarginTop = this.mCurrentViewTransformMargins.top;
        this.mCurrentViewTransform.fixedLayerMarginRight = this.mCurrentViewTransformMargins.right;
        this.mCurrentViewTransform.fixedLayerMarginBottom = this.mCurrentViewTransformMargins.bottom;
        PointF pointF = this.mFrameMetrics.getMarginOffset();
        this.mCurrentViewTransform.offsetX = pointF.x;
        this.mCurrentViewTransform.offsetY = pointF.y;
        this.mRootLayer.setPositionAndResolution(Math.round((float)n + this.mCurrentViewTransform.offsetX), Math.round((float)n2 + this.mCurrentViewTransform.offsetY), Math.round((float)(n + n3) + this.mCurrentViewTransform.offsetX), Math.round((float)(n2 + n4) + this.mCurrentViewTransform.offsetY), f);
        if (bl && this.mRecordDrawTimes && (l = this.mDrawTimingQueue.findTimeFor(displayPortMetrics = new DisplayPortMetrics(n, n2, n + n3, n2 + n4, f))) >= 0L) {
            long l2 = SystemClock.uptimeMillis();
            l = l2 - l;
            this.mRecordDrawTimes = DisplayPortCalculator.drawTimeUpdate(l, n3 * n4);
        }
        if (bl && this.mDrawListener != null) {
            this.mDrawListener.drawFinished();
        }
        return this.mCurrentViewTransform;
    }

    public ViewTransform syncFrameMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, boolean bl, int n, int n2, int n3, int n4, float f8, boolean bl2) {
        if (bl2) {
            this.setFirstPaintViewport(f, f2, f3, f4, f5, f6, f7);
        }
        return this.syncViewportInfo(n, n2, n3, n4, f8, bl);
    }

    public LayerRenderer.Frame createFrame() {
        if (!this.mLayerRendererInitialized) {
            this.mLayerRenderer.checkMonitoringEnabled();
            this.mLayerRenderer.createDefaultProgram();
            this.mLayerRendererInitialized = true;
        }
        return this.mLayerRenderer.createFrame(this.mFrameMetrics);
    }

    public void activateProgram() {
        this.mLayerRenderer.activateDefaultProgram();
    }

    public void deactivateProgram() {
        this.mLayerRenderer.deactivateDefaultProgram();
    }

    private void geometryChanged(DisplayPortMetrics displayPortMetrics) {
        this.sendResizeEventIfNecessary(false);
        if (this.getRedrawHint()) {
            this.adjustViewport(displayPortMetrics);
        }
    }

    public void renderRequested() {
        try {
            GeckoAppShell.scheduleComposite();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.d((String)LOGTAG, (String)"Dropping renderRequested call before libxul load.");
        }
    }

    public void sizeChanged(int n, int n2) {
        this.mView.getGLController().resumeCompositor(this.mWindowSize.width, this.mWindowSize.height);
    }

    public void surfaceChanged(int n, int n2) {
        this.setViewportSize(n, n2);
    }

    public ImmutableViewportMetrics getViewportMetrics() {
        return this.mViewportMetrics;
    }

    public ZoomConstraints getZoomConstraints() {
        return this.mZoomConstraints;
    }

    public boolean isFullScreen() {
        return this.mView.isFullScreen();
    }

    public RectF getMaxMargins() {
        return this.mMarginsAnimator.getMaxMargins();
    }

    public void setAnimationTarget(ImmutableViewportMetrics immutableViewportMetrics) {
        if (this.mGeckoIsReady) {
            DisplayPortMetrics displayPortMetrics = DisplayPortCalculator.calculate(immutableViewportMetrics, null);
            this.adjustViewport(displayPortMetrics);
        }
    }

    public void setViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics) {
        this.setViewportMetrics(immutableViewportMetrics, true);
    }

    private void setViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics, boolean bl) {
        immutableViewportMetrics = immutableViewportMetrics.setViewportSize(this.mViewportMetrics.getWidth(), this.mViewportMetrics.getHeight());
        this.mViewportMetrics = immutableViewportMetrics = immutableViewportMetrics.setMarginsFrom(this.mViewportMetrics);
        this.viewportMetricsChanged(bl);
    }

    private void viewportMetricsChanged(boolean bl) {
        if (this.mViewportChangeListener != null) {
            this.mViewportChangeListener.onMetricsChanged(this.mViewportMetrics);
        }
        this.mView.requestRender();
        if (bl && this.mGeckoIsReady) {
            this.geometryChanged(null);
        }
        this.setShadowVisibility();
    }

    void forceViewportMetrics(ImmutableViewportMetrics immutableViewportMetrics, boolean bl, boolean bl2) {
        if (bl2) {
            this.mForceRedraw = true;
        }
        this.mViewportMetrics = immutableViewportMetrics;
        this.viewportMetricsChanged(bl);
    }

    public void scrollBy(float f, float f2) {
        this.mViewportMetrics = this.mMarginsAnimator.scrollBy(this.mViewportMetrics, f, f2);
        this.viewportMetricsChanged(true);
    }

    public void onSubdocumentScrollBy(float f, float f2) {
        ImmutableViewportMetrics immutableViewportMetrics = this.mMarginsAnimator.scrollBy(this.mViewportMetrics, f, f2);
        this.mViewportMetrics = this.mViewportMetrics.setMarginsFrom(immutableViewportMetrics);
        this.viewportMetricsChanged(true);
    }

    public void panZoomStopped() {
        if (this.mViewportChangeListener != null) {
            this.mViewportChangeListener.onPanZoomStopped();
        }
    }

    private void setShadowVisibility() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                if (BrowserApp.mBrowserToolbar == null) {
                    return;
                }
                ImmutableViewportMetrics immutableViewportMetrics = GeckoLayerClient.this.mViewportMetrics;
                BrowserApp.mBrowserToolbar.setShadowVisibility(immutableViewportMetrics.viewportRectTop >= immutableViewportMetrics.pageRectTop);
            }
        });
    }

    public void forceRedraw(DisplayPortMetrics displayPortMetrics) {
        this.mForceRedraw = true;
        if (this.mGeckoIsReady) {
            this.geometryChanged(displayPortMetrics);
        }
    }

    public boolean post(Runnable runnable) {
        return this.mView.post(runnable);
    }

    public void postRenderTask(RenderTask renderTask) {
        this.mView.postRenderTask(renderTask);
    }

    public void removeRenderTask(RenderTask renderTask) {
        this.mView.removeRenderTask(renderTask);
    }

    public boolean postDelayed(Runnable runnable, long l) {
        return this.mView.postDelayed(runnable, l);
    }

    public Object getLock() {
        return this;
    }

    public PointF convertViewPointToLayerPoint(PointF pointF) {
        if (!this.mGeckoIsReady) {
            return null;
        }
        ImmutableViewportMetrics immutableViewportMetrics = this.mViewportMetrics;
        PointF pointF2 = immutableViewportMetrics.getOrigin();
        PointF pointF3 = immutableViewportMetrics.getMarginOffset();
        pointF2.offset(-pointF3.x, -pointF3.y);
        float f = immutableViewportMetrics.zoomFactor;
        ImmutableViewportMetrics immutableViewportMetrics2 = this.mGeckoViewport;
        PointF pointF4 = immutableViewportMetrics2.getOrigin();
        float f2 = immutableViewportMetrics2.zoomFactor;
        PointF pointF5 = new PointF((pointF.x + pointF2.x) / f - pointF4.x / f2, (pointF.y + pointF2.y) / f - pointF4.y / f2);
        return pointF5;
    }

    public void setOnMetricsChangedListener(OnMetricsChangedListener onMetricsChangedListener) {
        this.mViewportChangeListener = onMetricsChangedListener;
    }

    public void setDrawListener(DrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    public static interface DrawListener {
        public void drawFinished();
    }

    public static interface OnMetricsChangedListener {
        public void onMetricsChanged(ImmutableViewportMetrics var1);

        public void onPanZoomStopped();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ViewportMessageType {
        UPDATE,
        PAGE_SIZE;

    }
}

