/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.opengl.GLES20;
import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class GfxInfoThread
extends Thread {
    private static final String LOGTAG = "GfxInfoThread";
    private static GfxInfoThread sInstance;
    private String mData;

    private GfxInfoThread() {
    }

    public static void startThread() {
        if (sInstance == null) {
            sInstance = new GfxInfoThread();
            sInstance.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasData() {
        GfxInfoThread gfxInfoThread = sInstance;
        if (gfxInfoThread == null) {
            return true;
        }
        GfxInfoThread gfxInfoThread2 = gfxInfoThread;
        synchronized (gfxInfoThread2) {
            return gfxInfoThread.mData != null;
        }
    }

    public static String getData() {
        String string2 = sInstance.getDataImpl();
        sInstance = null;
        return string2;
    }

    private synchronized void error(String string2) {
        Log.e((String)LOGTAG, (String)string2);
        this.mData = "ERROR\n" + string2 + "\n";
        this.notifyAll();
    }

    private void eglError(EGL10 eGL10, String string2) {
        this.error(string2 + " (EGL error " + Integer.toHexString(eGL10.eglGetError()) + ")");
    }

    private synchronized String getDataImpl() {
        if (this.mData != null) {
            return this.mData;
        }
        Log.w((String)LOGTAG, (String)"We need the GfxInfo data, but it is not yet available. We have to wait for it, so expect abnormally long startup times. Please report a Mozilla bug.");
        try {
            while (this.mData == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)LOGTAG, (String)"Thread interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        Log.i((String)LOGTAG, (String)"GfxInfo data is finally available.");
        return this.mData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLDisplay eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay == EGL10.EGL_NO_DISPLAY) {
            this.eglError(eGL10, "eglGetDisplay failed");
            return;
        }
        int[] nArray = new int[2];
        if (!eGL10.eglInitialize(eGLDisplay, nArray)) {
            this.eglError(eGL10, "eglInitialize failed");
            return;
        }
        int[] nArray2 = new int[1];
        int n = 4;
        int[] nArray3 = new int[]{12352, n, 12344};
        String string2 = "Maybe this device does not support OpenGL ES2?";
        if (!eGL10.eglChooseConfig(eGLDisplay, nArray3, null, 0, nArray2)) {
            this.eglError(eGL10, "eglChooseConfig failed to query OpenGL ES2 configs. " + string2);
            return;
        }
        int n2 = nArray2[0];
        if (n2 == 0) {
            this.error("eglChooseConfig returned zero OpenGL ES2 configs. " + string2);
            return;
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[n2];
        if (!eGL10.eglChooseConfig(eGLDisplay, nArray3, eGLConfigArray, n2, nArray2)) {
            this.eglError(eGL10, "eglChooseConfig failed (listing OpenGL ES2 configs). " + string2);
            return;
        }
        EGLConfig eGLConfig = eGLConfigArray[0];
        int n3 = 12440;
        int[] nArray4 = new int[]{n3, 2, 12344};
        EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray4);
        if (eGLContext == EGL10.EGL_NO_CONTEXT) {
            this.eglError(eGL10, "eglCreateContext failed to create a OpenGL ES2 context" + string2);
            return;
        }
        int[] nArray5 = new int[]{12375, 16, 12374, 16, 12344};
        EGLSurface eGLSurface = eGL10.eglCreatePbufferSurface(eGLDisplay, eGLConfig, nArray5);
        if (eGLSurface == EGL10.EGL_NO_SURFACE) {
            this.eglError(eGL10, "eglCreatePbufferSurface failed");
            return;
        }
        if (!eGL10.eglMakeCurrent(eGLDisplay, eGLSurface, eGLSurface, eGLContext)) {
            this.eglError(eGL10, "eglMakeCurrent failed");
            return;
        }
        int n4 = eGL10.eglGetError();
        if (n4 != 12288) {
            this.error("EGL error " + Integer.toHexString(n4));
            return;
        }
        String string3 = "VENDOR\n" + GLES20.glGetString((int)7936) + "\n" + "RENDERER\n" + GLES20.glGetString((int)7937) + "\n" + "VERSION\n" + GLES20.glGetString((int)7938) + "\n";
        int n5 = GLES20.glGetError();
        if (n5 != 0) {
            this.error("OpenGL error " + Integer.toHexString(n5));
            return;
        }
        eGL10.eglMakeCurrent(eGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        GfxInfoThread gfxInfoThread = this;
        synchronized (gfxInfoThread) {
            this.mData = string3;
            this.notifyAll();
        }
    }
}

