/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import org.mozilla.gecko.gfx.FloatSize;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.gfx.RectUtils;
import org.mozilla.gecko.util.FloatUtils;

public class ImmutableViewportMetrics {
    public final float pageRectLeft;
    public final float pageRectTop;
    public final float pageRectRight;
    public final float pageRectBottom;
    public final float cssPageRectLeft;
    public final float cssPageRectTop;
    public final float cssPageRectRight;
    public final float cssPageRectBottom;
    public final float viewportRectLeft;
    public final float viewportRectTop;
    public final float viewportRectRight;
    public final float viewportRectBottom;
    public final float marginLeft;
    public final float marginTop;
    public final float marginRight;
    public final float marginBottom;
    public final float zoomFactor;
    public final boolean isRTL;

    public ImmutableViewportMetrics(DisplayMetrics displayMetrics) {
        this.cssPageRectLeft = 0.0f;
        this.pageRectLeft = 0.0f;
        this.viewportRectLeft = 0.0f;
        this.cssPageRectTop = 0.0f;
        this.pageRectTop = 0.0f;
        this.viewportRectTop = 0.0f;
        this.pageRectRight = this.cssPageRectRight = (float)displayMetrics.widthPixels;
        this.viewportRectRight = this.cssPageRectRight;
        this.pageRectBottom = this.cssPageRectBottom = (float)displayMetrics.heightPixels;
        this.viewportRectBottom = this.cssPageRectBottom;
        this.marginBottom = 0.0f;
        this.marginRight = 0.0f;
        this.marginTop = 0.0f;
        this.marginLeft = 0.0f;
        this.zoomFactor = 1.0f;
        this.isRTL = false;
    }

    private ImmutableViewportMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, f13, false);
    }

    private ImmutableViewportMetrics(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, boolean bl) {
        this.pageRectLeft = f;
        this.pageRectTop = f2;
        this.pageRectRight = f3;
        this.pageRectBottom = f4;
        this.cssPageRectLeft = f5;
        this.cssPageRectTop = f6;
        this.cssPageRectRight = f7;
        this.cssPageRectBottom = f8;
        this.viewportRectLeft = f9;
        this.viewportRectTop = f10;
        this.viewportRectRight = f11;
        this.viewportRectBottom = f12;
        this.marginLeft = f13;
        this.marginTop = f14;
        this.marginRight = f15;
        this.marginBottom = f16;
        this.zoomFactor = f17;
        this.isRTL = bl;
    }

    public float getWidth() {
        return this.viewportRectRight - this.viewportRectLeft;
    }

    public float getHeight() {
        return this.viewportRectBottom - this.viewportRectTop;
    }

    public float getWidthWithoutMargins() {
        return this.viewportRectRight - this.viewportRectLeft - this.marginLeft - this.marginRight;
    }

    public float getHeightWithoutMargins() {
        return this.viewportRectBottom - this.viewportRectTop - this.marginTop - this.marginBottom;
    }

    public PointF getOrigin() {
        return new PointF(this.viewportRectLeft, this.viewportRectTop);
    }

    public PointF getMarginOffset() {
        if (this.isRTL) {
            return new PointF(this.marginLeft - this.marginRight, this.marginTop);
        }
        return new PointF(this.marginLeft, this.marginTop);
    }

    public FloatSize getSize() {
        return new FloatSize(this.viewportRectRight - this.viewportRectLeft, this.viewportRectBottom - this.viewportRectTop);
    }

    public RectF getViewport() {
        return new RectF(this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight, this.viewportRectBottom);
    }

    public RectF getCssViewport() {
        return RectUtils.scale(this.getViewport(), 1.0f / this.zoomFactor);
    }

    public RectF getPageRect() {
        return new RectF(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom);
    }

    public float getPageWidth() {
        return this.pageRectRight - this.pageRectLeft;
    }

    public float getPageWidthWithMargins() {
        return this.pageRectRight - this.pageRectLeft + this.marginLeft + this.marginRight;
    }

    public float getPageHeight() {
        return this.pageRectBottom - this.pageRectTop;
    }

    public float getPageHeightWithMargins() {
        return this.pageRectBottom - this.pageRectTop + this.marginTop + this.marginBottom;
    }

    public RectF getCssPageRect() {
        return new RectF(this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom);
    }

    public RectF getOverscroll() {
        return new RectF(Math.max(0.0f, this.pageRectLeft - this.viewportRectLeft), Math.max(0.0f, this.pageRectTop - this.viewportRectTop), Math.max(0.0f, this.viewportRectRight - this.pageRectRight), Math.max(0.0f, this.viewportRectBottom - this.pageRectBottom));
    }

    public ImmutableViewportMetrics interpolate(ImmutableViewportMetrics immutableViewportMetrics, float f) {
        return new ImmutableViewportMetrics(FloatUtils.interpolate((float)this.pageRectLeft, (float)immutableViewportMetrics.pageRectLeft, (float)f), FloatUtils.interpolate((float)this.pageRectTop, (float)immutableViewportMetrics.pageRectTop, (float)f), FloatUtils.interpolate((float)this.pageRectRight, (float)immutableViewportMetrics.pageRectRight, (float)f), FloatUtils.interpolate((float)this.pageRectBottom, (float)immutableViewportMetrics.pageRectBottom, (float)f), FloatUtils.interpolate((float)this.cssPageRectLeft, (float)immutableViewportMetrics.cssPageRectLeft, (float)f), FloatUtils.interpolate((float)this.cssPageRectTop, (float)immutableViewportMetrics.cssPageRectTop, (float)f), FloatUtils.interpolate((float)this.cssPageRectRight, (float)immutableViewportMetrics.cssPageRectRight, (float)f), FloatUtils.interpolate((float)this.cssPageRectBottom, (float)immutableViewportMetrics.cssPageRectBottom, (float)f), FloatUtils.interpolate((float)this.viewportRectLeft, (float)immutableViewportMetrics.viewportRectLeft, (float)f), FloatUtils.interpolate((float)this.viewportRectTop, (float)immutableViewportMetrics.viewportRectTop, (float)f), FloatUtils.interpolate((float)this.viewportRectRight, (float)immutableViewportMetrics.viewportRectRight, (float)f), FloatUtils.interpolate((float)this.viewportRectBottom, (float)immutableViewportMetrics.viewportRectBottom, (float)f), FloatUtils.interpolate((float)this.marginLeft, (float)immutableViewportMetrics.marginLeft, (float)f), FloatUtils.interpolate((float)this.marginTop, (float)immutableViewportMetrics.marginTop, (float)f), FloatUtils.interpolate((float)this.marginRight, (float)immutableViewportMetrics.marginRight, (float)f), FloatUtils.interpolate((float)this.marginBottom, (float)immutableViewportMetrics.marginBottom, (float)f), FloatUtils.interpolate((float)this.zoomFactor, (float)immutableViewportMetrics.zoomFactor, (float)f), (double)f >= 0.5 ? immutableViewportMetrics.isRTL : this.isRTL);
    }

    public ImmutableViewportMetrics setViewportSize(float f, float f2) {
        if (FloatUtils.fuzzyEquals((float)f, (float)this.getWidth()) && FloatUtils.fuzzyEquals((float)f2, (float)this.getHeight())) {
            return this;
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectLeft + f, this.viewportRectTop + f2, this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setViewportOrigin(float f, float f2) {
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, f, f2, f + this.getWidth(), f2 + this.getHeight(), this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setZoomFactor(float f) {
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight, this.viewportRectBottom, this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, f, this.isRTL);
    }

    public ImmutableViewportMetrics offsetViewportBy(float f, float f2) {
        return this.setViewportOrigin(this.viewportRectLeft + f, this.viewportRectTop + f2);
    }

    public ImmutableViewportMetrics offsetViewportByAndClamp(float f, float f2) {
        if (this.isRTL) {
            return this.setViewportOrigin(Math.min(this.pageRectRight - this.getWidthWithoutMargins(), Math.max(this.viewportRectLeft + f, this.pageRectLeft)), Math.max(this.pageRectTop, Math.min(this.viewportRectTop + f2, this.pageRectBottom - this.getHeightWithoutMargins())));
        }
        return this.setViewportOrigin(Math.max(this.pageRectLeft, Math.min(this.viewportRectLeft + f, this.pageRectRight - this.getWidthWithoutMargins())), Math.max(this.pageRectTop, Math.min(this.viewportRectTop + f2, this.pageRectBottom - this.getHeightWithoutMargins())));
    }

    public ImmutableViewportMetrics setPageRect(RectF rectF, RectF rectF2) {
        return new ImmutableViewportMetrics(rectF.left, rectF.top, rectF.right, rectF.bottom, rectF2.left, rectF2.top, rectF2.right, rectF2.bottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight, this.viewportRectBottom, this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setMargins(float f, float f2, float f3, float f4) {
        if (FloatUtils.fuzzyEquals((float)f, (float)this.marginLeft) && FloatUtils.fuzzyEquals((float)f2, (float)this.marginTop) && FloatUtils.fuzzyEquals((float)f3, (float)this.marginRight) && FloatUtils.fuzzyEquals((float)f4, (float)this.marginBottom)) {
            return this;
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight, this.viewportRectBottom, f, f2, f3, f4, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics setMarginsFrom(ImmutableViewportMetrics immutableViewportMetrics) {
        return this.setMargins(immutableViewportMetrics.marginLeft, immutableViewportMetrics.marginTop, immutableViewportMetrics.marginRight, immutableViewportMetrics.marginBottom);
    }

    public ImmutableViewportMetrics setIsRTL(boolean bl) {
        if (this.isRTL == bl) {
            return this;
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, this.viewportRectLeft, this.viewportRectTop, this.viewportRectRight, this.viewportRectBottom, this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, this.zoomFactor, bl);
    }

    public ImmutableViewportMetrics scaleTo(float f, PointF pointF) {
        float f2 = this.cssPageRectLeft * f;
        float f3 = this.cssPageRectTop * f;
        float f4 = this.cssPageRectLeft + (this.cssPageRectRight - this.cssPageRectLeft) * f;
        float f5 = this.cssPageRectTop + (this.cssPageRectBottom - this.cssPageRectTop) * f;
        PointF pointF2 = this.getOrigin();
        pointF2.offset(pointF.x, pointF.y);
        pointF2 = PointUtils.scale(pointF2, f / this.zoomFactor);
        pointF2.offset(-pointF.x, -pointF.y);
        return new ImmutableViewportMetrics(f2, f3, f4, f5, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, pointF2.x, pointF2.y, pointF2.x + this.getWidth(), pointF2.y + this.getHeight(), this.marginLeft, this.marginTop, this.marginRight, this.marginBottom, f, this.isRTL);
    }

    private ImmutableViewportMetrics clamp(float f, float f2, float f3, float f4) {
        RectF rectF = this.getViewport();
        PointF pointF = this.getMarginOffset();
        if (rectF.right > this.pageRectRight + f + f3) {
            rectF.offset(this.pageRectRight + f + f3 - rectF.right, 0.0f);
        }
        if (rectF.left < this.pageRectLeft) {
            rectF.offset(this.pageRectLeft - rectF.left, 0.0f);
        }
        if (rectF.bottom > this.pageRectBottom + f2 + f4) {
            rectF.offset(0.0f, this.pageRectBottom + f2 + f4 - rectF.bottom);
        }
        if (rectF.top < this.pageRectTop) {
            rectF.offset(0.0f, this.pageRectTop - rectF.top);
        }
        return new ImmutableViewportMetrics(this.pageRectLeft, this.pageRectTop, this.pageRectRight, this.pageRectBottom, this.cssPageRectLeft, this.cssPageRectTop, this.cssPageRectRight, this.cssPageRectBottom, rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, f3, f4, this.zoomFactor, this.isRTL);
    }

    public ImmutableViewportMetrics clamp() {
        return this.clamp(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public ImmutableViewportMetrics clampWithMargins() {
        return this.clamp(this.marginLeft, this.marginTop, this.marginRight, this.marginBottom);
    }

    public boolean fuzzyEquals(ImmutableViewportMetrics immutableViewportMetrics) {
        return FloatUtils.fuzzyEquals((float)this.cssPageRectLeft, (float)immutableViewportMetrics.cssPageRectLeft) && FloatUtils.fuzzyEquals((float)this.cssPageRectTop, (float)immutableViewportMetrics.cssPageRectTop) && FloatUtils.fuzzyEquals((float)this.cssPageRectRight, (float)immutableViewportMetrics.cssPageRectRight) && FloatUtils.fuzzyEquals((float)this.cssPageRectBottom, (float)immutableViewportMetrics.cssPageRectBottom) && FloatUtils.fuzzyEquals((float)this.viewportRectLeft, (float)immutableViewportMetrics.viewportRectLeft) && FloatUtils.fuzzyEquals((float)this.viewportRectTop, (float)immutableViewportMetrics.viewportRectTop) && FloatUtils.fuzzyEquals((float)this.viewportRectRight, (float)immutableViewportMetrics.viewportRectRight) && FloatUtils.fuzzyEquals((float)this.viewportRectBottom, (float)immutableViewportMetrics.viewportRectBottom) && FloatUtils.fuzzyEquals((float)this.zoomFactor, (float)immutableViewportMetrics.zoomFactor);
    }

    public String toString() {
        return "ImmutableViewportMetrics v=(" + this.viewportRectLeft + "," + this.viewportRectTop + "," + this.viewportRectRight + "," + this.viewportRectBottom + ") p=(" + this.pageRectLeft + "," + this.pageRectTop + "," + this.pageRectRight + "," + this.pageRectBottom + ") c=(" + this.cssPageRectLeft + "," + this.cssPageRectTop + "," + this.cssPageRectRight + "," + this.cssPageRectBottom + ") m=(" + this.marginLeft + "," + this.marginTop + "," + this.marginRight + "," + this.marginBottom + ") z=" + this.zoomFactor + ", rtl=" + this.isRTL;
    }
}

