/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Canvas;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.view.View;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;

public class Overscroll {
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private final EdgeEffectCompat[] mEdges = new EdgeEffectCompat[4];
    private final View mView;

    public Overscroll(View view) {
        this.mView = view;
        Context context = view.getContext();
        for (int i = 0; i < 4; ++i) {
            this.mEdges[i] = new EdgeEffectCompat(context);
        }
    }

    public void setSize(int n, int n2) {
        this.mEdges[2].setSize(n2, n);
        this.mEdges[3].setSize(n2, n);
        this.mEdges[0].setSize(n, n2);
        this.mEdges[1].setSize(n, n2);
    }

    private EdgeEffectCompat getEdgeForAxisAndSide(Axis axis, float f) {
        if (axis == Axis.Y) {
            if (f < 0.0f) {
                return this.mEdges[0];
            }
            return this.mEdges[1];
        }
        if (f < 0.0f) {
            return this.mEdges[2];
        }
        return this.mEdges[3];
    }

    public void setVelocity(float f, Axis axis) {
        EdgeEffectCompat edgeEffectCompat = this.getEdgeForAxisAndSide(axis, f);
        if (!edgeEffectCompat.isFinished()) {
            edgeEffectCompat.onRelease();
        } else {
            edgeEffectCompat.onAbsorb((int)f);
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    public void setDistance(float f, Axis axis) {
        if (f == 0.0f) {
            return;
        }
        EdgeEffectCompat edgeEffectCompat = this.getEdgeForAxisAndSide(axis, (int)f);
        edgeEffectCompat.onPull(f / (float)(axis == Axis.X ? this.mView.getWidth() : this.mView.getHeight()));
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    public void draw(Canvas canvas, ImmutableViewportMetrics immutableViewportMetrics) {
        if (immutableViewportMetrics == null) {
            return;
        }
        boolean bl = false;
        if (!this.mEdges[0].isFinished()) {
            bl |= this.draw(this.mEdges[0], canvas, immutableViewportMetrics.marginLeft, immutableViewportMetrics.marginTop, 0.0f);
        }
        if (!this.mEdges[1].isFinished()) {
            bl |= this.draw(this.mEdges[1], canvas, this.mView.getWidth(), this.mView.getHeight(), 180.0f);
        }
        if (!this.mEdges[2].isFinished()) {
            bl |= this.draw(this.mEdges[2], canvas, immutableViewportMetrics.marginLeft, this.mView.getHeight(), 270.0f);
        }
        if (!this.mEdges[3].isFinished()) {
            bl |= this.draw(this.mEdges[3], canvas, this.mView.getWidth(), immutableViewportMetrics.marginTop, 90.0f);
        }
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)this.mView);
        }
    }

    public boolean draw(EdgeEffectCompat edgeEffectCompat, Canvas canvas, float f, float f2, float f3) {
        int n = canvas.save();
        canvas.translate(f, f2);
        canvas.rotate(f3);
        boolean bl = edgeEffectCompat.draw(canvas);
        canvas.restoreToCount(n);
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y;

    }
}

