/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.health;

import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.Distribution;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.background.healthreport.EnvironmentBuilder;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;
import org.mozilla.gecko.background.healthreport.ProfileInformationCache;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class BrowserHealthRecorder
implements GeckoEventListener {
    private static final String LOG_TAG = "GeckoHealthRec";
    private static final String PREF_ACCEPT_LANG = "intl.accept_languages";
    private static final String PREF_BLOCKLIST_ENABLED = "extensions.blocklist.enabled";
    private static final String EVENT_SNAPSHOT = "HealthReport:Snapshot";
    private static final String EVENT_ADDONS_CHANGE = "Addons:Change";
    private static final String EVENT_ADDONS_UNINSTALLING = "Addons:Uninstalling";
    private static final String EVENT_PREF_CHANGE = "Pref:Change";
    public static final String EVENT_KEYWORD_SEARCH = "Search:Keyword";
    public static final String EVENT_SEARCH = "Search:Event";
    protected volatile State state = State.NOT_INITIALIZED;
    private final AtomicBoolean orphanChecked = new AtomicBoolean(false);
    private volatile int env = -1;
    private ContentProviderClient client;
    private volatile HealthReportDatabaseStorage storage;
    private final ProfileInformationCache profileCache;
    private final EventDispatcher dispatcher;
    private final SessionInformation previousSession;
    private volatile SessionInformation session = null;
    public static final String MEASUREMENT_NAME_SEARCH_COUNTS = "org.mozilla.searches.counts";
    public static final int MEASUREMENT_VERSION_SEARCH_COUNTS = 4;
    public static final String[] SEARCH_LOCATIONS = new String[]{"barkeyword", "barsuggest", "bartext"};
    private static final String[] SEARCH_PROVIDERS = new String[]{"amazon-co-uk", "amazon-de", "amazon-en-GB", "amazon-france", "amazon-it", "amazon-jp", "amazondotcn", "amazondotcom", "amazondotcom-de", "aol-en-GB", "aol-web-search", "bing", "eBay", "eBay-de", "eBay-en-GB", "eBay-es", "eBay-fi", "eBay-france", "eBay-hu", "eBay-in", "eBay-it", "google", "google-jp", "google-ku", "google-maps-zh-TW", "mailru", "mercadolibre-ar", "mercadolibre-cl", "mercadolibre-mx", "seznam-cz", "twitter", "twitter-de", "twitter-ja", "wikipedia", "yahoo", "yahoo-NO", "yahoo-answer-zh-TW", "yahoo-ar", "yahoo-bid-zh-TW", "yahoo-br", "yahoo-ch", "yahoo-cl", "yahoo-de", "yahoo-en-GB", "yahoo-es", "yahoo-fi", "yahoo-france", "yahoo-fy-NL", "yahoo-id", "yahoo-in", "yahoo-it", "yahoo-jp", "yahoo-jp-auctions", "yahoo-mx", "yahoo-sv-SE", "yahoo-zh-TW", "yandex", "yandex-ru", "yandex-slovari", "yandex-tr", "yandex.by", "yandex.ru-be"};
    public static final String MEASUREMENT_NAME_SESSIONS = "org.mozilla.appSessions";
    public static final int MEASUREMENT_VERSION_SESSIONS = 4;

    public SessionInformation getCurrentSession() {
        return this.session;
    }

    public void setCurrentSession(SessionInformation sessionInformation) {
        this.session = sessionInformation;
    }

    public void recordGeckoStartupTime(long l) {
        if (this.session == null) {
            return;
        }
        this.session.timedGeckoStartup = l;
    }

    public void recordJavaStartupTime(long l) {
        if (this.session == null) {
            return;
        }
        this.session.timedJavaStartup = l;
    }

    private void setHealthEnvironment(int n) {
        this.env = n;
    }

    public BrowserHealthRecorder(Context context, String string2, EventDispatcher eventDispatcher, String string3, String string4, SessionInformation sessionInformation) {
        Log.d((String)LOG_TAG, (String)("Initializing. Dispatcher is " + eventDispatcher));
        this.dispatcher = eventDispatcher;
        this.previousSession = sessionInformation;
        this.client = EnvironmentBuilder.getContentProviderClient(context);
        if (this.client == null) {
            throw new IllegalStateException("Could not fetch Health Report content provider.");
        }
        this.storage = EnvironmentBuilder.getStorage(this.client, string2);
        if (this.storage == null) {
            this.client.release();
            this.client = null;
        }
        this.profileCache = new ProfileInformationCache(string2);
        try {
            this.initialize(context, string2, string3, string4);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)"Exception initializing.", (Throwable)exception);
        }
    }

    public synchronized void close() {
        switch (this.state) {
            case CLOSED: {
                Log.w((String)LOG_TAG, (String)"Ignoring attempt to double-close closed BrowserHealthRecorder.");
                return;
            }
            case INITIALIZED: {
                Log.i((String)LOG_TAG, (String)"Closing Health Report client.");
                break;
            }
            default: {
                Log.i((String)LOG_TAG, (String)"Closing incompletely initialized BrowserHealthRecorder.");
            }
        }
        this.state = State.CLOSED;
        this.unregisterEventListeners();
        this.storage = null;
        if (this.client != null) {
            this.client.release();
            this.client = null;
        }
    }

    private void unregisterEventListeners() {
        this.dispatcher.unregisterEventListener(EVENT_SNAPSHOT, (GeckoEventListener)this);
        this.dispatcher.unregisterEventListener(EVENT_ADDONS_CHANGE, (GeckoEventListener)this);
        this.dispatcher.unregisterEventListener(EVENT_ADDONS_UNINSTALLING, (GeckoEventListener)this);
        this.dispatcher.unregisterEventListener(EVENT_PREF_CHANGE, (GeckoEventListener)this);
        this.dispatcher.unregisterEventListener(EVENT_KEYWORD_SEARCH, (GeckoEventListener)this);
        this.dispatcher.unregisterEventListener(EVENT_SEARCH, (GeckoEventListener)this);
    }

    public void onAppLocaleChanged(String string2) {
        this.profileCache.beginInitialization();
        this.profileCache.setAppLocale(string2);
    }

    public void onAddonChanged(String string2, JSONObject jSONObject) {
        this.profileCache.beginInitialization();
        try {
            this.profileCache.updateJSONForAddon(string2, jSONObject);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)LOG_TAG, (String)"Attempted to update add-on cache prior to full init.", (Throwable)illegalStateException);
        }
    }

    public void onAddonUninstalling(String string2) {
        this.profileCache.beginInitialization();
        try {
            this.profileCache.removeAddon(string2);
        }
        catch (IllegalStateException illegalStateException) {
            Log.w((String)LOG_TAG, (String)"Attempted to update add-on cache prior to full init.", (Throwable)illegalStateException);
        }
    }

    public synchronized void onEnvironmentChanged() {
        final int n = this.env;
        this.env = -1;
        try {
            this.profileCache.completeInitialization();
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Error completing profile cache initialization.", (Throwable)iOException);
            this.state = State.INITIALIZATION_FAILED;
            return;
        }
        final int n2 = this.ensureEnvironment();
        if (n2 == -1 || n2 == n) {
            Log.v((String)LOG_TAG, (String)"Environment didn't change.");
            return;
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                try {
                    BrowserHealthRecorder.this.onEnvironmentTransition(n, n2);
                }
                catch (Exception exception) {
                    Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)"Could not record environment transition.", (Throwable)exception);
                }
            }
        });
    }

    protected synchronized int ensureEnvironment() {
        if (this.state != State.INITIALIZING && this.state != State.INITIALIZED) {
            throw new IllegalStateException("Not initialized.");
        }
        if (this.env != -1) {
            return this.env;
        }
        if (this.storage == null) {
            return -1;
        }
        this.env = EnvironmentBuilder.registerCurrentEnvironment(this.storage, this.profileCache);
        return this.env;
    }

    private static final String getTimesPath(String string2) {
        return string2 + File.separator + "times.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getProfileInitTimeFromFile(String string2) {
        File file = new File(BrowserHealthRecorder.getTimesPath(string2));
        Log.d((String)LOG_TAG, (String)("Looking for " + file.getAbsolutePath()));
        if (!file.exists()) {
            return -1L;
        }
        Log.d((String)LOG_TAG, (String)"Using times.json for profile creation time.");
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, "UTF-8");
            String string3 = scanner.useDelimiter("\\A").next();
            long l = new JSONObject(string3).getLong("created");
            return l;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Failed to read times.json.", (Throwable)exception);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        return -1L;
    }

    protected static long getPackageInstallTime(Context context) {
        if (Build.VERSION.SDK_INT < 9) {
            return -1L;
        }
        try {
            return context.getPackageManager().getPackageInfo((String)"org.mozilla.fennec", (int)0).firstInstallTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)LOG_TAG, (String)"Unable to fetch our own package info. This should never occur.", (Throwable)nameNotFoundException);
            return -1L;
        }
    }

    private static long getProfileInitTimeHeuristic(Context context, String string2) {
        long l = BrowserHealthRecorder.getPackageInstallTime(context);
        if (l != -1L) {
            return l;
        }
        Log.d((String)LOG_TAG, (String)"Using profile directory modified time as proxy for profile creation time.");
        return new File(string2).lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getAndPersistProfileInitTime(Context context, String string2) {
        long l = BrowserHealthRecorder.getProfileInitTimeFromFile(string2);
        if (l > 0L) {
            Log.d((String)LOG_TAG, (String)("Incorporating environment: times.json profile creation = " + l));
            return l;
        }
        l = BrowserHealthRecorder.getProfileInitTimeHeuristic(context, string2);
        if (l > 0L) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(BrowserHealthRecorder.getTimesPath(string2));
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
                try {
                    outputStreamWriter.append("{\"created\": " + l + "}\n");
                }
                finally {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {
                Log.w((String)LOG_TAG, (String)"Couldn't write times.json.", (Throwable)exception);
            }
        }
        Log.d((String)LOG_TAG, (String)("Incorporating environment: profile creation = " + l));
        return l;
    }

    private void onPrefMessage(String string2, JSONObject jSONObject) {
        Log.d((String)LOG_TAG, (String)("Incorporating environment: " + string2));
        if (PREF_ACCEPT_LANG.equals(string2)) {
            try {
                this.profileCache.beginInitialization();
                this.profileCache.setAcceptLangUserSet(jSONObject.getBoolean("isUserSet"));
            }
            catch (JSONException jSONException) {
                Log.w((String)LOG_TAG, (String)("Unexpected JSONException fetching isUserSet for " + string2));
            }
            return;
        }
        try {
            boolean bl = jSONObject.getBoolean("value");
            if ("toolkit.telemetry.enabledPreRelease".equals(string2)) {
                this.profileCache.beginInitialization();
                this.profileCache.setTelemetryEnabled(bl);
                return;
            }
            if (PREF_BLOCKLIST_ENABLED.equals(string2)) {
                this.profileCache.beginInitialization();
                this.profileCache.setBlocklistEnabled(bl);
                return;
            }
        }
        catch (JSONException jSONException) {
            Log.w((String)LOG_TAG, (String)("Unexpected JSONException fetching boolean value for " + string2));
            return;
        }
        Log.w((String)LOG_TAG, (String)("Unexpected pref: " + string2));
    }

    private void initializeStorage() {
        Log.d((String)LOG_TAG, (String)"Done initializing profile cache. Beginning storage init.");
        final BrowserHealthRecorder browserHealthRecorder = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowserHealthRecorder browserHealthRecorder2 = browserHealthRecorder;
                synchronized (browserHealthRecorder2) {
                    if (BrowserHealthRecorder.this.state != State.INITIALIZING) {
                        Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)("Unexpected state during init: " + (Object)((Object)BrowserHealthRecorder.this.state)));
                        return;
                    }
                    if (BrowserHealthRecorder.this.storage == null) {
                        Log.w((String)BrowserHealthRecorder.LOG_TAG, (String)"Storage is null during init; shutting down?");
                        if (BrowserHealthRecorder.this.state == State.INITIALIZING) {
                            BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        }
                        return;
                    }
                    try {
                        BrowserHealthRecorder.this.storage.beginInitialization();
                    }
                    catch (Exception exception) {
                        Log.e((String)BrowserHealthRecorder.LOG_TAG, (String)"Failed to init storage.", (Throwable)exception);
                        BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        return;
                    }
                    try {
                        BrowserHealthRecorder.this.dispatcher.registerEventListener(BrowserHealthRecorder.EVENT_ADDONS_UNINSTALLING, (GeckoEventListener)browserHealthRecorder);
                        BrowserHealthRecorder.this.dispatcher.registerEventListener(BrowserHealthRecorder.EVENT_ADDONS_CHANGE, (GeckoEventListener)browserHealthRecorder);
                        BrowserHealthRecorder.this.dispatcher.registerEventListener(BrowserHealthRecorder.EVENT_PREF_CHANGE, (GeckoEventListener)browserHealthRecorder);
                        BrowserHealthRecorder.this.initializeSessionsProvider();
                        BrowserHealthRecorder.this.initializeSearchProvider();
                        Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Ensuring environment.");
                        BrowserHealthRecorder.this.ensureEnvironment();
                        Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Finishing init.");
                        BrowserHealthRecorder.this.storage.finishInitialization();
                        BrowserHealthRecorder.this.state = State.INITIALIZED;
                    }
                    catch (Exception exception) {
                        BrowserHealthRecorder.this.state = State.INITIALIZATION_FAILED;
                        BrowserHealthRecorder.this.storage.abortInitialization();
                        Log.e((String)BrowserHealthRecorder.LOG_TAG, (String)"Initialization failed.", (Throwable)exception);
                        return;
                    }
                    BrowserHealthRecorder.this.checkForOrphanSessions();
                }
            }
        });
    }

    private synchronized void initialize(final Context context, String string2, String string3, String string4) throws IOException {
        Log.d((String)LOG_TAG, (String)"Initializing profile cache.");
        this.state = State.INITIALIZING;
        if (this.profileCache.restoreUnlessInitialized()) {
            this.profileCache.updateLocales(string3, string4);
            this.profileCache.completeInitialization();
            Log.d((String)LOG_TAG, (String)"Successfully restored state. Initializing storage.");
            this.initializeStorage();
            return;
        }
        this.profileCache.beginInitialization();
        this.profileCache.setProfileCreationTime(BrowserHealthRecorder.getAndPersistProfileInitTime(context, string2));
        this.profileCache.setOSLocale(string3);
        this.profileCache.setAppLocale(string4);
        final BrowserHealthRecorder browserHealthRecorder = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                Distribution.DistributionDescriptor distributionDescriptor = new Distribution(context).getDescriptor();
                if (distributionDescriptor != null && distributionDescriptor.valid) {
                    BrowserHealthRecorder.this.profileCache.setDistributionString(distributionDescriptor.id, distributionDescriptor.version);
                }
                Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"Requesting all add-ons and FHR prefs from Gecko.");
                BrowserHealthRecorder.this.dispatcher.registerEventListener(BrowserHealthRecorder.EVENT_SNAPSHOT, browserHealthRecorder);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HealthReport:RequestSnapshot", null));
            }
        });
    }

    protected void onEnvironmentTransition(int n, int n2) {
        if (this.state != State.INITIALIZED) {
            Log.d((String)LOG_TAG, (String)("Not initialized: not recording env transition (" + n + " => " + n2 + ")."));
            return;
        }
        SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        this.recordSessionEnd("E", editor, n);
        SessionInformation sessionInformation = SessionInformation.forRuntimeTransition();
        this.setCurrentSession(sessionInformation);
        sessionInformation.recordBegin(editor);
        editor.commit();
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (EVENT_SNAPSHOT.equals(string2)) {
                Log.d((String)LOG_TAG, (String)"Got all add-ons and prefs.");
                try {
                    JSONObject jSONObject2 = jSONObject.getJSONObject("json");
                    JSONObject jSONObject3 = jSONObject2.getJSONObject("addons");
                    Log.i((String)LOG_TAG, (String)("Persisting " + jSONObject3.length() + " add-ons."));
                    this.profileCache.setJSONForAddons(jSONObject3);
                    JSONObject jSONObject4 = jSONObject2.getJSONObject("prefs");
                    Log.i((String)LOG_TAG, (String)"Persisting prefs.");
                    Iterator iterator = jSONObject4.keys();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        this.onPrefMessage(string3, jSONObject4.getJSONObject(string3));
                    }
                    this.profileCache.completeInitialization();
                }
                catch (IOException iOException) {
                    Log.e((String)LOG_TAG, (String)"Error completing profile cache initialization.", (Throwable)iOException);
                    this.state = State.INITIALIZATION_FAILED;
                    return;
                }
                if (this.state == State.INITIALIZING) {
                    this.initializeStorage();
                } else {
                    this.onEnvironmentChanged();
                }
                return;
            }
            if (EVENT_ADDONS_UNINSTALLING.equals(string2)) {
                this.onAddonUninstalling(jSONObject.getString("id"));
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_ADDONS_CHANGE.equals(string2)) {
                this.onAddonChanged(jSONObject.getString("id"), jSONObject.getJSONObject("json"));
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_PREF_CHANGE.equals(string2)) {
                String string4 = jSONObject.getString("pref");
                Log.d((String)LOG_TAG, (String)("Pref changed: " + string4));
                this.onPrefMessage(string4, jSONObject);
                this.onEnvironmentChanged();
                return;
            }
            if (EVENT_KEYWORD_SEARCH.equals(string2)) {
                this.recordSearch(jSONObject.getString("identifier"), "bartext");
                return;
            }
            if (EVENT_SEARCH.equals(string2)) {
                if (!jSONObject.has("location")) {
                    Log.d((String)LOG_TAG, (String)"Ignoring search without location.");
                    return;
                }
                this.recordSearch(jSONObject.optString("identifier", null), jSONObject.getString("location"));
                return;
            }
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    private void initializeSearchProvider() {
        this.storage.ensureMeasurementInitialized(MEASUREMENT_NAME_SEARCH_COUNTS, 4, new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                ArrayList<HealthReportStorage.MeasurementFields.FieldSpec> arrayList = new ArrayList<HealthReportStorage.MeasurementFields.FieldSpec>(SEARCH_LOCATIONS.length);
                for (String string2 : SEARCH_LOCATIONS) {
                    arrayList.add(new HealthReportStorage.MeasurementFields.FieldSpec(string2, 16642));
                }
                return arrayList;
            }
        });
        this.dispatcher.registerEventListener(EVENT_KEYWORD_SEARCH, (GeckoEventListener)this);
        this.dispatcher.registerEventListener(EVENT_SEARCH, (GeckoEventListener)this);
    }

    protected String getEngineKey(String string2) {
        if (string2 == null) {
            return "other";
        }
        boolean bl = 0 <= Arrays.binarySearch(SEARCH_PROVIDERS, string2);
        return bl ? string2 : "other";
    }

    public void recordSearch(String string2, final String string3) {
        if (this.state != State.INITIALIZED) {
            Log.d((String)LOG_TAG, (String)("Not initialized: not recording search. (" + (Object)((Object)this.state) + ")"));
            return;
        }
        if (string3 == null) {
            throw new IllegalArgumentException("location must be provided for search.");
        }
        final int n = this.storage.getDay();
        final int n2 = this.env;
        final String string4 = this.getEngineKey(string2);
        final BrowserHealthRecorder browserHealthRecorder = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                HealthReportDatabaseStorage healthReportDatabaseStorage = browserHealthRecorder.storage;
                if (healthReportDatabaseStorage == null) {
                    Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)"No storage: not recording search. Shutting down?");
                    return;
                }
                Log.d((String)BrowserHealthRecorder.LOG_TAG, (String)("Recording search: " + string4 + ", " + string3 + " (" + n + ", " + n2 + ")."));
                int n3 = healthReportDatabaseStorage.getField(BrowserHealthRecorder.MEASUREMENT_NAME_SEARCH_COUNTS, 4, string3).getID();
                healthReportDatabaseStorage.recordDailyDiscrete(n2, n, n3, string4);
            }
        });
    }

    private void initializeSessionsProvider() {
        this.storage.ensureMeasurementInitialized(MEASUREMENT_NAME_SESSIONS, 4, new HealthReportStorage.MeasurementFields(){

            @Override
            public Iterable<HealthReportStorage.MeasurementFields.FieldSpec> getFields() {
                ArrayList<HealthReportStorage.MeasurementFields.FieldSpec> arrayList = new ArrayList<HealthReportStorage.MeasurementFields.FieldSpec>(2);
                arrayList.add(new HealthReportStorage.MeasurementFields.FieldSpec("normal", 260));
                arrayList.add(new HealthReportStorage.MeasurementFields.FieldSpec("abnormal", 260));
                return arrayList;
            }
        });
    }

    private void recordSessionEntry(String string2, SessionInformation sessionInformation, int n, JSONObject jSONObject) {
        HealthReportDatabaseStorage healthReportDatabaseStorage = this.storage;
        if (healthReportDatabaseStorage == null) {
            Log.d((String)LOG_TAG, (String)"No storage: not recording session entry. Shutting down?");
            return;
        }
        try {
            int n2 = healthReportDatabaseStorage.getField(MEASUREMENT_NAME_SESSIONS, 4, string2).getID();
            int n3 = healthReportDatabaseStorage.getDay(sessionInformation.wallStartTime);
            healthReportDatabaseStorage.recordDailyDiscrete(n, n3, n2, jSONObject);
            Log.v((String)LOG_TAG, (String)("Recorded session entry for env " + n + ", current is " + this.env));
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Unable to record session completion.", (Throwable)exception);
        }
    }

    public void checkForOrphanSessions() {
        if (!this.orphanChecked.compareAndSet(false, true)) {
            Log.w((String)LOG_TAG, (String)"Attempting to check for orphan sessions more than once.");
            return;
        }
        Log.d((String)LOG_TAG, (String)"Checking for orphan session.");
        if (this.previousSession == null) {
            return;
        }
        if (this.previousSession.wallStartTime == 0L) {
            return;
        }
        if (this.state != State.INITIALIZED) {
            Log.e((String)LOG_TAG, (String)"Attempted to record bad session end without initialized recorder.");
            return;
        }
        try {
            this.recordSessionEntry("abnormal", this.previousSession, this.env, this.previousSession.getCrashedJSON());
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Unable to generate session JSON.", (Throwable)exception);
        }
    }

    public void recordSessionEnd(String string2, SharedPreferences.Editor editor) {
        this.recordSessionEnd(string2, editor, this.env);
    }

    public void recordSessionEnd(String string2, SharedPreferences.Editor editor, int n) {
        Log.d((String)LOG_TAG, (String)("Recording session end: " + string2));
        if (this.state != State.INITIALIZED) {
            Log.e((String)LOG_TAG, (String)"Attempted to record session end without initialized recorder.");
            return;
        }
        SessionInformation sessionInformation = this.session;
        this.session = null;
        if (sessionInformation == null) {
            Log.w((String)LOG_TAG, (String)"Unable to record session end: no session. Already ended?");
            return;
        }
        if (sessionInformation.wallStartTime <= 0L) {
            Log.e((String)LOG_TAG, (String)("Session start " + sessionInformation.wallStartTime + " isn't valid! Can't record end."));
            return;
        }
        long l = SystemClock.elapsedRealtime();
        try {
            JSONObject jSONObject = sessionInformation.getCompletionJSON(string2, l);
            this.recordSessionEntry("normal", sessionInformation, n, jSONObject);
        }
        catch (JSONException jSONException) {
            Log.w((String)LOG_TAG, (String)"Unable to generate session JSON.", (Throwable)jSONException);
        }
        sessionInformation.recordCompletion(editor);
    }

    public static class SessionInformation {
        private static final String LOG_TAG = "GeckoSessInfo";
        public static final String PREFS_SESSION_START = "sessionStart";
        public final long wallStartTime;
        public final long realStartTime;
        private final boolean wasOOM;
        private final boolean wasStopped;
        private volatile long timedGeckoStartup = -1L;
        private volatile long timedJavaStartup = -1L;

        public SessionInformation(long l, long l2) {
            this(l, l2, false, false);
        }

        public SessionInformation(long l, long l2, boolean bl, boolean bl2) {
            this.wallStartTime = l;
            this.realStartTime = l2;
            this.wasOOM = bl;
            this.wasStopped = bl2;
        }

        public static SessionInformation fromSharedPrefs(SharedPreferences sharedPreferences) {
            boolean bl = sharedPreferences.getBoolean("OOMException", false);
            boolean bl2 = sharedPreferences.getBoolean("wasStopped", true);
            long l = sharedPreferences.getLong(PREFS_SESSION_START, 0L);
            long l2 = 0L;
            Log.d((String)LOG_TAG, (String)("Building SessionInformation from prefs: " + l + ", " + l2 + ", " + bl2 + ", " + bl));
            return new SessionInformation(l, l2, bl, bl2);
        }

        public static SessionInformation forRuntimeTransition() {
            long l = System.currentTimeMillis();
            long l2 = SystemClock.elapsedRealtime();
            Log.v((String)LOG_TAG, (String)("Recording runtime session transition: " + l + ", " + l2));
            return new SessionInformation(l, l2, false, true);
        }

        public boolean wasKilled() {
            return this.wasOOM || !this.wasStopped;
        }

        public void recordBegin(SharedPreferences.Editor editor) {
            Log.d((String)LOG_TAG, (String)("Recording start of session: " + this.wallStartTime));
            editor.putLong(PREFS_SESSION_START, this.wallStartTime);
        }

        public void recordCompletion(SharedPreferences.Editor editor) {
            Log.d((String)LOG_TAG, (String)("Recording session done: " + this.wallStartTime));
            editor.remove(PREFS_SESSION_START);
        }

        public JSONObject getCompletionJSON(String string2, long l) throws JSONException {
            long l2 = (l - this.realStartTime) / 1000L;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("r", (Object)string2);
            jSONObject.put("d", l2);
            if (this.timedGeckoStartup > 0L) {
                jSONObject.put("sg", this.timedGeckoStartup);
            }
            if (this.timedJavaStartup > 0L) {
                jSONObject.put("sj", this.timedJavaStartup);
            }
            return jSONObject;
        }

        public JSONObject getCrashedJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("oom", this.wasOOM ? 1 : 0);
            jSONObject.put("stopped", this.wasStopped ? 1 : 0);
            jSONObject.put("r", (Object)"A");
            return jSONObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED,
        INITIALIZATION_FAILED,
        CLOSED;

    }
}

