/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.util.Pair;
import android.view.View;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.BookmarkFolderView;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.TwoLinePageRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BookmarksListAdapter
extends MultiTypeCursorAdapter {
    private static final int VIEW_TYPE_ITEM = 0;
    private static final int VIEW_TYPE_FOLDER = 1;
    private static final int[] VIEW_TYPES = new int[]{0, 1};
    private static final int[] LAYOUT_TYPES = new int[]{R.layout.bookmark_item_row, R.layout.bookmark_folder_row};
    private LinkedList<Pair<Integer, String>> mParentStack;
    private OnRefreshFolderListener mListener;

    public BookmarksListAdapter(Context context, Cursor cursor, List<Pair<Integer, String>> list) {
        super(context, cursor, VIEW_TYPES, LAYOUT_TYPES);
        if (list == null) {
            this.mParentStack = new LinkedList();
            Pair pair = new Pair((Object)0, (Object)"");
            this.mParentStack.addFirst((Pair<Integer, String>)pair);
        } else {
            this.mParentStack = new LinkedList<Pair<Integer, String>>(list);
        }
    }

    public List<Pair<Integer, String>> getParentStack() {
        return Collections.unmodifiableList(this.mParentStack);
    }

    private void refreshCurrentFolder() {
        if (this.mListener != null) {
            this.mListener.onRefreshFolder((Integer)this.mParentStack.peek().first);
        }
    }

    public boolean moveToParentFolder() {
        if (this.mParentStack.size() == 1) {
            return false;
        }
        this.mParentStack.removeFirst();
        this.refreshCurrentFolder();
        return true;
    }

    public void moveToChildFolder(int n, String string2) {
        Pair pair = new Pair((Object)n, (Object)string2);
        this.mParentStack.addFirst((Pair<Integer, String>)pair);
        this.refreshCurrentFolder();
    }

    public void setOnRefreshFolderListener(OnRefreshFolderListener onRefreshFolderListener) {
        this.mListener = onRefreshFolderListener;
    }

    public int getItemViewType(int n) {
        Cursor cursor;
        if (this.isShowingChildFolder()) {
            if (n == 0) {
                return 1;
            }
            --n;
        }
        if ((cursor = this.getCursor(n)).getInt(cursor.getColumnIndexOrThrow("type")) == 0) {
            return 1;
        }
        return 0;
    }

    public String getFolderTitle(Context context, Cursor cursor) {
        String string2 = cursor.getString(cursor.getColumnIndexOrThrow("guid"));
        if (string2 == null || string2.length() == 12) {
            return cursor.getString(cursor.getColumnIndexOrThrow("title"));
        }
        Resources resources = context.getResources();
        if (string2.equals("desktop")) {
            return resources.getString(R.string.bookmarks_folder_desktop);
        }
        if (string2.equals("menu")) {
            return resources.getString(R.string.bookmarks_folder_menu);
        }
        if (string2.equals("toolbar")) {
            return resources.getString(R.string.bookmarks_folder_toolbar);
        }
        if (string2.equals("unfiled")) {
            return resources.getString(R.string.bookmarks_folder_unfiled);
        }
        return cursor.getString(cursor.getColumnIndexOrThrow("title"));
    }

    public boolean isShowingChildFolder() {
        return (Integer)this.mParentStack.peek().first != 0;
    }

    public int getCount() {
        return super.getCount() + (this.isShowingChildFolder() ? 1 : 0);
    }

    @Override
    public void bindView(View view, Context context, int n) {
        int n2 = this.getItemViewType(n);
        Cursor cursor = this.isShowingChildFolder() ? (n == 0 ? null : this.getCursor(--n)) : this.getCursor(n);
        if (n2 == 0) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        } else {
            BookmarkFolderView bookmarkFolderView = (BookmarkFolderView)view;
            if (cursor == null) {
                bookmarkFolderView.setText((CharSequence)this.mParentStack.peek().second);
                bookmarkFolderView.open();
            } else {
                bookmarkFolderView.setText(this.getFolderTitle(context, cursor));
                bookmarkFolderView.close();
            }
        }
    }

    public static interface OnRefreshFolderListener {
        public void onRefreshFolder(int var1);
    }
}

