/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.BookmarksListAdapter;
import org.mozilla.gecko.home.BookmarksListView;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;

public class BookmarksPage
extends HomeFragment {
    public static final String LOGTAG = "GeckoBookmarksPage";
    private static final int LOADER_ID_BOOKMARKS_LIST = 0;
    private static final String BOOKMARKS_FOLDER_KEY = "folder_id";
    private BookmarksListView mList;
    private BookmarksListAdapter mListAdapter;
    private List<Pair<Integer, String>> mSavedParentStack;
    private View mEmptyView;
    private CursorLoaderCallbacks mLoaderCallbacks;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.home_bookmarks_page, viewGroup, false);
        this.mList = (BookmarksListView)view.findViewById(R.id.bookmarks_list);
        return view;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        HomePager.OnUrlOpenListener onUrlOpenListener = null;
        try {
            onUrlOpenListener = (HomePager.OnUrlOpenListener)this.getActivity();
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(this.getActivity().toString() + " must implement HomePager.OnUrlOpenListener");
        }
        this.mList.setTag("bookmarks");
        this.mList.setOnUrlOpenListener(onUrlOpenListener);
        this.registerForContextMenu((View)this.mList);
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        FragmentActivity fragmentActivity = this.getActivity();
        this.mListAdapter = new BookmarksListAdapter((Context)fragmentActivity, null, this.mSavedParentStack);
        this.mListAdapter.setOnRefreshFolderListener(new BookmarksListAdapter.OnRefreshFolderListener(){

            public void onRefreshFolder(int n) {
                Bundle bundle = new Bundle();
                bundle.putInt(BookmarksPage.BOOKMARKS_FOLDER_KEY, n);
                BookmarksPage.this.getLoaderManager().restartLoader(0, bundle, (LoaderManager.LoaderCallbacks)BookmarksPage.this.mLoaderCallbacks);
            }
        });
        this.mList.setAdapter((ListAdapter)this.mListAdapter);
        BrowserDB.invalidateCachedState();
        this.mLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    public void onDestroyView() {
        this.mList = null;
        this.mListAdapter = null;
        this.mEmptyView = null;
        super.onDestroyView();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.mSavedParentStack = this.mListAdapter.getParentStack();
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if ((cursor == null || cursor.getCount() == 0) && this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_bookmarks_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_bookmarks_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            if (bundle == null) {
                return new BookmarksLoader((Context)BookmarksPage.this.getActivity());
            }
            return new BookmarksLoader((Context)BookmarksPage.this.getActivity(), bundle.getInt(BookmarksPage.BOOKMARKS_FOLDER_KEY));
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            BookmarksPage.this.mListAdapter.swapCursor(cursor);
            BookmarksPage.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (BookmarksPage.this.mList != null) {
                BookmarksPage.this.mListAdapter.swapCursor(null);
            }
        }
    }

    private static class BookmarksLoader
    extends SimpleCursorLoader {
        private final int mFolderId;

        public BookmarksLoader(Context context) {
            this(context, 0);
        }

        public BookmarksLoader(Context context, int n) {
            super(context);
            this.mFolderId = n;
        }

        public Cursor loadCursor() {
            return BrowserDB.getBookmarksInFolder(this.getContext().getContentResolver(), this.mFolderId);
        }
    }
}

