/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import org.mozilla.gecko.EditBookmarkDialog;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;

abstract class HomeFragment
extends Fragment {
    private static final String LOGTAG = "GeckoHomeFragment";
    private static final String SHARE_MIME_TYPE = "text/plain";
    private boolean mCanLoadHint;
    private boolean mIsLoaded;

    HomeFragment() {
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        this.mCanLoadHint = bundle2 != null ? bundle2.getBoolean("canLoad", false) : false;
        this.mIsLoaded = false;
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeListView.HomeContextMenuInfo)) {
            return;
        }
        HomeListView.HomeContextMenuInfo homeContextMenuInfo = (HomeListView.HomeContextMenuInfo)contextMenuInfo;
        if (homeContextMenuInfo.isFolder) {
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_contextmenu, (Menu)contextMenu);
        contextMenu.setHeaderTitle((CharSequence)homeContextMenuInfo.getDisplayTitle());
        if (homeContextMenuInfo.bookmarkId < 0) {
            contextMenu.findItem(R.id.home_edit_bookmark).setVisible(false);
        }
        if (homeContextMenuInfo.bookmarkId < 0 && homeContextMenuInfo.historyId < 0) {
            contextMenu.findItem(R.id.home_remove).setVisible(false);
        }
        contextMenu.findItem(R.id.home_share).setVisible(!GeckoProfile.get((Context)this.getActivity()).inGuestMode());
        boolean bl = homeContextMenuInfo.display == 1;
        contextMenu.findItem(R.id.home_open_in_reader).setVisible(bl);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (contextMenuInfo == null || !(contextMenuInfo instanceof HomeListView.HomeContextMenuInfo)) {
            return false;
        }
        final HomeListView.HomeContextMenuInfo homeContextMenuInfo = (HomeListView.HomeContextMenuInfo)contextMenuInfo;
        Context context = this.getActivity().getApplicationContext();
        int n = menuItem.getItemId();
        if (n == R.id.home_share) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't share because URL is null");
            } else {
                GeckoAppShell.openUriExternal(homeContextMenuInfo.url, SHARE_MIME_TYPE, "", "", "android.intent.action.SEND", homeContextMenuInfo.getDisplayTitle());
            }
        }
        if (n == R.id.home_add_to_launcher) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't add to home screen because URL is null");
                return false;
            }
            Favicons.getLargestFaviconForPage(homeContextMenuInfo.url, new OnFaviconLoadedListener(){

                public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
                    GeckoAppShell.createShortcut(homeContextMenuInfo.getDisplayTitle(), homeContextMenuInfo.url, bitmap, "");
                }
            });
            return true;
        }
        if (n == R.id.home_open_private_tab || n == R.id.home_open_new_tab) {
            if (homeContextMenuInfo.url == null) {
                Log.e((String)LOGTAG, (String)"Can't open in new tab because URL is null");
                return false;
            }
            int n2 = 65;
            if (menuItem.getItemId() == R.id.home_open_private_tab) {
                n2 |= 4;
            }
            String string2 = homeContextMenuInfo.inReadingList ? ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url) : homeContextMenuInfo.url;
            Tabs.getInstance().loadUrl(string2, n2);
            Toast.makeText((Context)context, (int)R.string.new_tab_opened, (int)0).show();
            return true;
        }
        if (n == R.id.home_edit_bookmark) {
            new EditBookmarkDialog((Context)this.getActivity()).show(homeContextMenuInfo.url);
            return true;
        }
        if (n == R.id.home_open_in_reader) {
            String string3 = ReaderModeUtils.getAboutReaderForUrl(homeContextMenuInfo.url);
            Tabs.getInstance().loadUrl(string3, 0);
            return true;
        }
        if (n == R.id.home_remove) {
            int n3 = homeContextMenuInfo.historyId;
            if (n3 > -1) {
                new RemoveHistoryTask(context, n3).execute(new Void[0]);
                return true;
            }
            int n4 = homeContextMenuInfo.bookmarkId;
            if (n4 > -1) {
                new RemoveBookmarkTask(context, n4, homeContextMenuInfo.url, homeContextMenuInfo.inReadingList).execute(new Void[0]);
                return true;
            }
        }
        return false;
    }

    public void setUserVisibleHint(boolean bl) {
        if (bl == this.getUserVisibleHint()) {
            return;
        }
        super.setUserVisibleHint(bl);
        this.loadIfVisible();
    }

    void setCanLoadHint(boolean bl) {
        if (this.mCanLoadHint == bl) {
            return;
        }
        this.mCanLoadHint = bl;
        this.loadIfVisible();
    }

    boolean getCanLoadHint() {
        return this.mCanLoadHint;
    }

    protected abstract void load();

    protected void loadIfVisible() {
        if (!(this.mCanLoadHint && this.isVisible() && this.getUserVisibleHint())) {
            return;
        }
        if (!this.mIsLoaded) {
            this.load();
            this.mIsLoaded = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveHistoryTask
    extends UiAsyncTask<Void, Void, Void> {
        private final Context mContext;
        private final int mId;

        public RemoveHistoryTask(Context context, int n) {
            super(ThreadUtils.getBackgroundHandler());
            this.mContext = context;
            this.mId = n;
        }

        public Void doInBackground(Void ... voidArray) {
            BrowserDB.removeHistoryEntry(this.mContext.getContentResolver(), this.mId);
            return null;
        }

        public void onPostExecute(Void void_) {
            Toast.makeText((Context)this.mContext, (int)R.string.history_removed, (int)0).show();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveBookmarkTask
    extends UiAsyncTask<Void, Void, Void> {
        private final Context mContext;
        private final int mId;
        private final String mUrl;
        private final boolean mInReadingList;

        public RemoveBookmarkTask(Context context, int n, String string2, boolean bl) {
            super(ThreadUtils.getBackgroundHandler());
            this.mContext = context;
            this.mId = n;
            this.mUrl = string2;
            this.mInReadingList = bl;
        }

        public Void doInBackground(Void ... voidArray) {
            ContentResolver contentResolver = this.mContext.getContentResolver();
            BrowserDB.removeBookmark(contentResolver, this.mId);
            if (this.mInReadingList) {
                GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent("Reader:Remove", this.mUrl);
                GeckoAppShell.sendEventToGecko(geckoEvent);
                int n = BrowserDB.getReadingListCount(contentResolver);
                geckoEvent = GeckoEvent.createBroadcastEvent("Reader:ListCountUpdated", Integer.toString(n));
                GeckoAppShell.sendEventToGecko(geckoEvent);
            }
            return null;
        }

        public void onPostExecute(Void void_) {
            int n = this.mInReadingList ? R.string.reading_list_removed : R.string.bookmark_removed;
            Toast.makeText((Context)this.mContext, (int)n, (int)0).show();
        }
    }
}

