/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.home.BookmarksPage;
import org.mozilla.gecko.home.HistoryPage;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.ReadingListPage;
import org.mozilla.gecko.home.TopSitesPage;
import org.mozilla.gecko.util.HardwareUtils;

public class HomePager
extends ViewPager {
    public static final String SUBPAGE_TAG = "home_pager_subpage";
    private final Context mContext;
    private volatile boolean mLoaded;
    private Decor mDecor;
    static final String LIST_TAG_HISTORY = "history";
    static final String LIST_TAG_BOOKMARKS = "bookmarks";
    static final String LIST_TAG_READING_LIST = "reading_list";
    static final String LIST_TAG_TOP_SITES = "top_sites";
    static final String LIST_TAG_MOST_RECENT = "most_recent";
    static final String LIST_TAG_LAST_TABS = "last_tabs";
    static final String LIST_TAG_BROWSER_SEARCH = "browser_search";
    private EnumMap<Page, Fragment> mPages = new EnumMap(Page.class);
    static final String CAN_LOAD_ARG = "canLoad";

    public HomePager(Context context) {
        this(context, null);
    }

    public HomePager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.setOffscreenPageLimit(3);
    }

    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (view instanceof Decor) {
            ((ViewPager.LayoutParams)layoutParams).isDecor = true;
            this.mDecor = (Decor)view;
            this.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageSelected(int n) {
                    HomePager.this.mDecor.onPageSelected(n);
                }

                public void onPageScrolled(int n, float f, int n2) {
                    HomePager.this.mDecor.onPageScrolled(n, f, n2);
                }

                public void onPageScrollStateChanged(int n) {
                }
            });
        }
        super.addView(view, n, layoutParams);
    }

    public void show(FragmentManager fragmentManager, Page page, PropertyAnimator propertyAnimator) {
        this.mLoaded = true;
        final TabsAdapter tabsAdapter = new TabsAdapter(fragmentManager);
        boolean bl = propertyAnimator != null && Build.VERSION.SDK_INT >= 11;
        tabsAdapter.addTab(Page.TOP_SITES, TopSitesPage.class, new Bundle(), this.getContext().getString(R.string.home_top_sites_title));
        tabsAdapter.addTab(Page.BOOKMARKS, BookmarksPage.class, new Bundle(), this.getContext().getString(R.string.bookmarks_title));
        if (!HardwareUtils.isLowMemoryPlatform()) {
            tabsAdapter.addTab(Page.READING_LIST, ReadingListPage.class, new Bundle(), this.getContext().getString(R.string.reading_list_title));
        }
        tabsAdapter.addTab(HardwareUtils.isTablet() ? -1 : 0, Page.HISTORY, HistoryPage.class, new Bundle(), this.getContext().getString(R.string.home_history_title));
        tabsAdapter.setCanLoadHint(!bl);
        this.setAdapter((PagerAdapter)tabsAdapter);
        this.setCurrentItem(tabsAdapter.getItemPosition(page), false);
        this.setVisibility(0);
        if (bl) {
            propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

                public void onPropertyAnimationStart() {
                    HomePager.this.setLayerType(2, null);
                }

                public void onPropertyAnimationEnd() {
                    HomePager.this.setLayerType(0, null);
                    tabsAdapter.setCanLoadHint(true);
                }
            });
            ViewHelper.setAlpha((View)this, 0.0f);
            propertyAnimator.attach((View)this, PropertyAnimator.Property.ALPHA, 1.0f);
        }
    }

    public void hide() {
        this.mLoaded = false;
        this.setVisibility(8);
        this.setAdapter(null);
    }

    public boolean isVisible() {
        return this.mLoaded;
    }

    public void setCurrentItem(int n, boolean bl) {
        super.setCurrentItem(n, bl);
        if (this.mDecor != null) {
            this.mDecor.onPageSelected(n);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0) {
            this.requestFocus();
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TabsAdapter
    extends FragmentStatePagerAdapter
    implements OnTitleClickListener {
        private final ArrayList<TabInfo> mTabs;

        public TabsAdapter(FragmentManager fragmentManager) {
            super(fragmentManager);
            this.mTabs = new ArrayList();
            if (HomePager.this.mDecor != null) {
                HomePager.this.mDecor.removeAllPagerViews();
                HomePager.this.mDecor.setOnTitleClickListener(this);
            }
        }

        public void addTab(Page page, Class<?> clazz, Bundle bundle, String string2) {
            this.addTab(-1, page, clazz, bundle, string2);
        }

        public void addTab(int n, Page page, Class<?> clazz, Bundle bundle, String string2) {
            TabInfo tabInfo = new TabInfo(page, clazz, bundle, string2);
            if (n >= 0) {
                this.mTabs.add(n, tabInfo);
            } else {
                this.mTabs.add(tabInfo);
            }
            this.notifyDataSetChanged();
            if (HomePager.this.mDecor != null) {
                HomePager.this.mDecor.onAddPagerView(string2);
            }
        }

        @Override
        public void onTitleClicked(int n) {
            HomePager.this.setCurrentItem(n, true);
        }

        public int getItemPosition(Page page) {
            for (int i = 0; i < this.mTabs.size(); ++i) {
                TabInfo tabInfo = this.mTabs.get(i);
                if (tabInfo.page != page) continue;
                return i;
            }
            return -1;
        }

        public int getCount() {
            return this.mTabs.size();
        }

        public Fragment getItem(int n) {
            TabInfo tabInfo = this.mTabs.get(n);
            return Fragment.instantiate((Context)HomePager.this.mContext, (String)tabInfo.clss.getName(), (Bundle)tabInfo.args);
        }

        public CharSequence getPageTitle(int n) {
            TabInfo tabInfo = this.mTabs.get(n);
            return tabInfo.title.toUpperCase();
        }

        public Object instantiateItem(ViewGroup viewGroup, int n) {
            Fragment fragment = (Fragment)super.instantiateItem(viewGroup, n);
            HomePager.this.mPages.put(this.mTabs.get(n).page, fragment);
            return fragment;
        }

        public void destroyItem(ViewGroup viewGroup, int n, Object object) {
            super.destroyItem(viewGroup, n, object);
            HomePager.this.mPages.remove((Object)this.mTabs.get(n).page);
        }

        public void setCanLoadHint(boolean bl) {
            for (TabInfo tabInfo : this.mTabs) {
                tabInfo.args.putBoolean(HomePager.CAN_LOAD_ARG, bl);
            }
            for (TabInfo tabInfo : HomePager.this.mPages.values()) {
                HomeFragment homeFragment = (HomeFragment)((Object)tabInfo);
                homeFragment.setCanLoadHint(bl);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TabInfo {
            private final Page page;
            private final Class<?> clss;
            private final Bundle args;
            private final String title;

            TabInfo(Page page, Class<?> clazz, Bundle bundle, String string2) {
                this.page = page;
                this.clss = clazz;
                this.args = bundle;
                this.title = string2;
            }
        }
    }

    static interface Decor {
        public void onAddPagerView(String var1);

        public void removeAllPagerViews();

        public void onPageSelected(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void setOnTitleClickListener(OnTitleClickListener var1);
    }

    static interface OnTitleClickListener {
        public void onTitleClicked(int var1);
    }

    public static interface OnNewTabsListener {
        public void onNewTabs(String[] var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OnUrlOpenListener {
        public void onUrlOpen(String var1, EnumSet<Flags> var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            ALLOW_SWITCH_TO_TAB;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Page {
        HISTORY,
        TOP_SITES,
        BOOKMARKS,
        READING_LIST;

    }
}

