/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TwoLinePageRow;

public class LastTabsPage
extends HomeFragment {
    private static final String LOGTAG = "GeckoLastTabsPage";
    private static final int LOADER_ID_LAST_TABS = 0;
    private LastTabsAdapter mAdapter;
    private ListView mList;
    private TextView mTitle;
    private View mRestoreButton;
    private View mEmptyView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private HomePager.OnNewTabsListener mNewTabsListener = null;

    public static LastTabsPage newInstance() {
        return new LastTabsPage();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mNewTabsListener = (HomePager.OnNewTabsListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnNewTabsListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mNewTabsListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_last_tabs_page, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mTitle = (TextView)view.findViewById(R.id.title);
        if (this.mTitle != null) {
            this.mTitle.setText(R.string.home_last_tabs_title);
        }
        this.mList = (ListView)view.findViewById(R.id.list);
        this.mList.setTag((Object)"last_tabs");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = LastTabsPage.this.mAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                LastTabsPage.this.mNewTabsListener.onNewTabs(new String[]{string2});
            }
        });
        this.registerForContextMenu((View)this.mList);
        this.mRestoreButton = view.findViewById(R.id.open_all_tabs_button);
        this.mRestoreButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LastTabsPage.this.openAllTabs();
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mTitle = null;
        this.mEmptyView = null;
        this.mRestoreButton = null;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new LastTabsAdapter((Context)this.getActivity());
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    private void updateUiFromCursor(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            if (this.mTitle != null) {
                this.mTitle.setVisibility(0);
            }
            this.mRestoreButton.setVisibility(0);
            return;
        }
        if (this.mTitle != null) {
            this.mTitle.setVisibility(8);
        }
        this.mRestoreButton.setVisibility(8);
        if (this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_last_tabs_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_last_tabs_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void openAllTabs() {
        Cursor cursor = this.mAdapter.getCursor();
        if (cursor == null || !cursor.moveToFirst()) {
            return;
        }
        String[] stringArray = new String[cursor.getCount()];
        do {
            stringArray[cursor.getPosition()] = cursor.getString(cursor.getColumnIndexOrThrow("url"));
        } while (cursor.moveToNext());
        this.mNewTabsListener.onNewTabs(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new LastTabsCursorLoader((Context)LastTabsPage.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            LastTabsPage.this.mAdapter.swapCursor(cursor);
            LastTabsPage.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            LastTabsPage.this.mAdapter.swapCursor(null);
        }
    }

    private static class LastTabsAdapter
    extends CursorAdapter {
        public LastTabsAdapter(Context context) {
            super(context, null, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            ((TwoLinePageRow)view).updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)context).inflate(R.layout.home_item_row, viewGroup, false);
        }
    }

    private static class LastTabsCursorLoader
    extends SimpleCursorLoader {
        public LastTabsCursorLoader(Context context) {
            super(context);
        }

        public Cursor loadCursor() {
            Context context = this.getContext();
            String string2 = GeckoProfile.get(context).readSessionFile(true);
            if (string2 == null) {
                return null;
            }
            final MatrixCursor matrixCursor = new MatrixCursor(new String[]{"_id", "url", "title"});
            new SessionParser(){

                public void onTabRead(SessionParser.SessionTab sessionTab) {
                    String string2 = sessionTab.getUrl();
                    if (string2.equals("about:home")) {
                        return;
                    }
                    MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
                    rowBuilder.add((Object)-1);
                    rowBuilder.add((Object)string2);
                    String string3 = sessionTab.getTitle();
                    rowBuilder.add((Object)string3);
                }
            }.parse(string2);
            return matrixCursor;
        }
    }
}

