/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Date;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TwoLinePageRow;

public class MostRecentPage
extends HomeFragment {
    private static final String LOGTAG = "GeckoMostRecentPage";
    private static final int LOADER_ID_HISTORY = 0;
    private MostRecentAdapter mAdapter;
    private ListView mList;
    private View mEmptyView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private HomePager.OnUrlOpenListener mUrlOpenListener = null;

    public static MostRecentPage newInstance() {
        return new MostRecentPage();
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_most_recent_page, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mList = (ListView)view.findViewById(R.id.list);
        this.mList.setTag((Object)"most_recent");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                n -= MostRecentPage.this.mAdapter.getMostRecentSectionsCountBefore(n);
                Cursor cursor = MostRecentPage.this.mAdapter.getCursor(n);
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                MostRecentPage.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mEmptyView = null;
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new MostRecentAdapter((Context)this.getActivity());
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            return;
        }
        if (this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_most_recent_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_most_recent_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new MostRecentCursorLoader((Context)MostRecentPage.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            MostRecentPage.this.mAdapter.swapCursor(cursor);
            MostRecentPage.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            MostRecentPage.this.mAdapter.swapCursor(null);
        }
    }

    private static class MostRecentAdapter
    extends MultiTypeCursorAdapter {
        private static final int ROW_HEADER = 0;
        private static final int ROW_STANDARD = 1;
        private static final int[] VIEW_TYPES = new int[]{1, 0};
        private static final int[] LAYOUT_TYPES = new int[]{R.layout.home_item_row, R.layout.home_header_row};
        private static final long MS_PER_DAY = 86400000L;
        private static final long MS_PER_WEEK = 604800000L;
        private final Context mContext;
        private final SparseArray<MostRecentSection> mMostRecentSections;

        public MostRecentAdapter(Context context) {
            super(context, null, VIEW_TYPES, LAYOUT_TYPES);
            this.mContext = context;
            this.mMostRecentSections = new SparseArray();
        }

        public Object getItem(int n) {
            int n2 = this.getItemViewType(n);
            if (n2 == 0) {
                return null;
            }
            return super.getItem(n - this.getMostRecentSectionsCountBefore(n));
        }

        public int getItemViewType(int n) {
            if (this.mMostRecentSections.get(n) != null) {
                return 0;
            }
            return 1;
        }

        public boolean isEnabled(int n) {
            return this.getItemViewType(n) == 1;
        }

        public int getCount() {
            return super.getCount() + this.mMostRecentSections.size();
        }

        public Cursor swapCursor(Cursor cursor) {
            this.loadMostRecentSections(cursor);
            Cursor cursor2 = super.swapCursor(cursor);
            return cursor2;
        }

        public void bindView(View view, Context context, int n) {
            int n2 = this.getItemViewType(n);
            if (n2 == 0) {
                MostRecentSection mostRecentSection = (MostRecentSection)((Object)this.mMostRecentSections.get(n));
                TextView textView = (TextView)view;
                textView.setText((CharSequence)this.getMostRecentSectionTitle(mostRecentSection));
            } else {
                n -= this.getMostRecentSectionsCountBefore(n);
                Cursor cursor = this.getCursor(n);
                TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
                twoLinePageRow.updateFromCursor(cursor);
            }
        }

        private String getMostRecentSectionTitle(MostRecentSection mostRecentSection) {
            switch (mostRecentSection) {
                case TODAY: {
                    return this.mContext.getString(R.string.history_today_section);
                }
                case YESTERDAY: {
                    return this.mContext.getString(R.string.history_yesterday_section);
                }
                case WEEK: {
                    return this.mContext.getString(R.string.history_week_section);
                }
                case OLDER: {
                    return this.mContext.getString(R.string.history_older_section);
                }
            }
            throw new IllegalStateException("Unrecognized history section");
        }

        private int getMostRecentSectionsCountBefore(int n) {
            int n2;
            int n3 = 0;
            int n4 = this.mMostRecentSections.size();
            for (int i = 0; i < n4 && (n2 = this.mMostRecentSections.keyAt(i)) <= n; ++i) {
                ++n3;
            }
            return n3;
        }

        private static MostRecentSection getMostRecentSectionForTime(long l, long l2) {
            long l3 = l - l2;
            if (l3 < 0L) {
                return MostRecentSection.TODAY;
            }
            if (l3 < 86400000L) {
                return MostRecentSection.YESTERDAY;
            }
            if (l3 < 604800000L) {
                return MostRecentSection.WEEK;
            }
            return MostRecentSection.OLDER;
        }

        private void loadMostRecentSections(Cursor cursor) {
            this.mMostRecentSections.clear();
            if (cursor == null || !cursor.moveToFirst()) {
                return;
            }
            Date date = new Date();
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            long l = date.getTime();
            MostRecentSection mostRecentSection = null;
            do {
                int n = cursor.getPosition();
                long l2 = cursor.getLong(cursor.getColumnIndexOrThrow("date-last-visited"));
                MostRecentSection mostRecentSection2 = MostRecentAdapter.getMostRecentSectionForTime(l, l2);
                if (mostRecentSection == mostRecentSection2) continue;
                mostRecentSection = mostRecentSection2;
                this.mMostRecentSections.append(n + this.mMostRecentSections.size(), (Object)mostRecentSection);
            } while (mostRecentSection != MostRecentSection.OLDER && cursor.moveToNext());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum MostRecentSection {
            TODAY,
            YESTERDAY,
            WEEK,
            OLDER;

        }
    }

    private static class MostRecentCursorLoader
    extends SimpleCursorLoader {
        private static final int HISTORY_LIMIT = 100;

        public MostRecentCursorLoader(Context context) {
            super(context);
        }

        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            return BrowserDB.getRecentHistory(contentResolver, 100);
        }
    }
}

