/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ReaderModeUtils;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TwoLinePageRow;

public class ReadingListPage
extends HomeFragment {
    private static final int LOADER_ID_READING_LIST = 0;
    private ReadingListAdapter mAdapter;
    private ListView mList;
    private View mEmptyView;
    private View mTopView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private HomePager.OnUrlOpenListener mUrlOpenListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_reading_list_page, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mTopView = view;
        this.mList = (ListView)view.findViewById(R.id.list);
        this.mList.setTag((Object)"reading_list");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = ReadingListPage.this.mAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                string2 = ReaderModeUtils.getAboutReaderForUrl(string2);
                ReadingListPage.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mTopView = null;
        this.mEmptyView = null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new ReadingListAdapter((Context)this.getActivity(), null);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    private void updateUiFromCursor(Cursor cursor) {
        if ((cursor == null || cursor.getCount() == 0) && this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.mTopView.findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_hint);
            String string2 = ((Object)textView.getText()).toString();
            int n = string2.indexOf("%I");
            if (n != -1) {
                ImageSpan imageSpan = new ImageSpan((Context)this.getActivity(), R.drawable.reader_cropped, 0);
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
                spannableStringBuilder.insert(n + 2, (CharSequence)" ");
                spannableStringBuilder.insert(n, (CharSequence)" ");
                spannableStringBuilder.setSpan((Object)imageSpan, n + 1, n + 3, 18);
                textView.setText((CharSequence)spannableStringBuilder, TextView.BufferType.SPANNABLE);
            }
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new ReadingListLoader((Context)ReadingListPage.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            ReadingListPage.this.mAdapter.swapCursor(cursor);
            ReadingListPage.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            ReadingListPage.this.mAdapter.swapCursor(null);
        }
    }

    private class ReadingListAdapter
    extends CursorAdapter {
        public ReadingListAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.bookmark_item_row, viewGroup, false);
        }
    }

    private static class ReadingListLoader
    extends SimpleCursorLoader {
        public ReadingListLoader(Context context) {
            super(context);
        }

        public Cursor loadCursor() {
            return BrowserDB.getBookmarksInFolder(this.getContext().getContentResolver(), -2L);
        }
    }
}

