/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomePager;

public class TabMenuStrip
extends LinearLayout
implements HomePager.Decor,
View.OnFocusChangeListener {
    private static final String LOGTAG = "GeckoTabMenuStrip";
    private HomePager.OnTitleClickListener mOnTitleClickListener;
    private Drawable mStrip;
    private View mSelectedView;
    private View toTab;
    private View fromTab;
    private float progress;
    private float mPrevProgress;

    public TabMenuStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabMenuStrip);
        int n = typedArray.getResourceId(0, -1);
        typedArray.recycle();
        if (n != -1) {
            this.mStrip = this.getResources().getDrawable(n);
        }
        this.setWillNotDraw(false);
    }

    public void onAddPagerView(String string2) {
        TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tab_menu_strip, (ViewGroup)this, false);
        textView.setText((CharSequence)string2.toUpperCase());
        this.addView((View)textView);
        textView.setOnClickListener((View.OnClickListener)new ViewClickListener(this.getChildCount() - 1));
        textView.setOnFocusChangeListener((View.OnFocusChangeListener)this);
    }

    public void removeAllPagerViews() {
        this.removeAllViews();
    }

    public void onPageSelected(final int n) {
        this.mSelectedView = this.getChildAt(n);
        ViewTreeObserver viewTreeObserver = this.mSelectedView.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    TabMenuStrip.this.mSelectedView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    if (TabMenuStrip.this.mStrip != null) {
                        TabMenuStrip.this.mStrip.setBounds(TabMenuStrip.this.mSelectedView.getLeft(), TabMenuStrip.this.mSelectedView.getTop(), TabMenuStrip.this.mSelectedView.getRight(), TabMenuStrip.this.mSelectedView.getBottom());
                    }
                    TabMenuStrip.this.mPrevProgress = n;
                }
            });
        }
    }

    public void onPageScrolled(int n, float f, int n2) {
        if (this.mStrip == null) {
            return;
        }
        this.setScrollingData(n, f);
        int n3 = this.fromTab.getLeft();
        int n4 = this.fromTab.getRight();
        int n5 = this.toTab.getLeft();
        int n6 = this.toTab.getRight();
        this.mStrip.setBounds((int)((float)n3 + (float)(n5 - n3) * this.progress), 0, (int)((float)n4 + (float)(n6 - n4) * this.progress), this.getHeight());
        this.invalidate();
    }

    private void setScrollingData(int n, float f) {
        if (n >= this.getChildCount() - 1) {
            return;
        }
        float f2 = (float)n + f;
        if (this.mPrevProgress > f2) {
            this.toTab = this.getChildAt(n);
            this.fromTab = this.getChildAt(n + 1);
            this.progress = 1.0f - f;
        } else {
            this.toTab = this.getChildAt(n + 1);
            this.fromTab = this.getChildAt(n);
            this.progress = f;
        }
        this.mPrevProgress = f2;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mStrip != null) {
            this.mStrip.draw(canvas);
        }
    }

    public void onFocusChange(View view, boolean bl) {
        if (view == this && bl && this.getChildCount() > 0) {
            this.mSelectedView.requestFocus();
            return;
        }
        if (!bl) {
            return;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view2 = this.getChildAt(i);
            if (view2 != view) continue;
            view2.requestFocus();
            if (!this.isShown()) break;
            this.sendAccessibilityEvent(8);
            break;
        }
    }

    public void setOnTitleClickListener(HomePager.OnTitleClickListener onTitleClickListener) {
        this.mOnTitleClickListener = onTitleClickListener;
    }

    private class ViewClickListener
    implements View.OnClickListener {
        private final int mIndex;

        public ViewClickListener(int n) {
            this.mIndex = n;
        }

        public void onClick(View view) {
            if (TabMenuStrip.this.mOnTitleClickListener != null) {
                TabMenuStrip.this.mOnTitleClickListener.onTitleClicked(this.mIndex);
            }
        }
    }
}

