/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;

public class TopSitesGridItemView
extends RelativeLayout {
    private static final String LOGTAG = "GeckoTopSitesGridItemView";
    private static final int[] STATE_EMPTY = new int[]{16842921};
    private final TextView mTitleView;
    private final ImageView mThumbnailView;
    private String mTitle;
    private String mUrl;
    private String mFaviconURL;
    private Bitmap mThumbnail;
    private boolean mIsPinned = false;
    private boolean mIsEmpty = true;
    private int mLoadId = 0;

    public TopSitesGridItemView(Context context) {
        this(context, null);
    }

    public TopSitesGridItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesGridItemViewStyle);
    }

    public TopSitesGridItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        LayoutInflater.from((Context)context).inflate(R.layout.top_sites_grid_item_view, (ViewGroup)this);
        this.mTitleView = (TextView)this.findViewById(R.id.title);
        this.mThumbnailView = (ImageView)this.findViewById(R.id.thumbnail);
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mIsEmpty) {
            TopSitesGridItemView.mergeDrawableStates((int[])nArray, (int[])STATE_EMPTY);
        }
        return nArray;
    }

    public String getTitle() {
        return !TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mTitle : this.mUrl;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public boolean isPinned() {
        return this.mIsPinned;
    }

    public void setTitle(String string2) {
        if (this.mTitle != null && this.mTitle.equals(string2)) {
            return;
        }
        this.mTitle = string2;
        this.updateTitleView();
    }

    public void setUrl(String string2) {
        if (this.mUrl != null && this.mUrl.equals(string2)) {
            return;
        }
        this.mUrl = string2;
        this.updateTitleView();
    }

    public void setPinned(boolean bl) {
        this.mIsPinned = bl;
        this.mTitleView.setCompoundDrawablesWithIntrinsicBounds(bl ? R.drawable.pin : 0, 0, 0, 0);
    }

    public void displayThumbnail(int n) {
        this.mThumbnailView.setScaleType(ImageView.ScaleType.CENTER);
        this.mThumbnailView.setImageResource(n);
        this.mThumbnailView.setBackgroundColor(0);
    }

    public void displayThumbnail(Bitmap bitmap) {
        if (bitmap == null) {
            this.displayThumbnail(R.drawable.favicon);
            return;
        }
        this.mThumbnail = bitmap;
        Favicons.cancelFaviconLoad(this.mLoadId);
        this.mThumbnailView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mThumbnailView.setImageBitmap(bitmap);
        this.mThumbnailView.setBackgroundDrawable(null);
    }

    public void displayFavicon(Bitmap bitmap, String string2) {
        if (this.mThumbnail != null) {
            return;
        }
        if (bitmap == null) {
            this.displayThumbnail(R.drawable.favicon);
            return;
        }
        if (string2 != null) {
            this.mFaviconURL = string2;
        }
        this.mThumbnailView.setScaleType(ImageView.ScaleType.CENTER);
        this.mThumbnailView.setImageBitmap(bitmap);
        if (this.mFaviconURL != null) {
            this.mThumbnailView.setBackgroundColor(Favicons.getFaviconColor(this.mFaviconURL));
        }
    }

    private void updateTitleView() {
        String string2 = this.getTitle();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mTitleView.setText((CharSequence)string2);
            this.mIsEmpty = false;
        } else {
            this.mTitleView.setText(R.string.home_top_sites_add);
            this.mIsEmpty = true;
        }
        this.refreshDrawableState();
    }

    public void setLoadId(int n) {
        Favicons.cancelFaviconLoad(this.mLoadId);
        this.mLoadId = n;
    }
}

